/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.Failure;
import com.intellij.openapi.externalSystem.model.task.event.FailureResult;
import com.intellij.openapi.externalSystem.model.task.event.OperationResult;
import com.intellij.openapi.externalSystem.model.task.event.SkippedResult;
import com.intellij.openapi.externalSystem.model.task.event.SuccessResult;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventResult;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class AfterTestEvent
extends AbstractTestEvent {
    public AfterTestEvent(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(@NotNull ExternalSystemProgressEvent<? extends TestOperationDescriptor> testEvent) {
        if (testEvent == null) {
            AfterTestEvent.$$$reportNull$$$0(0);
        }
        if (!(testEvent instanceof ExternalSystemFinishEvent)) {
            return;
        }
        String testId = testEvent.getEventId();
        SMTestProxy testProxy = this.findTestProxy(testId);
        if (testProxy == null) {
            return;
        }
        OperationResult result = ((ExternalSystemFinishEvent)testEvent).getOperationResult();
        long startTime = result.getStartTime();
        long endTime = result.getEndTime();
        testProxy.setDuration(endTime - startTime);
        if (result instanceof SuccessResult) {
            testProxy.setFinished();
            return;
        }
        if (result instanceof SkippedResult) {
            testProxy.setTestIgnored(null, null);
            this.getResultsViewer().onTestIgnored(testProxy);
            return;
        }
        if (result instanceof FailureResult) {
            Failure failure = (Failure)((FailureResult)result).getFailures().iterator().next();
            String failureMessage = failure.getMessage();
            String exceptionMessage = failureMessage == null ? "" : failureMessage;
            String stackTrace = failure.getDescription();
            testProxy.setTestFailed(exceptionMessage, stackTrace, false);
        }
    }

    @Override
    public void process(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException {
        if (eventXml == null) {
            AfterTestEvent.$$$reportNull$$$0(1);
        }
        String testId = eventXml.getTestId();
        String startTime = eventXml.getEventTestResultStartTime();
        String endTime = eventXml.getEventTestResultEndTime();
        String exceptionMsg = this.decode(eventXml.getEventTestResultErrorMsg());
        String stackTrace = this.decode(eventXml.getEventTestResultStackTrace());
        TestEventResult result = TestEventResult.fromValue(eventXml.getTestEventResultType());
        SMTestProxy testProxy = this.findTestProxy(testId);
        if (testProxy == null) {
            return;
        }
        try {
            testProxy.setDuration(Long.parseLong(endTime) - Long.parseLong(startTime));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        switch (result) {
            case SUCCESS: {
                testProxy.setFinished();
                break;
            }
            case FAILURE: {
                String failureType = eventXml.getEventTestResultFailureType();
                if ("comparison".equals(failureType)) {
                    String actualText = this.decode(eventXml.getEventTestResultActual());
                    String expectedText = this.decode(eventXml.getEventTestResultExpected());
                    Predicate<String> emptyString = StringUtil::isEmpty;
                    String filePath = (String)ObjectUtils.nullizeByCondition((Object)this.decode(eventXml.getEventTestResultFilePath()), emptyString);
                    String actualFilePath = (String)ObjectUtils.nullizeByCondition((Object)this.decode(eventXml.getEventTestResultActualFilePath()), emptyString);
                    testProxy.setTestComparisonFailed(exceptionMsg, stackTrace, actualText, expectedText, filePath, actualFilePath, true);
                } else {
                    Couple<String> comparisonPair = GradleRunnerUtil.parseComparisonMessage(exceptionMsg);
                    if (comparisonPair != null) {
                        testProxy.setTestComparisonFailed(exceptionMsg, stackTrace, (String)comparisonPair.second, (String)comparisonPair.first);
                    } else {
                        testProxy.setTestFailed(exceptionMsg, stackTrace, "error".equals(failureType));
                    }
                }
                this.getResultsViewer().onTestFailed(testProxy);
                this.getExecutionConsole().getEventPublisher().onTestFailed(testProxy);
                break;
            }
            case SKIPPED: {
                testProxy.setTestIgnored(null, null);
                this.getResultsViewer().onTestIgnored(testProxy);
                this.getExecutionConsole().getEventPublisher().onTestIgnored(testProxy);
                break;
            }
        }
        this.getResultsViewer().onTestFinished(testProxy);
        this.getExecutionConsole().getEventPublisher().onTestFinished(testProxy);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "testEvent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "eventXml";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/gradle/execution/test/runner/events/AfterTestEvent";
        objectArray[2] = "process";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

