/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemMessageEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class OnOutputEvent
extends AbstractTestEvent {
    private static final String OUT = "StdOut";
    private static final String ERR = "StdErr";

    public OnOutputEvent(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException {
        if (eventXml == null) {
            OnOutputEvent.$$$reportNull$$$0(0);
        }
        String testId = eventXml.getTestId();
        String destinationString = eventXml.getTestEventTestDescription();
        String output = this.decode(eventXml.getTestEventTest());
        Key destination = OUT.equals(destinationString) ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR;
        this.doProcess(testId, output, destination);
    }

    @Override
    public void process(@NotNull ExternalSystemProgressEvent<? extends TestOperationDescriptor> testEvent) {
        if (testEvent == null) {
            OnOutputEvent.$$$reportNull$$$0(1);
        }
        if (!(testEvent instanceof ExternalSystemMessageEvent)) {
            return;
        }
        TestOperationDescriptor testDescriptor = (TestOperationDescriptor)testEvent.getDescriptor();
        String testId = testEvent.getEventId();
        String description = ((ExternalSystemMessageEvent)testEvent).getDescription();
        if (description == null) {
            this.doProcess(testId, "", ProcessOutputTypes.STDERR);
        } else if (description.startsWith(OUT)) {
            this.doProcess(testId, description.substring(OUT.length()), ProcessOutputTypes.STDOUT);
        } else if (description.startsWith(ERR)) {
            this.doProcess(testId, description.substring(ERR.length()), ProcessOutputTypes.STDERR);
        }
    }

    private void doProcess(String testId, String output, @NotNull Key type) {
        SMTestProxy testProxy;
        if (type == null) {
            OnOutputEvent.$$$reportNull$$$0(2);
        }
        if ((testProxy = this.findTestProxy(testId)) == null) {
            return;
        }
        testProxy.addOutput(output, type);
        this.getExecutionConsole().getEventPublisher().onTestOutput(testProxy, new TestOutputEvent(testProxy.getName(), output, type == ProcessOutputTypes.STDOUT));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventXml";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testEvent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/events/OnOutputEvent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

