/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.model.impl;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.maven.compiler.MavenPatternFileFilter;
import org.jetbrains.jps.maven.model.impl.FilePattern;

public class MavenResourceFileFilter
implements FileFilter {
    private final File myRoot;
    private final String myRelativeDirectoryPath;
    private final MavenPatternFileFilter myMavenPatternFileFilter;
    private final boolean myAcceptWebXml;

    public MavenResourceFileFilter(@NotNull File rootFile, @NotNull FilePattern filePattern) {
        if (rootFile == null) {
            MavenResourceFileFilter.$$$reportNull$$$0(0);
        }
        if (filePattern == null) {
            MavenResourceFileFilter.$$$reportNull$$$0(1);
        }
        this(rootFile, filePattern, null);
    }

    public MavenResourceFileFilter(@NotNull File rootFile, @NotNull FilePattern filePattern, @Nullable String relativeDirectoryPath) {
        if (rootFile == null) {
            MavenResourceFileFilter.$$$reportNull$$$0(2);
        }
        if (filePattern == null) {
            MavenResourceFileFilter.$$$reportNull$$$0(3);
        }
        this(new MavenPatternFileFilter(filePattern.includes, filePattern.excludes), rootFile, relativeDirectoryPath, false);
    }

    private MavenResourceFileFilter(@NotNull MavenPatternFileFilter filter, @NotNull File rootFile, @Nullable String relativeDirectoryPath, boolean acceptWebXml) {
        if (filter == null) {
            MavenResourceFileFilter.$$$reportNull$$$0(4);
        }
        if (rootFile == null) {
            MavenResourceFileFilter.$$$reportNull$$$0(5);
        }
        this.myMavenPatternFileFilter = filter;
        this.myRoot = rootFile;
        this.myRelativeDirectoryPath = relativeDirectoryPath;
        this.myAcceptWebXml = acceptWebXml;
    }

    @Override
    public boolean accept(@NotNull File file) {
        if (file == null) {
            MavenResourceFileFilter.$$$reportNull$$$0(6);
        }
        String relativePath = FileUtil.getRelativePath((File)this.myRoot, (File)file);
        if (this.myRelativeDirectoryPath != null) {
            relativePath = this.myRelativeDirectoryPath + (relativePath != null ? File.separator + relativePath : "");
        }
        if (relativePath == null) {
            return false;
        }
        String webInfWebXml = "WEB-INF" + File.separator + "web.xml";
        if (this.myAcceptWebXml && FileUtil.pathsEqual((String)webInfWebXml, (String)relativePath)) {
            return true;
        }
        return this.myMavenPatternFileFilter.accept(relativePath);
    }

    public MavenResourceFileFilter acceptingWebXml() {
        return new MavenResourceFileFilter(this.myMavenPatternFileFilter, this.myRoot, this.myRelativeDirectoryPath, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePattern";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/maven/model/impl/MavenResourceFileFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

