/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.files;

import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.GradleDslTransformerFactory;
import com.android.tools.idea.gradle.dsl.parser.GradleDslWriter;
import com.android.tools.idea.gradle.dsl.parser.elements.ElementState;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementEnum;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslGlobalValue;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GradleDslFile
extends GradlePropertiesDslElement {
    private static final Logger LOG = Logger.getInstance(GradleDslFile.class);
    @NotNull
    private final GradlePropertiesDslElement.ElementList myGlobalProperties;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleDslWriter myGradleDslWriter;
    @NotNull
    private final GradleDslParser myGradleDslParser;
    @NotNull
    private final BuildModelContext myBuildModelContext;

    protected GradleDslFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName, @NotNull BuildModelContext context) {
        if (file == null) {
            GradleDslFile.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleDslFile.$$$reportNull$$$0(1);
        }
        if (moduleName == null) {
            GradleDslFile.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GradleDslFile.$$$reportNull$$$0(3);
        }
        super(null, null, GradleNameElement.fake(moduleName));
        this.myGlobalProperties = new GradlePropertiesDslElement.ElementList();
        this.myFile = file;
        this.myProject = project;
        this.myBuildModelContext = context;
        Application application = ApplicationManager.getApplication();
        PsiFile psiFile = (PsiFile)application.runReadAction(() -> PsiManager.getInstance((Project)this.myProject).findFile(this.myFile));
        List factories = GradleDslTransformerFactory.EXTENSION_POINT_NAME.getExtensionList();
        boolean foundFactory = false;
        @NotNull GradleDslParser dslParser = new GradleDslParser.Adapter(context);
        @NotNull GradleDslWriter dslWriter = new GradleDslWriter.Adapter(context);
        if (psiFile == null) {
            LOG.debug("Failed to find psiFile for virtualFile " + this.myFile.getName());
        } else {
            for (GradleDslTransformerFactory factory : factories) {
                if (!factory.canTransform(psiFile)) continue;
                dslParser = factory.createParser(psiFile, context, this);
                dslWriter = factory.createWriter(context);
                this.setPsiElement((PsiElement)psiFile);
                foundFactory = true;
                break;
            }
            if (!foundFactory) {
                LOG.debug("Failed to find transformer for file " + psiFile.getName() + " (" + psiFile.getClass().getCanonicalName() + ")");
            }
        }
        this.myGradleDslWriter = dslWriter;
        this.myGradleDslParser = dslParser;
        this.populateGlobalProperties();
    }

    private void populateGlobalProperties() {
        GradleDslGlobalValue rootDir = new GradleDslGlobalValue((GradleDslElement)this, new File(FileUtil.toCanonicalPath((String)Optional.ofNullable(this.myProject.getBasePath()).orElse(""))).getPath(), "rootDir");
        this.myGlobalProperties.addElement(rootDir, ElementState.DEFAULT, false);
        GradleDslGlobalValue projectDir = new GradleDslGlobalValue((GradleDslElement)this, this.getDirectoryPath().getPath(), "projectDir");
        this.myGlobalProperties.addElement(projectDir, ElementState.DEFAULT, false);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Arrays.asList("1_1", "1_2", "1_3", "1_4", "1_5", "1_6", "1_7", "1_8", "1_9", "1_10", "11", "12", "13", "HIGHER").forEach(s -> builder.put((Object)("VERSION_" + s), (Object)("JavaVersion.VERSION_" + s)));
        ImmutableMap javaVersionValues = builder.build();
        GradleDslElementEnum javaVersion = new GradleDslElementEnum((GradleDslElement)this, GradleNameElement.fake("JavaVersion"), (Map<String, String>)javaVersionValues);
        this.myGlobalProperties.addElement(javaVersion, ElementState.DEFAULT, false);
    }

    @Override
    protected GradleDslElement getElementWhere(@NotNull Predicate<GradlePropertiesDslElement.ElementList.ElementItem> predicate) {
        GradleDslElement result;
        if (predicate == null) {
            GradleDslFile.$$$reportNull$$$0(4);
        }
        if ((result = super.getElementWhere(predicate)) == null) {
            result = this.myGlobalProperties.getElementWhere(predicate);
        }
        return result;
    }

    @Override
    protected GradleDslElement getElementBeforeChildWhere(Predicate<GradlePropertiesDslElement.ElementList.ElementItem> predicate, @NotNull GradleDslElement element, boolean includeSelf) {
        GradleDslElement result;
        if (element == null) {
            GradleDslFile.$$$reportNull$$$0(5);
        }
        if ((result = super.getElementBeforeChildWhere(predicate, element, includeSelf)) == null) {
            result = this.myGlobalProperties.getElementBeforeChildWhere(predicate, element, includeSelf);
        }
        return result;
    }

    public void reparse() {
        this.clear();
        this.parse();
    }

    public void parse() {
        this.myGradleDslParser.parse();
        this.getContext().getDependencyManager().resolveAllIn(this, true);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GradleDslFile.$$$reportNull$$$0(6);
        }
        return project;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            GradleDslFile.$$$reportNull$$$0(7);
        }
        return virtualFile;
    }

    @NotNull
    public File getDirectoryPath() {
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)this.getFile().getParent());
        if (file == null) {
            GradleDslFile.$$$reportNull$$$0(8);
        }
        return file;
    }

    @NotNull
    public GradleDslWriter getWriter() {
        GradleDslWriter gradleDslWriter = this.myGradleDslWriter;
        if (gradleDslWriter == null) {
            GradleDslFile.$$$reportNull$$$0(9);
        }
        return gradleDslWriter;
    }

    @NotNull
    public GradleDslParser getParser() {
        GradleDslParser gradleDslParser = this.myGradleDslParser;
        if (gradleDslParser == null) {
            GradleDslFile.$$$reportNull$$$0(10);
        }
        return gradleDslParser;
    }

    @NotNull
    public BuildModelContext getContext() {
        BuildModelContext buildModelContext = this.myBuildModelContext;
        if (buildModelContext == null) {
            GradleDslFile.$$$reportNull$$$0(11);
        }
        return buildModelContext;
    }

    @NotNull
    public List<BuildModelNotification> getPublicNotifications() {
        List<BuildModelNotification> list = this.myBuildModelContext.getPublicNotifications(this);
        if (list == null) {
            GradleDslFile.$$$reportNull$$$0(12);
        }
        return list;
    }

    public void saveAllChanges() {
        PsiElement element = this.getPsiElement();
        if (element == null) {
            return;
        }
        assert (element instanceof PsiFile);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
        Document document = psiDocumentManager.getDocument((PsiFile)element);
        if (document == null) {
            return;
        }
        if (psiDocumentManager.isDocumentBlockedByPsi(document)) {
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
        }
        FileDocumentManager.getInstance().saveDocument(document);
        if (!psiDocumentManager.isCommitted(document)) {
            psiDocumentManager.commitDocument(document);
        }
    }

    @Nullable
    public VirtualFile tryToFindSettingsFile() {
        if (this instanceof GradleSettingsFile) {
            return this.getFile();
        }
        for (VirtualFile buildFileParent = this.getFile().getParent(); buildFileParent != null; buildFileParent = buildFileParent.getParent()) {
            VirtualFile maybeSettingsFile = this.myBuildModelContext.getGradleSettingsFile(VfsUtilCore.virtualToIoFile((VirtualFile)buildFileParent));
            if (maybeSettingsFile == null) continue;
            return maybeSettingsFile;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/files/GradleDslFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/files/GradleDslFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getWriter";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getParser";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublicNotifications";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementWhere";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementBeforeChildWhere";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

