/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.diff.GitSubmoduleContentRevision;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitSubmodule;
import git4idea.repo.GitSubmoduleKt;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitContentRevision
implements ByteBackedContentRevision {
    @NotNull
    protected final FilePath myFile;
    @NotNull
    private final GitRevisionNumber myRevision;
    @NotNull
    private final Project myProject;
    @Nullable
    private final Charset myCharset;

    protected GitContentRevision(@NotNull FilePath file, @NotNull GitRevisionNumber revision, @NotNull Project project, @Nullable Charset charset) {
        if (file == null) {
            GitContentRevision.$$$reportNull$$$0(0);
        }
        if (revision == null) {
            GitContentRevision.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GitContentRevision.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myFile = file;
        this.myRevision = revision;
        this.myCharset = charset;
    }

    @Nullable
    public Charset getCharset() {
        return this.myCharset;
    }

    @Nullable
    public String getContent() throws VcsException {
        byte[] bytes = this.getContentAsBytes();
        if (bytes == null) {
            return null;
        }
        return ContentRevisionCache.getAsString((byte[])bytes, (FilePath)this.myFile, (Charset)this.myCharset);
    }

    public byte @Nullable [] getContentAsBytes() throws VcsException {
        if (this.myFile.isDirectory()) {
            return null;
        }
        try {
            if (!GitUtil.isHashString(this.myRevision.getRev())) {
                return ContentRevisionCache.loadAsBytes((FilePath)this.myFile, this::loadContent);
            }
            return ContentRevisionCache.getOrLoadAsBytes((Project)this.myProject, (FilePath)this.myFile, (VcsRevisionNumber)this.myRevision, (VcsKey)GitVcs.getKey(), (ContentRevisionCache.UniqueType)ContentRevisionCache.UniqueType.REPOSITORY_CONTENT, this::loadContent);
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private byte @NotNull [] loadContent() throws VcsException {
        VirtualFile root = GitUtil.getRootForFile(this.myProject, this.myFile);
        byte[] byArray = GitFileUtils.getFileContent(this.myProject, root, this.myRevision.getRev(), VcsFileUtil.relativePath((VirtualFile)root, (FilePath)this.myFile));
        if (byArray == null) {
            GitContentRevision.$$$reportNull$$$0(3);
        }
        return byArray;
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.myFile;
        if (filePath == null) {
            GitContentRevision.$$$reportNull$$$0(4);
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        GitRevisionNumber gitRevisionNumber = this.myRevision;
        if (gitRevisionNumber == null) {
            GitContentRevision.$$$reportNull$$$0(5);
        }
        return gitRevisionNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        GitContentRevision test = (GitContentRevision)obj;
        return this.myFile.equals(test.myFile) && this.myRevision.equals(test.myRevision);
    }

    public int hashCode() {
        return this.myFile.hashCode() + this.myRevision.hashCode();
    }

    @Nullable
    public static GitSubmodule getRepositoryIfSubmodule(@NotNull Project project, @NotNull FilePath path) {
        GitRepositoryManager repositoryManager;
        GitRepository candidate;
        if (project == null) {
            GitContentRevision.$$$reportNull$$$0(6);
        }
        if (path == null) {
            GitContentRevision.$$$reportNull$$$0(7);
        }
        if ((candidate = (GitRepository)(repositoryManager = GitRepositoryManager.getInstance(project)).getRepositoryForRootQuick(path)) == null) {
            return null;
        }
        return GitSubmoduleKt.asSubmodule(candidate);
    }

    @NotNull
    public static ContentRevision createRevisionForTypeChange(@NotNull FilePath filePath, @Nullable VcsRevisionNumber revisionNumber, @NotNull Project project) {
        if (filePath == null) {
            GitContentRevision.$$$reportNull$$$0(8);
        }
        if (project == null) {
            GitContentRevision.$$$reportNull$$$0(9);
        }
        if (revisionNumber == null) {
            File file = filePath.getIOFile();
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            if (virtualFile != null) {
                filePath = VcsUtil.getFilePath((VirtualFile)virtualFile);
            }
        }
        return GitContentRevision.createRevision(filePath, revisionNumber, project);
    }

    @NotNull
    public static FilePath createPathFromEscaped(@NotNull VirtualFile vcsRoot, @NotNull String path) throws VcsException {
        if (vcsRoot == null) {
            GitContentRevision.$$$reportNull$$$0(10);
        }
        if (path == null) {
            GitContentRevision.$$$reportNull$$$0(11);
        }
        return GitContentRevision.createPathFromEscaped(vcsRoot, path, false);
    }

    @NotNull
    public static FilePath createPathFromEscaped(@NotNull VirtualFile vcsRoot, @NotNull String path, boolean isDirectory) throws VcsException {
        if (vcsRoot == null) {
            GitContentRevision.$$$reportNull$$$0(12);
        }
        if (path == null) {
            GitContentRevision.$$$reportNull$$$0(13);
        }
        String absolutePath = GitContentRevision.makeAbsolutePath(vcsRoot, GitUtil.unescapePath(path));
        FilePath filePath = VcsUtil.getFilePath((String)absolutePath, (boolean)isDirectory);
        if (filePath == null) {
            GitContentRevision.$$$reportNull$$$0(14);
        }
        return filePath;
    }

    @NotNull
    public static FilePath createPath(@NotNull VirtualFile vcsRoot, @NotNull String unescapedPath) {
        if (vcsRoot == null) {
            GitContentRevision.$$$reportNull$$$0(15);
        }
        if (unescapedPath == null) {
            GitContentRevision.$$$reportNull$$$0(16);
        }
        return GitContentRevision.createPath(vcsRoot, unescapedPath, false);
    }

    @NotNull
    public static FilePath createPath(@NotNull VirtualFile vcsRoot, @NotNull String unescapedPath, boolean isDirectory) {
        if (vcsRoot == null) {
            GitContentRevision.$$$reportNull$$$0(17);
        }
        if (unescapedPath == null) {
            GitContentRevision.$$$reportNull$$$0(18);
        }
        String absolutePath = GitContentRevision.makeAbsolutePath(vcsRoot, unescapedPath);
        FilePath filePath = VcsUtil.getFilePath((String)absolutePath, (boolean)isDirectory);
        if (filePath == null) {
            GitContentRevision.$$$reportNull$$$0(19);
        }
        return filePath;
    }

    @NotNull
    private static String makeAbsolutePath(@NotNull VirtualFile vcsRoot, @NotNull String unescapedPath) {
        if (vcsRoot == null) {
            GitContentRevision.$$$reportNull$$$0(20);
        }
        if (unescapedPath == null) {
            GitContentRevision.$$$reportNull$$$0(21);
        }
        String string = vcsRoot.getPath() + "/" + unescapedPath;
        if (string == null) {
            GitContentRevision.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public static ContentRevision createRevision(@NotNull FilePath filePath, @Nullable VcsRevisionNumber revisionNumber, @NotNull Project project) {
        if (filePath == null) {
            GitContentRevision.$$$reportNull$$$0(23);
        }
        if (project == null) {
            GitContentRevision.$$$reportNull$$$0(24);
        }
        return GitContentRevision.createRevision(filePath, revisionNumber, project, null);
    }

    @NotNull
    public static ContentRevision createRevision(@NotNull FilePath filePath, @Nullable VcsRevisionNumber revisionNumber, @NotNull Project project, @Nullable Charset charset) {
        if (filePath == null) {
            GitContentRevision.$$$reportNull$$$0(25);
        }
        if (project == null) {
            GitContentRevision.$$$reportNull$$$0(26);
        }
        GitSubmodule submodule = GitContentRevision.getRepositoryIfSubmodule(project, filePath);
        if (revisionNumber != null && revisionNumber != VcsRevisionNumber.NULL) {
            if (submodule != null) {
                ContentRevision contentRevision = GitSubmoduleContentRevision.createRevision(submodule, revisionNumber);
                if (contentRevision == null) {
                    GitContentRevision.$$$reportNull$$$0(27);
                }
                return contentRevision;
            }
            return new GitContentRevision(filePath, (GitRevisionNumber)revisionNumber, project, charset);
        }
        if (submodule != null) {
            ContentRevision contentRevision = GitSubmoduleContentRevision.createCurrentRevision(submodule.getRepository());
            if (contentRevision == null) {
                GitContentRevision.$$$reportNull$$$0(28);
            }
            return contentRevision;
        }
        return new CurrentContentRevision(filePath);
    }

    public String toString() {
        return this.myFile.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 19: 
            case 22: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 19: 
            case 22: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 19: 
            case 22: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/GitContentRevision";
                break;
            }
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unescapedPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/GitContentRevision";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadContent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionNumber";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathFromEscaped";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "makeAbsolutePath";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 19: 
            case 22: 
            case 27: 
            case 28: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryIfSubmodule";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRevisionForTypeChange";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createPathFromEscaped";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createPath";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "makeAbsolutePath";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createRevision";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 14: 
            case 19: 
            case 22: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

