/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchPresentation;
import com.intellij.vcs.log.BaseSingleTaskControllerKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0012\u0010\u0019\u001a\f0\u0005\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u001aH\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH&J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0006\u0010 \u001a\u00020\u0016J\b\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020\u0016H\u0002R*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lgit4idea/index/ui/SimpleTabTitleUpdater;", "Lcom/intellij/openapi/Disposable;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "tabName", "", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Ljava/lang/String;)V", "value", "", "Lcom/intellij/vcs/branch/BranchData;", "branches", "setBranches", "(Ljava/util/Set;)V", "disposableFlag", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lorg/jetbrains/annotations/NotNull;", "groupingListener", "Lkotlin/Function1;", "Ljava/beans/PropertyChangeEvent;", "Lkotlin/ParameterName;", "name", "evt", "", "dispose", "getBranches", "getDisplayName", "Lorg/jetbrains/annotations/Nls;", "getRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getTab", "Lcom/intellij/ui/content/Content;", "refresh", "shouldShowBranches", "", "updatePresentation", "intellij.vcs.git"})
public abstract class SimpleTabTitleUpdater
implements Disposable {
    private final CheckedDisposable disposableFlag;
    private Set<? extends BranchData> branches;
    private final Function1<PropertyChangeEvent, Unit> groupingListener;
    private final ChangesTree tree;
    private final String tabName;

    private final void setBranches(Set<? extends BranchData> value) {
        if (Intrinsics.areEqual(this.branches, value)) {
            return;
        }
        this.branches = value;
        this.updatePresentation();
    }

    @NotNull
    public abstract Collection<VirtualFile> getRoots();

    public final void refresh() {
        this.setBranches(this.getBranches());
    }

    private final void updatePresentation() {
        Content content2 = this.getTab();
        if (content2 == null) {
            return;
        }
        Content tab = content2;
        tab.setDisplayName(this.getDisplayName());
        tab.setDescription(BranchPresentation.INSTANCE.getTooltip((Collection)this.branches));
    }

    private final String getDisplayName() {
        String branchesText = BranchPresentation.INSTANCE.getText((Collection)this.branches);
        if (StringsKt.isBlank((CharSequence)branchesText)) {
            String string = VcsBundle.message((String)"tab.title.commit", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VcsBundle.message(\"tab.title.commit\")");
            return string;
        }
        String string = VcsBundle.message((String)"tab.title.commit.to.branch", (Object[])new Object[]{branchesText});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VcsBundle.message(\"tab.t\u2026to.branch\", branchesText)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<BranchData> getBranches() {
        void $this$mapNotNullTo$iv$iv;
        if (!this.shouldShowBranches()) {
            return SetsKt.emptySet();
        }
        Iterable $this$mapNotNull$iv = this.getRoots();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BranchData branchData;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            Project project = this.tree.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"tree.project");
            if (CurrentBranchComponent.Companion.getCurrentBranch(project, it) == null) continue;
            BranchData it$iv$iv = branchData;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    protected boolean shouldShowBranches() {
        ChangesGroupingSupport changesGroupingSupport = this.tree.getGroupingSupport();
        Intrinsics.checkNotNullExpressionValue((Object)changesGroupingSupport, (String)"tree.groupingSupport");
        ChangesGroupingSupport groupingSupport = changesGroupingSupport;
        return !groupingSupport.isAvailable("repository") || !groupingSupport.get("repository");
    }

    private final Content getTab() {
        Project project = this.tree.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"tree.project");
        List list2 = ChangesViewContentManager.Companion.getInstance(project).findContents(new Predicate(this){
            final /* synthetic */ SimpleTabTitleUpdater this$0;

            public final boolean test(Content it) {
                Content content2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"it");
                return Intrinsics.areEqual((Object)content2.getTabName(), (Object)SimpleTabTitleUpdater.access$getTabName$p(this.this$0));
            }
            {
                this.this$0 = simpleTabTitleUpdater;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ChangesViewContentManage\u2026{ it.tabName == tabName }");
        return (Content)CollectionsKt.firstOrNull((List)list2);
    }

    public void dispose() {
        Object object = this.groupingListener;
        if (object != null) {
            Function1<PropertyChangeEvent, Unit> function1 = object;
            object = new PropertyChangeListener(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ void propertyChange(PropertyChangeEvent p0) {
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke((Object)p0), (String)"invoke(...)");
                }
            };
        }
        this.tree.removeGroupingChangeListener((PropertyChangeListener)object);
        this.setBranches(SetsKt.emptySet());
    }

    public SimpleTabTitleUpdater(@NotNull ChangesTree tree2, @NotNull String tabName) {
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        this.tree = tree2;
        this.tabName = tabName;
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"Disposer.newCheckedDisposable()");
        this.disposableFlag = checkedDisposable;
        this.branches = SetsKt.emptySet();
        this.groupingListener = (Function1)new Function1<PropertyChangeEvent, Unit>(this){
            final /* synthetic */ SimpleTabTitleUpdater this$0;

            public final void invoke(@NotNull PropertyChangeEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.refresh();
            }
            {
                this.this$0 = simpleTabTitleUpdater;
                super(1);
            }
        };
        UiNotifyConnector.doWhenFirstShown((JComponent)((JComponent)this.tree), (Runnable)new Runnable(){

            @Override
            public final void run() {
                this.refresh();
            }
        });
        Object object = this.groupingListener;
        if (object != null) {
            Function1<PropertyChangeEvent, Unit> function1 = object;
            object = new /* invalid duplicate definition of identical inner class */;
        }
        this.tree.addGroupingChangeListener((PropertyChangeListener)object);
        Project project = this.tree.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"tree.project");
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        Topic<GitRepositoryChangeListener> topic = GitRepository.GIT_REPO_CHANGE;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"GitRepository.GIT_REPO_CHANGE");
        messageBusConnection.subscribe(topic, (Object)new GitRepositoryChangeListener(){

            @Override
            public final void repositoryChanged(@NotNull GitRepository it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                BaseSingleTaskControllerKt.runInEdt((CheckedDisposable)disposableFlag, (Function0)((Function0)new Function0<Unit>(){

                    public final void invoke() {
                        this.refresh();
                    }
                }));
            }
        });
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.disposableFlag));
    }

    public static final /* synthetic */ String access$getTabName$p(SimpleTabTitleUpdater $this) {
        return $this.tabName;
    }
}

