/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.openapi.diagnostic.Logger;
import git4idea.push.GitPushNativeResult;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitPushNativeResultParser {
    private static final Logger LOG = Logger.getInstance(GitPushNativeResultParser.class);
    private static final Pattern PATTERN = Pattern.compile("^.*([ +\\-\\*!=])\t(\\S+):(\\S+)\t([^(]+)(?:\\((.+)\\))?.*$");
    private static final Pattern RANGE = Pattern.compile("[0-9a-f]+[\\.]{2,3}[0-9a-f]+");

    @NotNull
    public static List<GitPushNativeResult> parse(@NotNull List<String> output) {
        if (output == null) {
            GitPushNativeResultParser.$$$reportNull$$$0(0);
        }
        ArrayList<GitPushNativeResult> results = new ArrayList<GitPushNativeResult>();
        for (String line : output) {
            Matcher matcher = PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            results.add(GitPushNativeResultParser.parseRefResult(matcher, line));
        }
        ArrayList<GitPushNativeResult> arrayList = results;
        if (arrayList == null) {
            GitPushNativeResultParser.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    private static GitPushNativeResult parseRefResult(Matcher matcher, String line) {
        String flag = matcher.group(1);
        String from = matcher.group(2);
        String to = matcher.group(3);
        String summary = matcher.group(4).trim();
        @Nullable String reason = matcher.group(5);
        GitPushNativeResult.Type type = GitPushNativeResultParser.parseType(flag);
        if (type == null) {
            LOG.error("Couldn't parse push result type from flag [" + flag + "] in [" + line + "]");
            return null;
        }
        if (matcher.groupCount() < 4) {
            return null;
        }
        String range = RANGE.matcher(summary).matches() ? summary : null;
        return new GitPushNativeResult(type, from, reason, range);
    }

    private static GitPushNativeResult.Type parseType(String flag) {
        switch (flag.charAt(0)) {
            case ' ': {
                return GitPushNativeResult.Type.SUCCESS;
            }
            case '+': {
                return GitPushNativeResult.Type.FORCED_UPDATE;
            }
            case '-': {
                return GitPushNativeResult.Type.DELETED;
            }
            case '*': {
                return GitPushNativeResult.Type.NEW_REF;
            }
            case '!': {
                return GitPushNativeResult.Type.REJECTED;
            }
            case '=': {
                return GitPushNativeResult.Type.UP_TO_DATE;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/push/GitPushNativeResultParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/push/GitPushNativeResultParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

