/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushSource;
import com.intellij.openapi.util.NlsSafe;
import git4idea.GitLocalBranch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitPushSource
implements PushSource {
    @NotNull
    public static GitPushSource create(@NotNull GitLocalBranch branch) {
        if (branch == null) {
            GitPushSource.$$$reportNull$$$0(0);
        }
        return new OnBranch(branch, null);
    }

    @NotNull
    public static GitPushSource create(@NotNull GitLocalBranch branch, @Nullable String revision) {
        if (branch == null) {
            GitPushSource.$$$reportNull$$$0(1);
        }
        return new OnBranch(branch, revision);
    }

    @NotNull
    public static GitPushSource create(@NotNull String revision) {
        if (revision == null) {
            GitPushSource.$$$reportNull$$$0(2);
        }
        return new DetachedHead(revision);
    }

    @NotNull
    public abstract GitLocalBranch getBranch();

    @NotNull
    public abstract String getRevision();

    public String toString() {
        return this.getPresentation();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "branch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "revision";
                break;
            }
        }
        objectArray[1] = "git4idea/push/GitPushSource";
        objectArray[2] = "create";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class DetachedHead
    extends GitPushSource {
        @NotNull
        private final String myRevision;

        DetachedHead(@NotNull String revision) {
            if (revision == null) {
                DetachedHead.$$$reportNull$$$0(0);
            }
            this.myRevision = revision;
        }

        @NotNull
        public String getPresentation() {
            String string = DvcsUtil.getShortHash((String)this.myRevision);
            if (string == null) {
                DetachedHead.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public GitLocalBranch getBranch() {
            throw new IllegalStateException("Push is not allowed from detached HEAD");
        }

        @Override
        @NotNull
        public String getRevision() {
            String string = this.myRevision;
            if (string == null) {
                DetachedHead.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/push/GitPushSource$DetachedHead";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/push/GitPushSource$DetachedHead";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class OnBranch
    extends GitPushSource {
        @NotNull
        private final GitLocalBranch myBranch;
        @NlsSafe
        private final String myRevision;
        private final boolean myIsHead;

        private OnBranch(@NotNull GitLocalBranch branch, @Nullable String revision) {
            if (branch == null) {
                OnBranch.$$$reportNull$$$0(0);
            }
            this.myBranch = branch;
            this.myIsHead = revision == null;
            this.myRevision = this.myIsHead ? branch.getFullName() : revision;
        }

        @NotNull
        public String getPresentation() {
            String string = this.myIsHead ? this.myBranch.getName() : DvcsUtil.getShortHash((String)this.myRevision);
            if (string == null) {
                OnBranch.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public GitLocalBranch getBranch() {
            GitLocalBranch gitLocalBranch = this.myBranch;
            if (gitLocalBranch == null) {
                OnBranch.$$$reportNull$$$0(2);
            }
            return gitLocalBranch;
        }

        @Override
        @NotNull
        public String getRevision() {
            String string = this.myRevision;
            if (string == null) {
                OnBranch.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branch";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/push/GitPushSource$OnBranch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/push/GitPushSource$OnBranch";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBranch";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

