/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.savedPatches.SavedPatchesUi;
import com.intellij.openapi.vcs.changes.savedPatches.ShelfProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerListener;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import git4idea.i18n.GitBundle;
import git4idea.stash.GitStashTracker;
import git4idea.stash.ui.GitStashProvider;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J\u0012\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lgit4idea/stash/ui/GitStashContentProvider;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "disposeContent", "", "initContent", "Ljavax/swing/JComponent;", "isEditorDiffPreview", "", "isVertical", "returnFocusToToolWindow", "componentToFocus", "Ljava/awt/Component;", "Companion", "GitSavedPatchesUi", "intellij.vcs.git"})
public final class GitStashContentProvider
implements ChangesViewContentProvider {
    private Disposable disposable;
    private final Project project;
    @NonNls
    @NotNull
    private static final String TAB_NAME;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public JComponent initContent() {
        Project $this$service$iv = this.project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GitStashTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        ((GitStashTracker)object).scheduleRefresh();
        Disposable disposable = this.disposable = Disposer.newDisposable((String)"Git Stash Content Provider");
        Intrinsics.checkNotNull((Object)disposable);
        GitSavedPatchesUi savedPatchesUi = new GitSavedPatchesUi(disposable);
        MessageBus messageBus = this.project.getMessageBus();
        Disposable disposable2 = this.disposable;
        Intrinsics.checkNotNull((Object)disposable2);
        messageBus.connect(disposable2).subscribe(ChangesViewContentManagerListener.TOPIC, (Object)new ChangesViewContentManagerListener(this, savedPatchesUi){
            final /* synthetic */ GitStashContentProvider this$0;
            final /* synthetic */ GitSavedPatchesUi $savedPatchesUi;

            public void toolWindowMappingChanged() {
                SavedPatchesUi.updateLayout$default((SavedPatchesUi)this.$savedPatchesUi, (boolean)GitStashContentProvider.access$isVertical(this.this$0), (boolean)GitStashContentProvider.access$isEditorDiffPreview(this.this$0), (boolean)false, (int)4, null);
            }
            {
                this.this$0 = this$0;
                this.$savedPatchesUi = $captured_local_variable$1;
            }
        });
        MessageBus messageBus2 = this.project.getMessageBus();
        Disposable disposable3 = this.disposable;
        Intrinsics.checkNotNull((Object)disposable3);
        MessageBusConnection messageBusConnection = messageBus2.connect(disposable3);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"ToolWindowManagerListener.TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(this, savedPatchesUi){
            final /* synthetic */ GitStashContentProvider this$0;
            final /* synthetic */ GitSavedPatchesUi $savedPatchesUi;

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                SavedPatchesUi.updateLayout$default((SavedPatchesUi)this.$savedPatchesUi, (boolean)GitStashContentProvider.access$isVertical(this.this$0), (boolean)GitStashContentProvider.access$isEditorDiffPreview(this.this$0), (boolean)false, (int)4, null);
            }
            {
                this.this$0 = this$0;
                this.$savedPatchesUi = $captured_local_variable$1;
            }
        });
        return (JComponent)((Object)savedPatchesUi);
    }

    private final boolean isVertical() {
        ToolWindow toolWindow = ChangesViewContentManager.Companion.getToolWindowFor(this.project, TAB_NAME);
        return toolWindow != null && (toolWindow = toolWindow.getAnchor()) != null && !toolWindow.isHorizontal();
    }

    private final boolean isEditorDiffPreview() {
        return ChangesViewContentManager.Companion.isCommitToolWindowShown(this.project);
    }

    private final void returnFocusToToolWindow(Component componentToFocus) {
        ToolWindow toolWindow = ChangesViewContentManager.Companion.getToolWindowFor(this.project, TAB_NAME);
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        if (componentToFocus == null) {
            toolWindow2.activate(null);
            return;
        }
        toolWindow2.activate(new Runnable(this, componentToFocus){
            final /* synthetic */ GitStashContentProvider this$0;
            final /* synthetic */ Component $componentToFocus;

            public final void run() {
                IdeFocusManager.getInstance((Project)GitStashContentProvider.access$getProject$p(this.this$0)).requestFocus(this.$componentToFocus, true);
            }
            {
                this.this$0 = gitStashContentProvider;
                this.$componentToFocus = component2;
            }
        }, false);
    }

    public void disposeContent() {
        block0: {
            Disposable disposable;
            Disposable disposable2 = this.disposable;
            if (disposable2 == null) break block0;
            Disposable it = disposable = disposable2;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
    }

    public GitStashContentProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    static {
        Companion = new Companion(null);
        TAB_NAME = "Stash";
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lgit4idea/stash/ui/GitStashContentProvider$GitSavedPatchesUi;", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesUi;", "parent", "Lcom/intellij/openapi/Disposable;", "(Lgit4idea/stash/ui/GitStashContentProvider;Lcom/intellij/openapi/Disposable;)V", "intellij.vcs.git"})
    private final class GitSavedPatchesUi
    extends SavedPatchesUi {
        public GitSavedPatchesUi(Disposable parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(GitStashContentProvider.this.project, CollectionsKt.listOf((Object[])new Object[]{new GitStashProvider(GitStashContentProvider.this.project, parent), new ShelfProvider(GitStashContentProvider.this.project, parent)}), GitStashContentProvider.this.isVertical(), GitStashContentProvider.this.isEditorDiffPreview(), (Function1)new Function1<Component, Unit>(GitStashContentProvider.this){

                public final void invoke(@Nullable Component p1) {
                    ((GitStashContentProvider)this.receiver).returnFocusToToolWindow(p1);
                }
            }, parent);
            this.getTree().getEmptyText().appendLine("").appendLine(AllIcons.General.ContextHelp, GitBundle.message("stash.empty.text.help.link", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, (ActionListener)2.INSTANCE);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/stash/ui/GitStashContentProvider$Companion;", "", "()V", "TAB_NAME", "", "getTAB_NAME", "()Ljava/lang/String;", "intellij.vcs.git"})
    public static final class Companion {
        @NotNull
        public final String getTAB_NAME() {
            return TAB_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

