/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.util.SystemInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0004\u001a\u00020\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0000\u001a\u0018\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0000\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\n"}, d2={"OS_PREFIXES", "", "", "[Ljava/lang/String;", "getOsFolderName", "toIdeaPath", "path", "toRepositoryPath", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "intellij.settingsRepository"})
public final class IcsUrlBuilderKt {
    private static final String[] OS_PREFIXES = new String[]{"_mac/", "_windows/", "_linux/", "_freebsd/", "_unix/"};

    @NotNull
    public static final String getOsFolderName() {
        return SystemInfo.isMac ? "_mac" : (SystemInfo.isWindows ? "_windows" : (SystemInfo.isLinux ? "_linux" : (SystemInfo.isFreeBSD ? "_freebsd" : (SystemInfo.isUnix ? "_unix" : "_unknown"))));
    }

    @NotNull
    public static final String toRepositoryPath(@NotNull String path, @NotNull RoamingType roamingType) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        if (roamingType == RoamingType.PER_OS && StringsKt.startsWith$default((String)path, (String)StoreUtilKt.getPerOsSettingsStorageFolderName(), (boolean)false, (int)2, null)) {
            String pathWithoutOsPrefix = StringsKt.removePrefix((String)path, (CharSequence)(StoreUtilKt.getPerOsSettingsStorageFolderName() + "/"));
            return IcsUrlBuilderKt.getOsFolderName() + "/" + pathWithoutOsPrefix;
        }
        return path;
    }

    @NotNull
    public static final String toIdeaPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        for (String prefix : OS_PREFIXES) {
            String result = StringsKt.removePrefix((String)path, (CharSequence)prefix);
            if (result == path) continue;
            return result;
        }
        return path;
    }
}

