/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.indexing.shared.download.SharedIndexAuthException;
import com.intellij.indexing.shared.download.SharedIndexAuthParams;
import com.intellij.indexing.shared.download.SharedIndexDownloadAuthExtension;
import com.intellij.indexing.shared.download.SharedIndexDownloadAuthExtensionKt;
import com.intellij.indexing.shared.download.SharedIndexDownloadLoggerKt;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexAuthHolder;", "", "()V", "resolveHeaders", "", "", "fullRequestUrl", "request", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.indexing.shared"})
public final class SharedIndexAuthHolder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Map<String, String> resolveHeaders(@NotNull String fullRequestUrl, @NotNull SharedIndexLookupRequest request, @NotNull ProgressIndicator indicator) {
        Map<String, String> map;
        Intrinsics.checkNotNullParameter((Object)fullRequestUrl, (String)"fullRequestUrl");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        SharedIndexAuthParams authId = request.getAuthId();
        if (authId == null) {
            return MapsKt.emptyMap();
        }
        SharedIndexDownloadAuthExtension it = SharedIndexDownloadAuthExtensionKt.resolveIndexDownloadAuthExtension(authId);
        if (it == null) {
            throw (Throwable)new SharedIndexAuthException("Failed to find the shared index auth extension '" + authId + "'", null, 2, null);
        }
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            Map<String, String> map2;
            boolean bl = false;
            try {
                map2 = it.tryGenerateToken(fullRequestUrl, indicator);
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    throw t;
                }
                SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Failed to get shared indexes request headers from the auth extension '" + authId + "' for " + fullRequestUrl + " and " + request + ". " + t.getMessage(), t);
                map2 = null;
            }
            map = map2;
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
        Map<String, String> headers = map;
        if (headers == null) {
            throw (Throwable)new SharedIndexAuthException("Failed to get shared indexes request headers from the auth extension '" + authId + "' for " + fullRequestUrl + " and " + request, null, 2, null);
        }
        return headers;
    }
}

