/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.util;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.BufferedInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/intellij/indexing/shared/util/CountingInputStream;", "Ljava/io/InputStream;", "inputStream", "(Ljava/io/InputStream;)V", "bytesRead", "", "getBytesRead", "()J", "setBytesRead", "(J)V", "hasher", "Lcom/google/common/hash/Hasher;", "getHasher", "()Lcom/google/common/hash/Hasher;", "Ljava/io/BufferedInputStream;", "getInputStream", "()Ljava/io/BufferedInputStream;", "close", "", "read", "", "b", "", "off", "len", "intellij.indexing.shared"})
final class CountingInputStream
extends InputStream {
    @NotNull
    private final BufferedInputStream inputStream;
    @NotNull
    private final Hasher hasher;
    private long bytesRead;

    @NotNull
    public final BufferedInputStream getInputStream() {
        return this.inputStream;
    }

    @NotNull
    public final Hasher getHasher() {
        return this.hasher;
    }

    public final long getBytesRead() {
        return this.bytesRead;
    }

    public final void setBytesRead(long l) {
        this.bytesRead = l;
    }

    @Override
    public int read() {
        byte[] tmp = new byte[1];
        if (this.read(tmp, 0, 1) != 1) {
            return -1;
        }
        return tmp[0] & 0xFF;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int sz = this.inputStream.read(b, off, len);
        if (sz > 0) {
            this.bytesRead += (long)sz;
            this.hasher.putBytes(b, off, sz);
        }
        return sz;
    }

    @Override
    public void close() {
        this.inputStream.close();
    }

    public CountingInputStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        InputStream inputStream2 = inputStream;
        int n = 0x100000;
        this.inputStream = inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n);
        Hasher hasher = Hashing.sha256().newHasher();
        Intrinsics.checkNotNullExpressionValue((Object)hasher, (String)"Hashing.sha256().newHasher()");
        this.hasher = hasher;
    }
}

