/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

final class HyperlinkUtil {
    @NonNls
    public static final String AT_ATR = "at";
    @NonNls
    private static final String RUNNING_SUBSTRING = "Running ";
    @NonNls
    private static final String TEST_SUBSTRING = "TEST ";
    @NonNls
    private static final String FAILED_SUBSTRING = " FAILED";
    @NonNls
    private static final String FAILED_SUBSTRING_2 = " FAILED\n";

    private HyperlinkUtil() {
    }

    static PlaceInfo parseStackLine(Project project, String line) {
        int lineNumber;
        int rparenthIndex;
        int atIndex = line.indexOf("\tat ");
        if (atIndex < 0) {
            return null;
        }
        int lparenthIndex = line.indexOf(40, atIndex);
        if (lparenthIndex < 0) {
            return null;
        }
        int lastDotIndex = line.lastIndexOf(46, lparenthIndex);
        if (lastDotIndex < 0 || lastDotIndex < atIndex) {
            return null;
        }
        String className = line.substring(atIndex + AT_ATR.length() + 1, lastDotIndex).trim();
        int dollarIndex = className.indexOf(36);
        if (dollarIndex >= 0) {
            className = className.substring(0, dollarIndex);
        }
        if ((rparenthIndex = line.indexOf(41, lparenthIndex)) < 0) {
            return null;
        }
        String fileAndLine = line.substring(lparenthIndex + 1, rparenthIndex).trim();
        int colonIndex = fileAndLine.lastIndexOf(58);
        if (colonIndex < 0) {
            return null;
        }
        String lineString = fileAndLine.substring(colonIndex + 1);
        String file = fileAndLine.substring(0, colonIndex);
        try {
            lineNumber = Integer.parseInt(lineString);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return HyperlinkUtil.makePlaceInfo(className, file, lineNumber, project, lparenthIndex, rparenthIndex);
    }

    private static PlaceInfo makePlaceInfo(@NlsSafe String className, @NlsSafe String fileName, int line, Project project, int lparenthIndex, int rparenthIndex) {
        PlaceInfo[] info = new PlaceInfo[1];
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
            if (aClass == null) {
                return;
            }
            PsiFile file = aClass.getContainingFile();
            String fileName1 = fileName.replace(File.separatorChar, '/');
            int slashIndex = fileName1.lastIndexOf(47);
            String shortFileName = slashIndex < 0 ? fileName : fileName.substring(slashIndex + 1);
            String name = file.getName();
            if (!name.equalsIgnoreCase(shortFileName)) {
                return;
            }
            info[0] = new PlaceInfo(file.getVirtualFile(), line, 1, lparenthIndex, rparenthIndex);
        });
        return info[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    static PlaceInfo parseJUnitMessage(Project project, String message) {
        int endIndex;
        int startIndex;
        if (message.startsWith(RUNNING_SUBSTRING)) {
            startIndex = RUNNING_SUBSTRING.length();
            endIndex = message.length();
        } else {
            if (!message.startsWith(TEST_SUBSTRING)) return null;
            startIndex = TEST_SUBSTRING.length();
            if (message.endsWith(FAILED_SUBSTRING)) {
                endIndex = message.length() - FAILED_SUBSTRING.length();
            } else {
                if (!message.endsWith(FAILED_SUBSTRING_2)) return null;
                endIndex = message.length() - FAILED_SUBSTRING_2.length();
            }
        }
        if (endIndex < startIndex) {
            return null;
        }
        String possibleTestClassName = message.substring(startIndex, endIndex);
        PsiFile[] psiFile = new PsiFile[1];
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(possibleTestClassName, GlobalSearchScope.allScope((Project)project));
            if (psiClass == null) {
                return;
            }
            PsiElement parent = psiClass.getParent();
            if (parent instanceof PsiFile) {
                psiFile[0] = (PsiFile)parent;
            }
        });
        if (psiFile[0] != null) return new PlaceInfo(psiFile[0].getVirtualFile(), 1, 1, startIndex, endIndex - 1);
        return null;
    }

    static final class PlaceInfo {
        private final VirtualFile myFile;
        private final int myLine;
        private final int myColumn;
        private final int myLinkStartIndex;
        private final int myLinkEndIndex;

        PlaceInfo(VirtualFile file, int line, int column, int linkStartIndex, int linkEndIndex) {
            this.myFile = file;
            this.myLine = line;
            this.myColumn = column;
            this.myLinkStartIndex = linkStartIndex;
            this.myLinkEndIndex = linkEndIndex;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public int getLine() {
            return this.myLine;
        }

        public int getColumn() {
            return this.myColumn;
        }

        public int getLinkStartIndex() {
            return this.myLinkStartIndex;
        }

        public int getLinkEndIndex() {
            return this.myLinkEndIndex;
        }
    }
}

