/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.TextCopyProvider;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildModelBase;
import com.intellij.lang.ant.config.AntBuildTargetBase;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.execution.AntBuildMessageView;
import com.intellij.lang.ant.config.execution.AntMessage;
import com.intellij.lang.ant.config.execution.AntOutputView;
import com.intellij.lang.ant.config.execution.HyperlinkUtil;
import com.intellij.lang.ant.config.execution.MessageNode;
import com.intellij.lang.ant.config.execution.MessageTreeRenderer;
import com.intellij.lang.ant.config.impl.BuildTask;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TreeView
implements AntOutputView,
OccurenceNavigator {
    private Tree myTree;
    private DefaultTreeModel myTreeModel;
    private TreePath myParentPath = null;
    private final ArrayList<MessageNode> myMessageItems = new ArrayList();
    private final JPanel myPanel;
    private boolean myActionsEnabled = true;
    private String myCurrentTaskName;
    private final Project myProject;
    private final AntBuildFile myBuildFile;
    private DefaultMutableTreeNode myStatusNode;
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private OccurenceNavigatorSupport myOccurenceNavigatorSupport;
    private final boolean myAutoCollapseTargets;
    @NonNls
    public static final String ROOT_TREE_USER_OBJECT = "root";
    @NonNls
    public static final String JUNIT_TASK_NAME = "junit";

    public TreeView(Project project, AntBuildFile buildFile) {
        this.myProject = project;
        this.myBuildFile = buildFile;
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return AntConfigurationBase.getInstance(TreeView.this.myProject).isAutoScrollToSource();
            }

            protected void setAutoScrollMode(boolean state) {
                AntConfigurationBase.getInstance(TreeView.this.myProject).setAutoScrollToSource(state);
            }
        };
        this.myPanel = this.createPanel();
        this.myAutoCollapseTargets = buildFile instanceof AntBuildFileBase && ((AntBuildFileBase)this.myBuildFile).isCollapseFinishedTargets();
    }

    @Override
    public String getId() {
        return "_tree_view_";
    }

    @Override
    public JComponent getComponent() {
        return this.myPanel;
    }

    private JPanel createPanel() {
        this.createModel();
        this.myTree = new MyTree();
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.updateUI();
        this.myTree.setLargeModel(true);
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                TreeView.this.popupInvoked(comp, x, y);
            }
        });
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
        EditSourceOnEnterKeyHandler.install((JTree)this.myTree);
        this.myAutoScrollToSourceHandler.install((JTree)this.myTree);
        this.myOccurenceNavigatorSupport = new OccurenceNavigatorSupport((JTree)this.myTree){

            protected Navigatable createDescriptorForNode(@NotNull DefaultMutableTreeNode node) {
                if (node == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!(node instanceof MessageNode)) {
                    return null;
                }
                MessageNode messageNode = (MessageNode)node;
                AntBuildMessageView.MessageType type = messageNode.getType();
                if (type != AntBuildMessageView.MessageType.MESSAGE && type != AntBuildMessageView.MessageType.ERROR) {
                    return null;
                }
                if (!TreeView.isValid(messageNode.getFile())) {
                    return null;
                }
                return PsiNavigationSupport.getInstance().createNavigatable(TreeView.this.myProject, messageNode.getFile(), messageNode.getOffset());
            }

            @NotNull
            public String getNextOccurenceActionName() {
                String string = AntBundle.message("ant.execution.next.error.warning.action.name", new Object[0]);
                if (string == null) {
                    3.$$$reportNull$$$0(1);
                }
                return string;
            }

            @NotNull
            public String getPreviousOccurenceActionName() {
                String string = AntBundle.message("ant.execution.previous.error.warning.action.name", new Object[0]);
                if (string == null) {
                    3.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/ant/config/execution/TreeView$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/ant/config/execution/TreeView$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNextOccurenceActionName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPreviousOccurenceActionName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createDescriptorForNode";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        JScrollPane treePane = MessageTreeRenderer.install((JTree)this.myTree);
        if (this.myBuildFile instanceof AntBuildFileBase) {
            ((MessageTreeRenderer)((Object)this.myTree.getCellRenderer())).setUseAnsiColor(((AntBuildFileBase)this.myBuildFile).isColoredOutputMessages());
        }
        return JBUI.Panels.simplePanel((Component)treePane);
    }

    private void createModel() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(ROOT_TREE_USER_OBJECT);
        this.myTreeModel = new DefaultTreeModel(rootNode);
        this.myParentPath = new TreePath(rootNode);
    }

    public void setActionsEnabled(boolean actionsEnabled) {
        this.myActionsEnabled = actionsEnabled;
        if (actionsEnabled) {
            this.myTreeModel.reload();
        }
    }

    @Override
    public Object addMessage(AntMessage message) {
        MessageNode messageNode = this.createMessageNode(message);
        MutableTreeNode parentNode = (MutableTreeNode)this.myParentPath.getLastPathComponent();
        this.myTreeModel.insertNodeInto(messageNode, parentNode, parentNode.getChildCount());
        this.myMessageItems.add(messageNode);
        this.handleExpansion();
        return messageNode;
    }

    public void addMessages(AntMessage[] messages) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.myParentPath.getLastPathComponent();
        int[] indices = new int[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            AntMessage message = messages[i];
            MessageNode messageNode = this.createMessageNode(message);
            indices[i] = parentNode.getChildCount();
            parentNode.insert(messageNode, indices[i]);
            this.myMessageItems.add(messageNode);
        }
        this.myTreeModel.nodesWereInserted(parentNode, indices);
        this.handleExpansion();
    }

    private MessageNode createMessageNode(AntMessage message) {
        HyperlinkUtil.PlaceInfo info;
        String text = message.getText();
        boolean allowToShowPosition = true;
        if (JUNIT_TASK_NAME.equals(this.myCurrentTaskName) && (info = HyperlinkUtil.parseJUnitMessage(this.myProject, text)) != null) {
            message = new AntMessage(message.getType(), message.getPriority(), text, info.getFile(), 1, 1);
            allowToShowPosition = false;
        }
        return new MessageNode(message, this.myProject, allowToShowPosition);
    }

    private void handleExpansion() {
        if (this.myActionsEnabled && !this.myTree.hasBeenExpanded(this.myParentPath)) {
            this.myTree.expandPath(this.myParentPath);
        }
    }

    void scrollToLastMessage() {
        if (this.myTree == null) {
            return;
        }
        int count = this.myTree.getRowCount();
        if (count > 0) {
            int row = count - 1;
            TreeUtil.selectPath((JTree)this.myTree, (TreePath)this.myTree.getPathForRow(row));
        }
    }

    @Override
    public void addJavacMessage(AntMessage message, @NlsSafe String url) {
        String messagePrefix = TreeView.printMessage(message, url);
        this.addJavacMessageImpl(message.withText(messagePrefix + message.getText()));
    }

    @NotNull
    @NlsSafe
    static String printMessage(@NotNull AntMessage message, @NlsSafe String url) {
        if (message == null) {
            TreeView.$$$reportNull$$$0(0);
        }
        StringBuilder builder = new StringBuilder();
        VirtualFile file = message.getFile();
        if (message.getLine() > 0) {
            if (file != null) {
                ApplicationManager.getApplication().runReadAction(() -> {
                    String presentableUrl = file.getPresentableUrl();
                    builder.append(presentableUrl);
                    builder.append(' ');
                });
            } else if (url != null) {
                builder.append(url);
                builder.append(' ');
            }
            builder.append('(');
            builder.append(message.getLine());
            builder.append(':');
            builder.append(message.getColumn());
            builder.append(") ");
        }
        String string = builder.toString();
        if (string == null) {
            TreeView.$$$reportNull$$$0(1);
        }
        return string;
    }

    private void addJavacMessageImpl(AntMessage message) {
        MutableTreeNode parentNode = (MutableTreeNode)this.myParentPath.getLastPathComponent();
        MessageNode messageNode = new MessageNode(message, this.myProject, false);
        this.myTreeModel.insertNodeInto(messageNode, parentNode, parentNode.getChildCount());
        this.myMessageItems.add(messageNode);
        this.handleExpansion();
    }

    @Override
    public void addException(AntMessage exception, boolean showFullTrace) {
        MessageNode exceptionRootNode = null;
        StringTokenizer tokenizer = new StringTokenizer(exception.getText(), "\r\n");
        while (tokenizer.hasMoreElements()) {
            HyperlinkUtil.PlaceInfo info;
            String line = (String)tokenizer.nextElement();
            if (exceptionRootNode == null) {
                exceptionRootNode = new MessageNode(exception.withText(line), this.myProject, true);
                this.myMessageItems.add(exceptionRootNode);
                continue;
            }
            if (!showFullTrace) continue;
            if (StringUtil.startsWithChar((CharSequence)line, (char)'\t')) {
                line = line.substring(1);
            }
            VirtualFile file = (info = HyperlinkUtil.parseStackLine(this.myProject, "\t" + line)) != null ? info.getFile() : null;
            int lineNumber = info != null ? info.getLine() : 0;
            int column = info != null ? info.getColumn() : 1;
            AntMessage newMessage = new AntMessage(exception.getType(), exception.getPriority(), line, file, lineNumber, column);
            MessageNode child = new MessageNode(newMessage, this.myProject, false);
            exceptionRootNode.add(child);
            this.myMessageItems.add(child);
        }
        if (exceptionRootNode == null) {
            return;
        }
        MutableTreeNode parentNode = (MutableTreeNode)this.myParentPath.getLastPathComponent();
        this.myTreeModel.insertNodeInto(exceptionRootNode, parentNode, parentNode.getChildCount());
        this.handleExpansion();
    }

    public void collapseAll() {
        TreeUtil.collapseAll((JTree)this.myTree, (int)2);
    }

    public void expandAll() {
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        TreePath leadSelectionPath = this.myTree.getLeadSelectionPath();
        for (int row = 0; row < this.myTree.getRowCount(); ++row) {
            this.myTree.expandRow(row);
        }
        if (selectionPaths != null) {
            this.myTree.setSelectionPaths(selectionPaths);
        }
        if (leadSelectionPath != null) {
            this.myTree.scrollPathToVisible(leadSelectionPath);
        }
    }

    public void clearAllMessages() {
        for (MessageNode messageItem : this.myMessageItems) {
            messageItem.clearRangeMarker();
        }
        this.myMessageItems.clear();
        this.myStatusNode = null;
        this.createModel();
        this.myTree.setModel((TreeModel)this.myTreeModel);
    }

    @Override
    public void startBuild(AntMessage message) {
    }

    @Override
    public void buildFailed(AntMessage message) {
        this.addMessage(message);
    }

    @Override
    public void startTarget(AntMessage message) {
        this.collapseTargets();
        MessageNode targetNode = (MessageNode)this.addMessage(message);
        this.myParentPath = this.myParentPath.pathByAddingChild(targetNode);
    }

    private void collapseTargets() {
        if (this.myAutoCollapseTargets) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myTreeModel.getRoot();
            for (int i = 0; i < root.getChildCount(); ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
                this.myTree.collapsePath(new TreePath(node.getPath()));
            }
        }
    }

    @Override
    public void startTask(AntMessage message) {
        this.myCurrentTaskName = message.getText();
        MessageNode taskNode = (MessageNode)this.addMessage(message);
        this.myParentPath = this.myParentPath.pathByAddingChild(taskNode);
    }

    private void popupInvoked(Component component, int x, int y) {
        TreePath path = this.myTree.getLeadSelectionPath();
        if (path == null) {
            return;
        }
        if (!(path.getLastPathComponent() instanceof MessageNode)) {
            return;
        }
        if (this.getData(CommonDataKeys.NAVIGATABLE_ARRAY.getName()) == null) {
            return;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction("EditSource"));
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("AntMessagesPopup", (ActionGroup)group);
        menu.getComponent().show(component, x, y);
    }

    @Nullable
    private MessageNode getSelectedItem() {
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        if (!(path.getLastPathComponent() instanceof MessageNode)) {
            return null;
        }
        return (MessageNode)path.getLastPathComponent();
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            TreeView.$$$reportNull$$$0(2);
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            Navigatable descriptor;
            MessageNode item = this.getSelectedItem();
            if (item == null) {
                return null;
            }
            if (TreeView.isValid(item.getFile())) {
                return PsiNavigationSupport.getInstance().createNavigatable(this.myProject, item.getFile(), item.getOffset());
            }
            if (item.getType() == AntBuildMessageView.MessageType.TARGET && (descriptor = this.getDescriptorForTargetNode(item)) != null && descriptor.canNavigate()) {
                return descriptor;
            }
            if (item.getType() == AntBuildMessageView.MessageType.TASK && (descriptor = this.getDescriptorForTaskNode(item)) != null && descriptor.canNavigate()) {
                return descriptor;
            }
        }
        return null;
    }

    @Nullable
    private Navigatable getDescriptorForTargetNode(MessageNode node) {
        String targetName = node.getText()[0];
        AntBuildTargetBase target = (AntBuildTargetBase)this.myBuildFile.getModel().findTarget(targetName);
        return target == null ? null : target.getOpenFileDescriptor();
    }

    @Nullable
    private Navigatable getDescriptorForTaskNode(MessageNode node) {
        String[] text = node.getText();
        if (text == null || text.length == 0) {
            return null;
        }
        String taskName = text[0];
        TreeNode parentNode = node.getParent();
        if (!(parentNode instanceof MessageNode)) {
            return null;
        }
        MessageNode messageNode = (MessageNode)parentNode;
        if (messageNode.getType() != AntBuildMessageView.MessageType.TARGET) {
            return null;
        }
        BuildTask task = ((AntBuildModelBase)this.myBuildFile.getModel()).findTask(messageNode.getText()[0], taskName);
        return task == null ? null : task.getOpenFileDescriptor();
    }

    private static boolean isValid(VirtualFile file) {
        return file != null && (Boolean)ReadAction.compute(() -> file.isValid()) != false;
    }

    @Override
    public void finishBuild(@Nls String messageText) {
        this.collapseTargets();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myTreeModel.getRoot();
        this.myStatusNode = new DefaultMutableTreeNode(messageText);
        this.myTreeModel.insertNodeInto(this.myStatusNode, root, root.getChildCount());
    }

    public void scrollToStatus() {
        if (this.myStatusNode != null) {
            TreeUtil.selectPath((JTree)this.myTree, (TreePath)new TreePath(this.myStatusNode.getPath()));
        }
    }

    @Override
    public void finishTarget() {
        TreePath parentPath = this.myParentPath.getParentPath();
        if (parentPath != null) {
            this.myParentPath = parentPath;
        }
    }

    @Override
    public void finishTask() {
        this.myCurrentTaskName = null;
        TreePath parentPath = this.myParentPath.getParentPath();
        if (parentPath != null) {
            this.myParentPath = parentPath;
        }
    }

    @Nullable
    private static TreePath getFirstErrorPath(TreePath treePath) {
        AntBuildMessageView.MessageType type;
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode instanceof MessageNode && (type = ((MessageNode)treeNode).getType()) == AntBuildMessageView.MessageType.ERROR) {
            return treePath;
        }
        if (treeNode.getChildCount() == 0) {
            return null;
        }
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode childNode = treeNode.getChildAt(i);
            TreePath childPath = treePath.pathByAddingChild(childNode);
            TreePath usagePath = TreeView.getFirstErrorPath(childPath);
            if (usagePath == null) continue;
            return usagePath;
        }
        return null;
    }

    public void scrollToFirstError() {
        TreePath path = TreeView.getFirstErrorPath(new TreePath(this.myTreeModel.getRoot()));
        if (path != null) {
            TreeUtil.selectPath((JTree)this.myTree, (TreePath)path);
        }
    }

    public TreeSelection getSelection() {
        Object[] paths;
        TreeSelection selection = new TreeSelection();
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return selection;
        }
        for (Object o : paths = path.getPath()) {
            if (!(o instanceof MessageNode)) continue;
            MessageNode messageNode = (MessageNode)o;
            AntBuildMessageView.MessageType type = messageNode.getType();
            if (type == AntBuildMessageView.MessageType.TARGET) {
                selection.mySelectedTarget = messageNode.getText()[0];
                continue;
            }
            if (type != AntBuildMessageView.MessageType.TASK) continue;
            selection.mySelectedTask = messageNode.getText()[0];
        }
        return selection;
    }

    public boolean restoreSelection(TreeSelection treeSelection) {
        if (treeSelection.isEmpty()) {
            return false;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myTreeModel.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            MessageNode messageNode;
            String[] text;
            TreeNode node = root.getChildAt(i);
            if (!(node instanceof MessageNode) || (text = (messageNode = (MessageNode)node).getText()).length == 0 || !Objects.equals(treeSelection.mySelectedTarget, text[0])) continue;
            TreePath pathToSelect = new TreePath(messageNode.getPath());
            Enumeration<TreeNode> enumeration = messageNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode o = enumeration.nextElement();
                if (!(o instanceof MessageNode)) continue;
                messageNode = (MessageNode)o;
                if (!Objects.equals(treeSelection.mySelectedTask, text[0])) continue;
                pathToSelect = new TreePath(messageNode.getPath());
                break;
            }
            TreeUtil.selectPath((JTree)this.myTree, (TreePath)pathToSelect);
            this.myTree.expandPath(pathToSelect);
            return true;
        }
        return false;
    }

    ToggleAction createToggleAutoscrollAction() {
        return this.myAutoScrollToSourceHandler.createToggleAction();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string = this.myOccurenceNavigatorSupport.getNextOccurenceActionName();
        if (string == null) {
            TreeView.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = this.myOccurenceNavigatorSupport.getPreviousOccurenceActionName();
        if (string == null) {
            TreeView.$$$reportNull$$$0(4);
        }
        return string;
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myOccurenceNavigatorSupport.goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myOccurenceNavigatorSupport.goPreviousOccurence();
    }

    public boolean hasNextOccurence() {
        return this.myOccurenceNavigatorSupport.hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.myOccurenceNavigatorSupport.hasPreviousOccurence();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ant/config/execution/TreeView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ant/config/execution/TreeView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "printMessage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "printMessage";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyTree
    extends Tree
    implements DataProvider {
        MyTree() {
            super((TreeModel)TreeView.this.myTreeModel);
        }

        public void setRowHeight(int i) {
            super.setRowHeight(0);
        }

        public void updateUI() {
            super.updateUI();
            TreeUtil.installActions((JTree)((Object)this));
        }

        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                MyTree.$$$reportNull$$$0(0);
            }
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return new TextCopyProvider(){

                    @NotNull
                    public ActionUpdateThread getActionUpdateThread() {
                        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                        if (actionUpdateThread == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return actionUpdateThread;
                    }

                    @Nullable
                    public Collection<String> getTextLinesToCopy() {
                        Object value;
                        TreePath selection = MyTree.this.getSelectionPath();
                        Object object = value = selection == null ? null : selection.getLastPathComponent();
                        if (value instanceof MessageNode) {
                            MessageNode messageNode = (MessageNode)value;
                            return Arrays.asList(messageNode.getText());
                        }
                        return value == null ? null : Collections.singleton(value.toString());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/config/execution/TreeView$MyTree$1", "getActionUpdateThread"));
                    }
                };
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/lang/ant/config/execution/TreeView$MyTree", "getData"));
        }
    }

    public static final class TreeSelection {
        public String mySelectedTarget;
        public String mySelectedTask;

        public boolean isEmpty() {
            return this.mySelectedTarget == null && this.mySelectedTask == null;
        }
    }
}

