/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.explorer;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildModel;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntBuildTargetBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.explorer.AntBuildFileNodeDescriptor;
import com.intellij.lang.ant.config.explorer.AntNodeDescriptor;
import com.intellij.lang.ant.config.explorer.AntTargetNodeDescriptor;
import com.intellij.lang.ant.config.impl.MetaTarget;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AntExplorerTreeStructure
extends AbstractTreeStructure {
    private static final Logger LOG = Logger.getInstance(AntExplorerTreeStructure.class);
    private final Project myProject;
    private final Object myRoot = new Object();
    private boolean myFilteredTargets = false;
    private static final Comparator<AntBuildTarget> ourTargetComparator = (target1, target2) -> {
        String name1 = target1.getDisplayName();
        if (name1 == null) {
            return Integer.MIN_VALUE;
        }
        String name2 = target2.getDisplayName();
        if (name2 == null) {
            return Integer.MAX_VALUE;
        }
        return name1.compareToIgnoreCase(name2);
    };

    AntExplorerTreeStructure(Project project) {
        this.myProject = project;
    }

    public boolean isToBuildChildrenInBackground(@NotNull Object element) {
        if (element == null) {
            AntExplorerTreeStructure.$$$reportNull$$$0(0);
        }
        return true;
    }

    public boolean isAlwaysLeaf(@NotNull Object element) {
        if (element == null) {
            AntExplorerTreeStructure.$$$reportNull$$$0(1);
        }
        return element != this.myRoot && !(element instanceof AntBuildFile);
    }

    @NotNull
    public AntNodeDescriptor createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        if (element == null) {
            AntExplorerTreeStructure.$$$reportNull$$$0(2);
        }
        if (element == this.myRoot) {
            return new RootNodeDescriptor(this.myProject, parentDescriptor);
        }
        if (element instanceof String) {
            return new TextInfoNodeDescriptor(this.myProject, parentDescriptor, (String)element);
        }
        if (element instanceof AntBuildFileBase) {
            return new AntBuildFileNodeDescriptor(this.myProject, parentDescriptor, (AntBuildFileBase)element);
        }
        if (element instanceof AntBuildTargetBase) {
            return new AntTargetNodeDescriptor(this.myProject, parentDescriptor, (AntBuildTargetBase)element);
        }
        LOG.error("Unknown element for this tree structure " + element);
        if (null == null) {
            AntExplorerTreeStructure.$$$reportNull$$$0(3);
        }
        return null;
    }

    public Object @NotNull [] getChildElements(@NotNull Object element) {
        if (element == null) {
            AntExplorerTreeStructure.$$$reportNull$$$0(4);
        }
        AntConfiguration configuration = AntConfiguration.getInstance(this.myProject);
        if (element == this.myRoot) {
            if (!configuration.isInitialized()) {
                Object[] objectArray = new Object[]{AntBundle.message("progress.text.loading.ant.config", new Object[0])};
                if (objectArray == null) {
                    AntExplorerTreeStructure.$$$reportNull$$$0(5);
                }
                return objectArray;
            }
            Object[] objectArray = configuration.getBuildFiles();
            if (objectArray == null) {
                AntExplorerTreeStructure.$$$reportNull$$$0(6);
            }
            return objectArray;
        }
        if (element instanceof AntBuildFile) {
            AntBuildFile buildFile = (AntBuildFile)element;
            AntBuildModel model = buildFile.getModel();
            ArrayList<AntBuildTarget> targets = new ArrayList<AntBuildTarget>(Arrays.asList(this.myFilteredTargets ? model.getFilteredTargets() : model.getTargets()));
            targets.sort(ourTargetComparator);
            List<AntBuildTarget> metaTargets = Arrays.asList(configuration.getMetaTargets(buildFile));
            metaTargets.sort(ourTargetComparator);
            targets.addAll(metaTargets);
            Object[] objectArray = targets.toArray(new AntBuildTarget[0]);
            if (objectArray == null) {
                AntExplorerTreeStructure.$$$reportNull$$$0(7);
            }
            return objectArray;
        }
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            AntExplorerTreeStructure.$$$reportNull$$$0(8);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Nullable
    public Object getParentElement(@NotNull Object element) {
        if (element == null) {
            AntExplorerTreeStructure.$$$reportNull$$$0(9);
        }
        if (element instanceof AntBuildTarget) {
            if (element instanceof MetaTarget) {
                return ((MetaTarget)element).getBuildFile();
            }
            return ((AntBuildTarget)element).getModel().getBuildFile();
        }
        if (element instanceof AntBuildFile) {
            return this.myRoot;
        }
        return null;
    }

    public void commit() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
    }

    public boolean hasSomethingToCommit() {
        return PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments();
    }

    @NotNull
    public ActionCallback asyncCommit() {
        ActionCallback actionCallback = AntExplorerTreeStructure.asyncCommitDocuments((Project)this.myProject);
        if (actionCallback == null) {
            AntExplorerTreeStructure.$$$reportNull$$$0(10);
        }
        return actionCallback;
    }

    @NotNull
    public Object getRootElement() {
        Object object = this.myRoot;
        if (object == null) {
            AntExplorerTreeStructure.$$$reportNull$$$0(11);
        }
        return object;
    }

    public void setFilteredTargets(boolean value) {
        this.myFilteredTargets = value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ant/config/explorer/AntExplorerTreeStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ant/config/explorer/AntExplorerTreeStructure";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncCommit";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isToBuildChildrenInBackground";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAlwaysLeaf";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChildElements";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParentElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TextInfoNodeDescriptor
    extends AntNodeDescriptor {
        TextInfoNodeDescriptor(Project project, NodeDescriptor parentDescriptor, @Nls String text) {
            super(project, parentDescriptor);
            this.myName = text;
            this.myColor = JBColor.blue;
        }

        public Object getElement() {
            return this.myName;
        }

        public boolean update() {
            return true;
        }
    }

    private final class RootNodeDescriptor
    extends AntNodeDescriptor {
        RootNodeDescriptor(Project project, NodeDescriptor parentDescriptor) {
            super(project, parentDescriptor);
        }

        public Object getElement() {
            return AntExplorerTreeStructure.this.myRoot;
        }

        public boolean update() {
            this.myName = "";
            return false;
        }
    }
}

