/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.dom.AntCallParamsFinder;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.AntDomProperty;
import com.intellij.lang.ant.dom.AntDomReference;
import com.intellij.lang.ant.dom.AntDomReferenceBase;
import com.intellij.lang.ant.dom.PropertiesProvider;
import com.intellij.lang.ant.dom.PropertyResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntDomPropertyReference
extends PsiPolyVariantReferenceBase<PsiElement>
implements AntDomReference {
    @NonNls
    public static final String ANT_FILE_PREFIX = "ant.file.";
    @NonNls
    public static final String ANT_FILE_TYPE_PREFIX = "ant.file.type.";
    private final DomElement myInvocationContextElement;
    private boolean myShouldBeSkippedByAnnotator = false;

    public AntDomPropertyReference(DomElement invocationContextElement, XmlAttributeValue element, TextRange textRange) {
        super((PsiElement)element, textRange, true);
        this.myInvocationContextElement = invocationContextElement;
    }

    @Override
    public boolean shouldBeSkippedByAnnotator() {
        return this.myShouldBeSkippedByAnnotator;
    }

    @Override
    public String getUnresolvedMessagePattern() {
        return AntBundle.message("unknown.property", this.getCanonicalText());
    }

    @Override
    public void setShouldBeSkippedByAnnotator(boolean value) {
        this.myShouldBeSkippedByAnnotator = value;
    }

    @Nullable
    public PsiElement resolve() {
        MyResolveResult res = this.doResolve();
        return res != null ? res.getElement() : null;
    }

    @Nullable
    private MyResolveResult doResolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? (MyResolveResult)resolveResults[0] : null;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        PsiElement element = this.getElement();
        PsiFile file = element.getContainingFile();
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)file.getProject()).resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)MyResolver.INSTANCE, false, incompleteCode, file);
        if (resolveResultArray == null) {
            AntDomPropertyReference.$$$reportNull$$$0(0);
        }
        return resolveResultArray;
    }

    public Object @NotNull [] getVariants() {
        AntDomProject project = (AntDomProject)this.myInvocationContextElement.getParentOfType(AntDomProject.class, true);
        if (project != null) {
            Collection variants = (Collection)PropertyResolver.resolve(project.getContextAntProject(), this.getCanonicalText(), this.myInvocationContextElement).getSecond();
            Object[] result = new Object[variants.size()];
            int idx = 0;
            for (String variant : variants) {
                LookupElementBuilder builder = LookupElementBuilder.create((String)variant).withCaseSensitivity(false);
                LookupElement element = AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE.applyPolicy((LookupElement)builder);
                result[idx++] = element;
            }
            if (result == null) {
                AntDomPropertyReference.$$$reportNull$$$0(1);
            }
            return result;
        }
        if (EMPTY_ARRAY == null) {
            AntDomPropertyReference.$$$reportNull$$$0(2);
        }
        return EMPTY_ARRAY;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        MyResolveResult resolveResult;
        if (newElementName == null) {
            AntDomPropertyReference.$$$reportNull$$$0(3);
        }
        if ((resolveResult = this.doResolve()) != null) {
            PsiElement resolve = resolveResult.getElement();
            PropertiesProvider provider = resolveResult.getProvider();
            String refText = this.getCanonicalText();
            if (provider instanceof AntDomProject) {
                String oldProjectName;
                DomElement resolvedDomElem = AntDomReferenceBase.toDomElement(resolve);
                if (provider.equals(resolvedDomElem) && (oldProjectName = (String)((AntDomProject)provider).getName().getValue()) != null && refText.endsWith(oldProjectName)) {
                    String prefix = refText.substring(0, refText.length() - oldProjectName.length());
                    newElementName = prefix + (String)newElementName;
                }
            } else if (provider instanceof AntDomProperty) {
                AntDomProperty antProperty = (AntDomProperty)provider;
                if (antProperty.equals(AntDomReferenceBase.toDomElement(resolve))) {
                    Object envPrefix = (String)antProperty.getEnvironment().getValue();
                    if (envPrefix != null) {
                        if (!((String)envPrefix).endsWith(".")) {
                            envPrefix = (String)envPrefix + ".";
                        }
                        if (refText.startsWith((String)envPrefix)) {
                            String envVariableName = refText.substring(((String)envPrefix).length());
                            Object newPrefix = ((String)newElementName).endsWith(".") ? newElementName : (String)newElementName + ".";
                            newElementName = (String)newPrefix + envVariableName;
                        }
                    }
                } else {
                    String prefix = antProperty.getPropertyPrefixValue();
                    if (prefix != null) {
                        newElementName = prefix + (String)newElementName;
                    }
                }
            }
        }
        return super.handleElementRename((String)newElementName);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        AntDomProperty prop;
        String propName;
        DomElement domElement;
        if (element == null) {
            AntDomPropertyReference.$$$reportNull$$$0(4);
        }
        if ((domElement = AntDomReferenceBase.toDomElement(element)) instanceof AntDomProperty && (propName = (prop = (AntDomProperty)domElement).getName().getRawText()) != null && prop.getPrefix().getRawText() == null && prop.getEnvironment().getRawText() == null && !propName.equalsIgnoreCase(this.getCanonicalText())) {
            return false;
        }
        return super.isReferenceTo(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ant/dom/AntDomPropertyReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ant/dom/AntDomPropertyReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyResolver
    implements ResolveCache.PolyVariantResolver<AntDomPropertyReference> {
        static final MyResolver INSTANCE = new MyResolver();

        private MyResolver() {
        }

        public ResolveResult @NotNull [] resolve(@NotNull AntDomPropertyReference antDomPropertyReference, boolean incompleteCode) {
            if (antDomPropertyReference == null) {
                MyResolver.$$$reportNull$$$0(0);
            }
            ArrayList<MyResolveResult> result = new ArrayList<MyResolveResult>();
            AntDomProject project = (AntDomProject)antDomPropertyReference.myInvocationContextElement.getParentOfType(AntDomProject.class, true);
            if (project != null) {
                String propertyName;
                AntDomProject contextAntProject = project.getContextAntProject();
                Trinity<PsiElement, Collection<String>, PropertiesProvider> resolved = PropertyResolver.resolve(contextAntProject, propertyName = antDomPropertyReference.getCanonicalText(), antDomPropertyReference.myInvocationContextElement);
                PsiElement mainDeclaration = (PsiElement)resolved.getFirst();
                if (mainDeclaration != null) {
                    result.add(new MyResolveResult(mainDeclaration, (PropertiesProvider)resolved.getThird()));
                }
                List<PsiElement> antCallParams = AntCallParamsFinder.resolve(project, propertyName);
                for (PsiElement param : antCallParams) {
                    result.add(new MyResolveResult(param, null));
                }
            }
            ResolveResult[] resolveResultArray = result.toArray(ResolveResult.EMPTY_ARRAY);
            if (resolveResultArray == null) {
                MyResolver.$$$reportNull$$$0(1);
            }
            return resolveResultArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "antDomPropertyReference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ant/dom/AntDomPropertyReference$MyResolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ant/dom/AntDomPropertyReference$MyResolver";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyResolveResult
    implements ResolveResult {
        private final PsiElement myElement;
        private final PropertiesProvider myProvider;

        MyResolveResult(PsiElement element, PropertiesProvider provider) {
            this.myElement = element;
            this.myProvider = provider;
        }

        public PsiElement getElement() {
            return this.myElement;
        }

        @Nullable
        public PropertiesProvider getProvider() {
            return this.myProvider;
        }

        public boolean isValidResult() {
            return true;
        }
    }
}

