/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import groovy.lang.Closure;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleDependencyCapabilitiesHandler;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.DefaultExcludeRuleContainer;
import org.gradle.api.internal.artifacts.dependencies.AbstractDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyArtifact;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableModuleDependencyCapabilitiesHandler;
import org.gradle.api.internal.artifacts.dependencies.ModuleDependencyCapabilitiesInternal;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.internal.ConfigureUtil;

public abstract class AbstractModuleDependency
extends AbstractDependency
implements ModuleDependency {
    private static final Logger LOG = Logging.getLogger(AbstractModuleDependency.class);
    private ImmutableAttributesFactory attributesFactory;
    private NotationParser<Object, Capability> capabilityNotationParser;
    private DefaultExcludeRuleContainer excludeRuleContainer = new DefaultExcludeRuleContainer();
    private Set<DependencyArtifact> artifacts = new LinkedHashSet<DependencyArtifact>();
    private ImmutableActionSet<ModuleDependency> onMutate = ImmutableActionSet.empty();
    private AttributeContainerInternal attributes;
    private ModuleDependencyCapabilitiesInternal moduleDependencyCapabilities;
    @Nullable
    private String configuration;
    private boolean transitive = true;
    private boolean endorsing;

    protected AbstractModuleDependency(@Nullable String configuration2) {
        this.configuration = configuration2;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public ModuleDependency setTransitive(boolean transitive) {
        this.validateMutation(this.transitive, transitive);
        this.transitive = transitive;
        return this;
    }

    @Override
    public String getTargetConfiguration() {
        return this.configuration;
    }

    @Override
    public void setTargetConfiguration(@Nullable String configuration2) {
        this.validateMutation(this.configuration, configuration2);
        this.validateNotVariantAware();
        if (!this.artifacts.isEmpty()) {
            throw new InvalidUserCodeException("Cannot set target configuration when artifacts have been specified");
        }
        this.configuration = configuration2;
    }

    @Override
    public ModuleDependency exclude(Map<String, String> excludeProperties) {
        if (this.excludeRuleContainer.maybeAdd(excludeProperties)) {
            this.validateMutation();
        }
        return this;
    }

    @Override
    public Set<ExcludeRule> getExcludeRules() {
        return this.excludeRuleContainer.getRules();
    }

    private void setExcludeRuleContainer(DefaultExcludeRuleContainer excludeRuleContainer) {
        this.excludeRuleContainer = excludeRuleContainer;
    }

    @Override
    public Set<DependencyArtifact> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(Set<DependencyArtifact> artifacts2) {
        this.artifacts = artifacts2;
    }

    @Override
    public AbstractModuleDependency addArtifact(DependencyArtifact artifact) {
        this.validateNotVariantAware();
        this.validateNoTargetConfiguration();
        this.artifacts.add(artifact);
        return this;
    }

    @Override
    public DependencyArtifact artifact(Closure configureClosure) {
        return this.artifact(ConfigureUtil.configureUsing(configureClosure));
    }

    @Override
    public DependencyArtifact artifact(Action<? super DependencyArtifact> configureAction) {
        this.validateNotVariantAware();
        this.validateNoTargetConfiguration();
        DefaultDependencyArtifact artifact = this.createDependencyArtifactWithDefaults();
        configureAction.execute(artifact);
        artifact.validate();
        this.artifacts.add(artifact);
        return artifact;
    }

    private DefaultDependencyArtifact createDependencyArtifactWithDefaults() {
        DefaultDependencyArtifact artifact = new DefaultDependencyArtifact();
        artifact.setName(this.getName());
        artifact.setType("jar");
        return artifact;
    }

    protected void copyTo(AbstractModuleDependency target) {
        super.copyTo(target);
        target.setArtifacts(new LinkedHashSet<DependencyArtifact>(this.getArtifacts()));
        target.setExcludeRuleContainer(new DefaultExcludeRuleContainer(this.getExcludeRules()));
        target.setTransitive(this.isTransitive());
        if (this.attributes != null) {
            target.setAttributes(this.attributesFactory.mutable(this.attributes.asImmutable()));
        }
        target.setAttributesFactory(this.attributesFactory);
        target.setCapabilityNotationParser(this.capabilityNotationParser);
        if (this.moduleDependencyCapabilities != null) {
            target.moduleDependencyCapabilities = this.moduleDependencyCapabilities.copy();
        }
    }

    protected boolean isKeyEquals(ModuleDependency dependencyRhs) {
        if (this.getGroup() != null ? !this.getGroup().equals(dependencyRhs.getGroup()) : dependencyRhs.getGroup() != null) {
            return false;
        }
        if (!this.getName().equals(dependencyRhs.getName())) {
            return false;
        }
        if (this.getTargetConfiguration() != null ? !this.getTargetConfiguration().equals(dependencyRhs.getTargetConfiguration()) : dependencyRhs.getTargetConfiguration() != null) {
            return false;
        }
        return !(this.getVersion() != null ? !this.getVersion().equals(dependencyRhs.getVersion()) : dependencyRhs.getVersion() != null);
    }

    protected boolean isCommonContentEquals(ModuleDependency dependencyRhs) {
        if (!this.isKeyEquals(dependencyRhs)) {
            return false;
        }
        if (this.isTransitive() != dependencyRhs.isTransitive()) {
            return false;
        }
        if (!Objects.equal(this.getArtifacts(), dependencyRhs.getArtifacts())) {
            return false;
        }
        if (!Objects.equal(this.getExcludeRules(), dependencyRhs.getExcludeRules())) {
            return false;
        }
        if (!Objects.equal((Object)this.getAttributes(), (Object)dependencyRhs.getAttributes())) {
            return false;
        }
        return Objects.equal(this.getRequestedCapabilities(), dependencyRhs.getRequestedCapabilities());
    }

    @Override
    public AttributeContainer getAttributes() {
        return this.attributes == null ? ImmutableAttributes.EMPTY : this.attributes.asImmutable();
    }

    @Override
    public AbstractModuleDependency attributes(Action<? super AttributeContainer> configureAction) {
        this.validateMutation();
        this.validateNotLegacyConfigured();
        if (this.attributesFactory == null) {
            this.warnAboutInternalApiUse("attributes");
            return this;
        }
        if (this.attributes == null) {
            this.attributes = this.attributesFactory.mutable();
        }
        configureAction.execute(this.attributes);
        return this;
    }

    @Override
    public ModuleDependency capabilities(Action<? super ModuleDependencyCapabilitiesHandler> configureAction) {
        this.validateMutation();
        this.validateNotLegacyConfigured();
        if (this.capabilityNotationParser == null) {
            this.warnAboutInternalApiUse("capabilities");
            return this;
        }
        if (this.moduleDependencyCapabilities == null) {
            this.moduleDependencyCapabilities = new DefaultMutableModuleDependencyCapabilitiesHandler(this.capabilityNotationParser);
        }
        configureAction.execute(this.moduleDependencyCapabilities);
        return this;
    }

    @Override
    public List<Capability> getRequestedCapabilities() {
        if (this.moduleDependencyCapabilities == null) {
            return Collections.emptyList();
        }
        return this.moduleDependencyCapabilities.getRequestedCapabilities();
    }

    @Override
    public void endorseStrictVersions() {
        this.endorsing = true;
    }

    @Override
    public void doNotEndorseStrictVersions() {
        this.endorsing = false;
    }

    @Override
    public boolean isEndorsingStrictVersions() {
        return this.endorsing;
    }

    private void warnAboutInternalApiUse(String thing) {
        LOG.warn("Cannot set " + thing + " for dependency \"" + this.getGroup() + ":" + this.getName() + ":" + this.getVersion() + "\": it was probably created by a plugin using internal APIs");
    }

    public void setAttributesFactory(ImmutableAttributesFactory attributesFactory) {
        this.attributesFactory = attributesFactory;
    }

    public void setCapabilityNotationParser(NotationParser<Object, Capability> capabilityNotationParser) {
        this.capabilityNotationParser = capabilityNotationParser;
    }

    protected ImmutableAttributesFactory getAttributesFactory() {
        return this.attributesFactory;
    }

    private void setAttributes(AttributeContainerInternal attributes) {
        this.attributes = attributes;
    }

    public void addMutationValidator(Action<? super ModuleDependency> action) {
        this.onMutate = this.onMutate.add(action);
    }

    protected void validateMutation() {
        this.onMutate.execute(this);
    }

    protected void validateMutation(Object currentValue, Object newValue) {
        if (!Objects.equal((Object)currentValue, (Object)newValue)) {
            this.validateMutation();
        }
    }

    private void validateNotVariantAware() {
        if (!this.getAttributes().isEmpty() || !this.getRequestedCapabilities().isEmpty()) {
            throw new InvalidUserCodeException("Cannot set artifact / configuration information on a dependency that has attributes or capabilities configured");
        }
    }

    private void validateNotLegacyConfigured() {
        if (this.getTargetConfiguration() != null || !this.getArtifacts().isEmpty()) {
            throw new InvalidUserCodeException("Cannot add attributes or capabilities on a dependency that specifies artifacts or configuration information");
        }
    }

    private void validateNoTargetConfiguration() {
        if (this.configuration != null) {
            throw new InvalidUserCodeException("Cannot add artifact if target configuration has been set");
        }
    }
}

