/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleSource;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenImmutableAttributesFactory;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifacts;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.OriginArtifactSelector;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableComponentArtifactsResolveResult;

class RepositoryChainArtifactResolver
implements ArtifactResolver,
OriginArtifactSelector {
    private final Map<String, ModuleComponentRepository> repositories = new LinkedHashMap<String, ModuleComponentRepository>();
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;

    public RepositoryChainArtifactResolver(CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    void add(ModuleComponentRepository repository) {
        this.repositories.put(repository.getId(), repository);
    }

    @Override
    public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result2) {
        ModuleComponentRepository sourceRepository = this.findSourceRepository(component.getSources());
        sourceRepository.getLocalAccess().resolveArtifactsWithType(component, artifactType, result2);
        if (!result2.hasResult()) {
            sourceRepository.getRemoteAccess().resolveArtifactsWithType(component, artifactType, result2);
        }
    }

    @Override
    @Nullable
    public ArtifactSet resolveArtifacts(ComponentResolveMetadata component, ConfigurationMetadata configuration2, ArtifactTypeRegistry artifactTypeRegistry, ExcludeSpec exclusions, ImmutableAttributes overriddenAttributes) {
        String value;
        AttributeValue<String> componentTypeEntry;
        if (component.getSources() == null) {
            return ArtifactSet.NO_ARTIFACTS;
        }
        if (configuration2.getArtifacts().isEmpty() && (componentTypeEntry = configuration2.getAttributes().findEntry(MavenImmutableAttributesFactory.CATEGORY_ATTRIBUTE)).isPresent() && ("platform".equals(value = componentTypeEntry.get()) || "enforced-platform".equals(value))) {
            return ArtifactSet.NO_ARTIFACTS;
        }
        ModuleComponentRepository sourceRepository = this.findSourceRepository(component.getSources());
        DefaultBuildableComponentArtifactsResolveResult result2 = new DefaultBuildableComponentArtifactsResolveResult();
        sourceRepository.getLocalAccess().resolveArtifacts(component, configuration2, result2);
        if (!result2.hasResult()) {
            sourceRepository.getRemoteAccess().resolveArtifacts(component, configuration2, result2);
        }
        if (result2.hasResult()) {
            return ((ComponentArtifacts)result2.getResult()).getArtifactsFor(component, configuration2, this, sourceRepository.getArtifactCache(), artifactTypeRegistry, exclusions, overriddenAttributes, this.calculatedValueContainerFactory);
        }
        return null;
    }

    @Override
    public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSources sources, BuildableArtifactResolveResult result2) {
        ModuleComponentRepository sourceRepository = this.findSourceRepository(sources);
        sourceRepository.getLocalAccess().resolveArtifact(artifact, sources, result2);
        if (!result2.hasResult()) {
            sourceRepository.getRemoteAccess().resolveArtifact(artifact, sources, result2);
        }
    }

    private ModuleComponentRepository findSourceRepository(ModuleSources sources) {
        RepositoryChainModuleSource repositoryChainModuleSource = sources.getSource(RepositoryChainModuleSource.class).get();
        ModuleComponentRepository moduleVersionRepository = this.repositories.get(repositoryChainModuleSource.getRepositoryId());
        if (moduleVersionRepository == null) {
            throw new IllegalStateException("Attempting to resolve artifacts from invalid repository");
        }
        return moduleVersionRepository;
    }
}

