/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies;

import javax.annotation.Nullable;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.dependencies.SelfResolvingDependencyInternal;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependencyDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.ExcludeRuleConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalConfigurationMetadataBuilder;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.internal.component.local.model.BuildableLocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;

public class DefaultLocalConfigurationMetadataBuilder
implements LocalConfigurationMetadataBuilder {
    private final DependencyDescriptorFactory dependencyDescriptorFactory;
    private final ExcludeRuleConverter excludeRuleConverter;

    public DefaultLocalConfigurationMetadataBuilder(DependencyDescriptorFactory dependencyDescriptorFactory, ExcludeRuleConverter excludeRuleConverter) {
        this.dependencyDescriptorFactory = dependencyDescriptorFactory;
        this.excludeRuleConverter = excludeRuleConverter;
    }

    @Override
    public void addDependenciesAndExcludes(BuildableLocalConfigurationMetadata metaData, ConfigurationInternal configuration2) {
        configuration2.runDependencyActions();
        this.addDependencies(metaData, configuration2);
        this.addDependencyConstraints(metaData, configuration2);
        this.addExcludeRules(metaData, configuration2);
    }

    private void addDependencies(BuildableLocalConfigurationMetadata configurationMetadata, ConfigurationInternal configuration2) {
        AttributeContainerInternal attributes = configuration2.getAttributes();
        for (Dependency dependency : configuration2.getDependencies()) {
            if (dependency instanceof ModuleDependency) {
                ModuleDependency moduleDependency = (ModuleDependency)dependency;
                configurationMetadata.addDependency(this.dependencyDescriptorFactory.createDependencyDescriptor(configurationMetadata.getComponentId(), configuration2.getName(), attributes, moduleDependency));
                continue;
            }
            if (dependency instanceof FileCollectionDependency) {
                FileCollectionDependency fileDependency = (FileCollectionDependency)dependency;
                configurationMetadata.addFiles(new DefaultLocalFileDependencyMetadata(fileDependency));
                continue;
            }
            throw new IllegalArgumentException("Cannot convert dependency " + dependency + " to local component dependency metadata.");
        }
    }

    private void addDependencyConstraints(BuildableLocalConfigurationMetadata configurationMetadata, ConfigurationInternal configuration2) {
        AttributeContainerInternal attributes = configuration2.getAttributes();
        for (DependencyConstraint dependencyConstraint : configuration2.getDependencyConstraints()) {
            configurationMetadata.addDependency(this.dependencyDescriptorFactory.createDependencyConstraintDescriptor(configurationMetadata.getComponentId(), configuration2.getName(), attributes, dependencyConstraint));
        }
    }

    private void addExcludeRules(BuildableLocalConfigurationMetadata configurationMetadata, ConfigurationInternal configuration2) {
        for (ExcludeRule excludeRule : configuration2.getExcludeRules()) {
            configurationMetadata.addExclude(this.excludeRuleConverter.convertExcludeRule(excludeRule));
        }
    }

    private static class DefaultLocalFileDependencyMetadata
    implements LocalFileDependencyMetadata {
        private final FileCollectionDependency fileDependency;

        DefaultLocalFileDependencyMetadata(FileCollectionDependency fileDependency) {
            this.fileDependency = fileDependency;
        }

        @Override
        public FileCollectionDependency getSource() {
            return this.fileDependency;
        }

        @Override
        @Nullable
        public ComponentIdentifier getComponentId() {
            return ((SelfResolvingDependencyInternal)((Object)this.fileDependency)).getTargetComponentId();
        }

        @Override
        public FileCollectionInternal getFiles() {
            return (FileCollectionInternal)this.fileDependency.getFiles();
        }
    }
}

