/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.util.Optional;

public enum TaskExecutionMode {
    INCREMENTAL(null, true, true),
    NO_OUTPUTS("Task has not declared any outputs despite executing actions.", false, false),
    RERUN_TASKS_ENABLED("Executed with '--rerun-tasks'.", true, false),
    UP_TO_DATE_WHEN_FALSE("Task.upToDateWhen is false.", true, false),
    UNTRACKED("Task state is not tracked.", false, false);

    private final Optional<String> rebuildReason;
    private final boolean taskHistoryMaintained;
    private final boolean allowedToUseCachedResults;

    private TaskExecutionMode(String rebuildReason, boolean taskHistoryMaintained, boolean allowedToUseCachedResults) {
        this.rebuildReason = Optional.ofNullable(rebuildReason);
        this.taskHistoryMaintained = taskHistoryMaintained;
        this.allowedToUseCachedResults = allowedToUseCachedResults;
    }

    public Optional<String> getRebuildReason() {
        return this.rebuildReason;
    }

    public boolean isTaskHistoryMaintained() {
        return this.taskHistoryMaintained;
    }

    public boolean isAllowedToUseCachedResults() {
        return this.allowedToUseCachedResults;
    }
}

