/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.internal.project.taskfactory.BridgingIncrementalInputsTaskAction;
import org.gradle.api.internal.project.taskfactory.IncrementalInputsTaskAction;
import org.gradle.api.internal.project.taskfactory.IncrementalTaskInputsTaskAction;
import org.gradle.api.internal.project.taskfactory.StandardTaskAction;
import org.gradle.api.internal.project.taskfactory.TaskActionFactory;
import org.gradle.api.internal.project.taskfactory.TaskClassInfo;
import org.gradle.api.internal.project.taskfactory.TaskClassInfoStore;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.work.InputChanges;

@NonNullApi
public class DefaultTaskClassInfoStore
implements TaskClassInfoStore {
    private final CrossBuildInMemoryCache<Class<?>, TaskClassInfo> classInfos;
    private final Function<Class<?>, TaskClassInfo> taskClassInfoFactory = aClass -> this.createTaskClassInfo(aClass.asSubclass(Task.class));

    public DefaultTaskClassInfoStore(CrossBuildInMemoryCacheFactory cacheFactory) {
        this.classInfos = cacheFactory.newClassCache();
    }

    @Override
    public TaskClassInfo getTaskClassInfo(Class<? extends Task> type) {
        return this.classInfos.get(type, this.taskClassInfoFactory);
    }

    private TaskClassInfo createTaskClassInfo(Class<? extends Task> type) {
        boolean cacheable = type.isAnnotationPresent(CacheableTask.class);
        Optional<String> reasonNotToTrackState = Optional.ofNullable(type.getAnnotation(UntrackedTask.class)).map(UntrackedTask::because);
        HashMap processedMethods = Maps.newHashMap();
        ImmutableList.Builder taskActionFactoriesBuilder = ImmutableList.builder();
        AbstractIncrementalTaskActionFactory foundIncrementalTaskActionFactory = null;
        for (Class<? extends Task> current = type; current != null; current = current.getSuperclass()) {
            for (Method method : current.getDeclaredMethods()) {
                AbstractIncrementalTaskActionFactory selectedTaskAction;
                TaskActionFactory taskActionFactory = DefaultTaskClassInfoStore.createTaskAction(type, method);
                if (taskActionFactory == null) continue;
                Class<?> declaringClass = method.getDeclaringClass();
                Class<?> previousDeclaringClass = processedMethods.put(method.getName(), declaringClass);
                if (taskActionFactory instanceof AbstractIncrementalTaskActionFactory && foundIncrementalTaskActionFactory != null && method.getName().equals(foundIncrementalTaskActionFactory.getMethod().getName()) && (selectedTaskAction = this.selectIncrementalTaskAction(type, foundIncrementalTaskActionFactory, taskActionFactory, current, method)) != null) {
                    foundIncrementalTaskActionFactory = selectedTaskAction;
                    continue;
                }
                if (previousDeclaringClass == declaringClass) {
                    throw new GradleException(String.format("Cannot use @TaskAction annotation on multiple overloads of method %s.%s()", declaringClass.getSimpleName(), method.getName()));
                }
                if (previousDeclaringClass != null) continue;
                if (taskActionFactory instanceof AbstractIncrementalTaskActionFactory) {
                    if (foundIncrementalTaskActionFactory != null) {
                        Class<IncrementalTaskInputs> incrementalTaskInputsClass = IncrementalTaskInputs.class;
                        throw new GradleException(String.format("Cannot have multiple @TaskAction methods accepting an %s or %s parameter.", InputChanges.class.getSimpleName(), incrementalTaskInputsClass.getSimpleName()));
                    }
                    foundIncrementalTaskActionFactory = (AbstractIncrementalTaskActionFactory)taskActionFactory;
                    continue;
                }
                taskActionFactoriesBuilder.add((Object)taskActionFactory);
            }
        }
        if (foundIncrementalTaskActionFactory != null) {
            taskActionFactoriesBuilder.add(foundIncrementalTaskActionFactory);
        }
        return new TaskClassInfo((ImmutableList<TaskActionFactory>)taskActionFactoriesBuilder.build(), cacheable, reasonNotToTrackState);
    }

    @Nullable
    private AbstractIncrementalTaskActionFactory selectIncrementalTaskAction(Class<? extends Task> taskClass, AbstractIncrementalTaskActionFactory foundTaskActionFactory, TaskActionFactory currentTaskActionFactory, Class currentClass, Method currentMethod) {
        if (currentTaskActionFactory.getClass() == foundTaskActionFactory.getClass()) {
            return foundTaskActionFactory;
        }
        AbstractIncrementalTaskActionFactory currentIncrementalTaskActionFactory = (AbstractIncrementalTaskActionFactory)currentTaskActionFactory;
        Map<Boolean, List<AbstractIncrementalTaskActionFactory>> partitionedActions = Stream.of(foundTaskActionFactory, currentIncrementalTaskActionFactory).collect(Collectors.partitioningBy(IncrementalInputsTaskActionFactory.class::isInstance));
        List<AbstractIncrementalTaskActionFactory> incrementalInputsFactories = partitionedActions.get(true);
        List<AbstractIncrementalTaskActionFactory> incrementalTaskInputFactories = partitionedActions.get(false);
        if (incrementalInputsFactories.size() == 1 && incrementalTaskInputFactories.size() == 1) {
            IncrementalInputsTaskActionFactory incrementalInputsTaskActionFactory = (IncrementalInputsTaskActionFactory)Iterables.getOnlyElement(incrementalInputsFactories);
            IncrementalTaskInputsTaskActionFactory incrementalTaskInputsTaskActionFactory = (IncrementalTaskInputsTaskActionFactory)Iterables.getOnlyElement(incrementalTaskInputFactories);
            if (this.isDeprecated(incrementalTaskInputsTaskActionFactory) && !this.isDeprecated(incrementalInputsTaskActionFactory)) {
                Class<?> declaringClassForIncrementalTaskInputsMethod = this.getDeclaringClassForIncrementalTaskInputsMethod(taskClass, currentMethod.getName());
                if (declaringClassForIncrementalTaskInputsMethod != currentClass) {
                    return new BridgingIncrementalInputsTaskActionFactory(taskClass, currentMethod);
                }
                return incrementalInputsTaskActionFactory;
            }
        }
        return null;
    }

    private Class<?> getDeclaringClassForIncrementalTaskInputsMethod(Class<? extends Task> type, String methodName) {
        Method incrementalTaskInputsMethod = null;
        Class<? extends Task> current = type;
        while (incrementalTaskInputsMethod == null) {
            incrementalTaskInputsMethod = this.getIncrementalTaskInputsMethod(current, methodName);
            current = current.getSuperclass();
        }
        return incrementalTaskInputsMethod.getDeclaringClass();
    }

    @Nullable
    private Method getIncrementalTaskInputsMethod(Class<?> type, String methodName) {
        try {
            return type.getDeclaredMethod(methodName, IncrementalTaskInputs.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private boolean isDeprecated(AbstractIncrementalTaskActionFactory foundIncrementalTaskActionFactory) {
        return foundIncrementalTaskActionFactory.getMethod().getAnnotation(Deprecated.class) != null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static TaskActionFactory createTaskAction(Class<? extends Task> taskType, Method method) {
        void var4_10;
        if (method.getAnnotation(TaskAction.class) == null) {
            return null;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        if (Modifier.isStatic(method.getModifiers())) {
            throw new GradleException(String.format("Cannot use @TaskAction annotation on static method %s.%s().", declaringClass.getSimpleName(), method.getName()));
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 1) {
            throw new GradleException(String.format("Cannot use @TaskAction annotation on method %s.%s() as this method takes multiple parameters.", declaringClass.getSimpleName(), method.getName()));
        }
        if (parameterTypes.length == 1) {
            Class<?> parameterType = parameterTypes[0];
            Class<IncrementalTaskInputs> incrementalTaskInputsClass = IncrementalTaskInputs.class;
            if (parameterType.equals(incrementalTaskInputsClass)) {
                IncrementalTaskInputsTaskActionFactory incrementalTaskInputsTaskActionFactory = new IncrementalTaskInputsTaskActionFactory(taskType, method);
                return var4_10;
            } else {
                if (!parameterType.equals(InputChanges.class)) throw new GradleException(String.format("Cannot use @TaskAction annotation on method %s.%s() because %s is not a valid parameter to an action method.", declaringClass.getSimpleName(), method.getName(), parameterType));
                IncrementalInputsTaskActionFactory incrementalInputsTaskActionFactory = new IncrementalInputsTaskActionFactory(taskType, method);
            }
            return var4_10;
        } else {
            StandardTaskActionFactory standardTaskActionFactory = new StandardTaskActionFactory(taskType, method);
        }
        return var4_10;
    }

    private static abstract class AbstractIncrementalTaskActionFactory
    implements TaskActionFactory {
        private final Class<? extends Task> taskType;
        private final Method method;

        public AbstractIncrementalTaskActionFactory(Class<? extends Task> taskType, Method method) {
            this.taskType = taskType;
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        protected abstract Action<? super Task> doCreate(Instantiator var1, Class<? extends Task> var2, Method var3);

        @Override
        public Action<? super Task> create(Instantiator instantiator) {
            return this.doCreate(instantiator, this.taskType, this.method);
        }
    }

    private static class BridgingIncrementalInputsTaskActionFactory
    extends AbstractIncrementalTaskActionFactory {
        public BridgingIncrementalInputsTaskActionFactory(Class<? extends Task> taskType, Method method) {
            super(taskType, method);
        }

        @Override
        protected Action<? super Task> doCreate(Instantiator instantiator, Class<? extends Task> taskType, Method method) {
            return new BridgingIncrementalInputsTaskAction(taskType, method);
        }
    }

    private static class IncrementalTaskInputsTaskActionFactory
    extends AbstractIncrementalTaskActionFactory {
        public IncrementalTaskInputsTaskActionFactory(Class<? extends Task> taskType, Method method) {
            super(taskType, method);
        }

        @Override
        protected Action<? super Task> doCreate(Instantiator instantiator, Class<? extends Task> taskType, Method method) {
            return new IncrementalTaskInputsTaskAction(instantiator, taskType, method);
        }
    }

    private static class IncrementalInputsTaskActionFactory
    extends AbstractIncrementalTaskActionFactory {
        public IncrementalInputsTaskActionFactory(Class<? extends Task> taskType, Method method) {
            super(taskType, method);
        }

        @Override
        protected Action<? super Task> doCreate(Instantiator instantiator, Class<? extends Task> taskType, Method method) {
            return new IncrementalInputsTaskAction(taskType, method);
        }
    }

    private static class StandardTaskActionFactory
    implements TaskActionFactory {
        private final Class<? extends Task> taskType;
        private final Method method;

        public StandardTaskActionFactory(Class<? extends Task> taskType, Method method) {
            this.taskType = taskType;
            this.method = method;
        }

        @Override
        public Action<? super Task> create(Instantiator instantiator) {
            return new StandardTaskAction(this.taskType, this.method);
        }
    }
}

