/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.Provider;

public class FlatMapProvider<S, T>
extends AbstractMinimalProvider<S> {
    private final ProviderInternal<? extends T> provider;
    private final Transformer<? extends Provider<? extends S>, ? super T> transformer;

    FlatMapProvider(ProviderInternal<? extends T> provider, Transformer<? extends Provider<? extends S>, ? super T> transformer) {
        this.provider = provider;
        this.transformer = transformer;
    }

    @Override
    @Nullable
    public Class<S> getType() {
        return null;
    }

    @Override
    public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
        return this.backingProvider(consumer).calculatePresence(consumer);
    }

    @Override
    protected ValueSupplier.Value<? extends S> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        ValueSupplier.Value<T> value = this.provider.calculateValue(consumer);
        if (value.isMissing()) {
            return value.asType();
        }
        return this.doMapValue(value.get()).calculateValue(consumer);
    }

    private ProviderInternal<? extends S> doMapValue(T value) {
        Provider<? extends S> result2 = this.transformer.transform(value);
        if (result2 == null) {
            return Providers.notDefined();
        }
        return Providers.internal(result2);
    }

    private ProviderInternal<? extends S> backingProvider(ValueSupplier.ValueConsumer consumer) {
        ValueSupplier.Value<T> value = this.provider.calculateValue(consumer);
        if (value.isMissing()) {
            return Providers.notDefined();
        }
        return this.doMapValue(value.get());
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        return this.backingProvider(ValueSupplier.ValueConsumer.IgnoreUnsafeRead).getProducer();
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends S> calculateExecutionTimeValue() {
        return this.backingProvider(ValueSupplier.ValueConsumer.IgnoreUnsafeRead).calculateExecutionTimeValue();
    }

    @Override
    public String toString() {
        return "flatmap(" + this.provider + ")";
    }
}

