/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.asm;

import java.lang.annotation.RetentionPolicy;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.tasks.compile.incremental.asm.ClassRelevancyFilter;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSet;
import org.gradle.internal.impldep.org.objectweb.asm.ClassReader;
import org.gradle.internal.impldep.org.objectweb.asm.ClassVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.Label;
import org.gradle.internal.impldep.org.objectweb.asm.ModuleVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.Type;
import org.gradle.internal.impldep.org.objectweb.asm.TypePath;

public class ClassDependenciesVisitor
extends ClassVisitor {
    private static final int API = 589824;
    private final IntSet constants = new IntOpenHashSet(2);
    private final Set<String> privateTypes = new HashSet<String>();
    private final Set<String> accessibleTypes = new HashSet<String>();
    private final Predicate<String> typeFilter;
    private final StringInterner interner;
    private boolean isAnnotationType;
    private String dependencyToAllReason;
    private String moduleName;
    private final RetentionPolicyVisitor retentionPolicyVisitor = new RetentionPolicyVisitor();

    private ClassDependenciesVisitor(Predicate<String> typeFilter, ClassReader reader2, StringInterner interner) {
        super(589824);
        this.typeFilter = typeFilter;
        this.interner = interner;
        this.collectRemainingClassDependencies(reader2);
    }

    public static ClassAnalysis analyze(String className, ClassReader reader2, StringInterner interner) {
        ClassDependenciesVisitor visitor = new ClassDependenciesVisitor(new ClassRelevancyFilter(className), reader2, interner);
        reader2.accept((ClassVisitor)visitor, 6);
        visitor.privateTypes.removeAll(visitor.accessibleTypes);
        String name = visitor.moduleName != null ? visitor.moduleName : className;
        return new ClassAnalysis(interner.intern(name), visitor.getPrivateClassDependencies(), visitor.getAccessibleClassDependencies(), visitor.getDependencyToAllReason(), visitor.getConstants());
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        Set<String> types;
        this.isAnnotationType = this.isAnnotationType(interfaces);
        Set<String> set2 = types = ClassDependenciesVisitor.isAccessible(access) ? this.accessibleTypes : this.privateTypes;
        if (superName != null) {
            Type type = Type.getObjectType((String)superName);
            this.maybeAddDependentType(types, type);
        }
        for (String s : interfaces) {
            Type interfaceType = Type.getObjectType((String)s);
            this.maybeAddDependentType(types, interfaceType);
        }
    }

    public ModuleVisitor visitModule(String name, int access, String version) {
        this.moduleName = name;
        this.dependencyToAllReason = "module-info of '" + name + "' has changed";
        return null;
    }

    private void collectRemainingClassDependencies(ClassReader reader2) {
        char[] charBuffer = new char[reader2.getMaxStringLength()];
        for (int i = 1; i < reader2.getItemCount(); ++i) {
            int itemOffset = reader2.getItem(i);
            if (itemOffset <= 0 || reader2.readByte(itemOffset - 1) != 7) continue;
            String classDescriptor = reader2.readUTF8(itemOffset, charBuffer);
            Type type = Type.getObjectType((String)classDescriptor);
            this.maybeAddDependentType(this.privateTypes, type);
        }
    }

    protected void maybeAddDependentType(Set<String> types, Type type) {
        while (type.getSort() == 9) {
            type = type.getElementType();
        }
        if (type.getSort() != 10) {
            return;
        }
        String name = type.getClassName();
        if (this.typeFilter.test(name)) {
            types.add(this.interner.intern(name));
        }
    }

    public Set<String> getPrivateClassDependencies() {
        return this.privateTypes;
    }

    public Set<String> getAccessibleClassDependencies() {
        return this.accessibleTypes;
    }

    public IntSet getConstants() {
        return this.constants;
    }

    private boolean isAnnotationType(String[] interfaces) {
        return interfaces.length == 1 && interfaces[0].equals("java/lang/annotation/Annotation");
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        Set<String> types = ClassDependenciesVisitor.isAccessible(access) ? this.accessibleTypes : this.privateTypes;
        this.maybeAddDependentType(types, Type.getType((String)desc));
        if (ClassDependenciesVisitor.isAccessibleConstant(access, value)) {
            this.constants.add((name + '|' + value).hashCode());
        }
        return new FieldVisitor(types);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Set<String> types = ClassDependenciesVisitor.isAccessible(access) ? this.accessibleTypes : this.privateTypes;
        Type methodType = Type.getMethodType((String)desc);
        this.maybeAddDependentType(types, methodType.getReturnType());
        for (Type argType : methodType.getArgumentTypes()) {
            this.maybeAddDependentType(types, argType);
        }
        return new MethodVisitor(types);
    }

    public org.gradle.internal.impldep.org.objectweb.asm.AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.isAnnotationType && "Ljava/lang/annotation/Retention;".equals(desc)) {
            return this.retentionPolicyVisitor;
        }
        this.maybeAddDependentType(this.accessibleTypes, Type.getType((String)desc));
        return new AnnotationVisitor(this.accessibleTypes);
    }

    private static boolean isAccessible(int access) {
        return (access & 2) == 0;
    }

    private static boolean isAccessibleConstant(int access, Object value) {
        return ClassDependenciesVisitor.isConstant(access) && ClassDependenciesVisitor.isAccessible(access) && value != null;
    }

    private static boolean isConstant(int access) {
        return (access & 0x10) != 0 && (access & 8) != 0;
    }

    public String getDependencyToAllReason() {
        return this.dependencyToAllReason;
    }

    private class AnnotationVisitor
    extends org.gradle.internal.impldep.org.objectweb.asm.AnnotationVisitor {
        private final Set<String> types;

        public AnnotationVisitor(Set<String> types) {
            super(589824);
            this.types = types;
        }

        public void visit(String name, Object value) {
            if (value instanceof Type) {
                ClassDependenciesVisitor.this.maybeAddDependentType(this.types, (Type)value);
            }
        }

        public org.gradle.internal.impldep.org.objectweb.asm.AnnotationVisitor visitArray(String name) {
            return this;
        }

        public org.gradle.internal.impldep.org.objectweb.asm.AnnotationVisitor visitAnnotation(String name, String descriptor) {
            ClassDependenciesVisitor.this.maybeAddDependentType(this.types, Type.getType((String)descriptor));
            return this;
        }
    }

    private class RetentionPolicyVisitor
    extends org.gradle.internal.impldep.org.objectweb.asm.AnnotationVisitor {
        public RetentionPolicyVisitor() {
            super(589824);
        }

        public void visitEnum(String name, String desc, String value) {
            RetentionPolicy policy;
            if ("Ljava/lang/annotation/RetentionPolicy;".equals(desc) && (policy = RetentionPolicy.valueOf(value)) == RetentionPolicy.SOURCE) {
                ClassDependenciesVisitor.this.dependencyToAllReason = "source retention annotation '" + name + "' has changed";
            }
        }
    }

    private class MethodVisitor
    extends org.gradle.internal.impldep.org.objectweb.asm.MethodVisitor {
        private final Set<String> types;

        protected MethodVisitor(Set<String> types) {
            super(589824);
            this.types = types;
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            ClassDependenciesVisitor.this.maybeAddDependentType(this.types, Type.getType((String)desc));
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }

        public org.gradle.internal.impldep.org.objectweb.asm.AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            ClassDependenciesVisitor.this.maybeAddDependentType(this.types, Type.getType((String)descriptor));
            return new AnnotationVisitor(this.types);
        }

        public org.gradle.internal.impldep.org.objectweb.asm.AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
            ClassDependenciesVisitor.this.maybeAddDependentType(this.types, Type.getType((String)descriptor));
            return new AnnotationVisitor(this.types);
        }

        public org.gradle.internal.impldep.org.objectweb.asm.AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            ClassDependenciesVisitor.this.maybeAddDependentType(this.types, Type.getType((String)descriptor));
            return new AnnotationVisitor(this.types);
        }
    }

    private class FieldVisitor
    extends org.gradle.internal.impldep.org.objectweb.asm.FieldVisitor {
        private final Set<String> types;

        public FieldVisitor(Set<String> types) {
            super(589824);
            this.types = types;
        }

        public org.gradle.internal.impldep.org.objectweb.asm.AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            ClassDependenciesVisitor.this.maybeAddDependentType(this.types, Type.getType((String)descriptor));
            return new AnnotationVisitor(this.types);
        }

        public org.gradle.internal.impldep.org.objectweb.asm.AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            ClassDependenciesVisitor.this.maybeAddDependentType(this.types, Type.getType((String)descriptor));
            return new AnnotationVisitor(this.types);
        }
    }
}

