/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.junit.result.TestFailure;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.internal.tasks.testing.report.ClassTestResults;
import org.gradle.api.internal.tasks.testing.report.PageRenderer;
import org.gradle.api.internal.tasks.testing.report.TestResult;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.html.SimpleHtmlWriter;
import org.gradle.internal.xml.SimpleMarkupWriter;
import org.gradle.reporting.CodePanelRenderer;
import org.gradle.util.internal.GUtil;

class ClassPageRenderer
extends PageRenderer<ClassTestResults> {
    private final CodePanelRenderer codePanelRenderer = new CodePanelRenderer();
    private final TestResultsProvider resultsProvider;

    public ClassPageRenderer(TestResultsProvider provider) {
        this.resultsProvider = provider;
    }

    @Override
    protected void renderBreadcrumbs(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("div").attribute("class", "breadcrumbs").startElement("a").attribute("href", ((ClassTestResults)this.getResults()).getUrlTo(((ClassTestResults)this.getResults()).getParent().getParent())).characters("all").endElement().characters(" > ").startElement("a").attribute("href", ((ClassTestResults)this.getResults()).getUrlTo(((ClassTestResults)this.getResults()).getPackageResults())).characters(((ClassTestResults)this.getResults()).getPackageResults().getName()).endElement().characters(" > " + ((ClassTestResults)this.getResults()).getSimpleName()).endElement();
    }

    private void renderTests(SimpleHtmlWriter htmlWriter) throws IOException {
        SimpleMarkupWriter writer2 = htmlWriter.startElement("table");
        this.renderTableHead(writer2, this.determineTableHeaders());
        boolean methodNameColumnExists = this.methodNameColumnExists();
        for (TestResult test : ((ClassTestResults)this.getResults()).getTestResults()) {
            this.renderTableRow(writer2, test, this.determineTableRow(test, methodNameColumnExists));
        }
        htmlWriter.endElement();
    }

    private List<String> determineTableRow(TestResult test, boolean methodNameColumnExists) {
        return methodNameColumnExists ? Arrays.asList(test.getDisplayName(), test.getName(), test.getFormattedDuration(), test.getFormattedResultType()) : Arrays.asList(test.getDisplayName(), test.getFormattedDuration(), test.getFormattedResultType());
    }

    private List<String> determineTableHeaders() {
        return this.methodNameColumnExists() ? Arrays.asList("Test", "Method name", "Duration", "Result") : Arrays.asList("Test", "Duration", "Result");
    }

    private void renderTableHead(SimpleMarkupWriter writer2, List<String> headers) throws IOException {
        writer2.startElement("thead").startElement("tr");
        for (String header : headers) {
            writer2.startElement("th").characters(header).endElement();
        }
        writer2.endElement().endElement();
    }

    private void renderTableRow(SimpleMarkupWriter writer2, TestResult test, List<String> rowCells) throws IOException {
        writer2.startElement("tr");
        for (String cell : rowCells) {
            writer2.startElement("td").attribute("class", test.getStatusClass()).characters(cell).endElement();
        }
        writer2.endElement();
    }

    private boolean methodNameColumnExists() {
        for (TestResult result2 : ((ClassTestResults)this.getResults()).getTestResults()) {
            if (result2.getName().equals(result2.getDisplayName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void renderFailures(SimpleHtmlWriter htmlWriter) throws IOException {
        for (TestResult test : ((ClassTestResults)this.getResults()).getFailures()) {
            htmlWriter.startElement("div").attribute("class", "test").startElement("a").attribute("name", test.getId().toString()).characters("").endElement().startElement("h3").attribute("class", test.getStatusClass()).characters(test.getDisplayName()).endElement();
            for (TestFailure failure : test.getFailures()) {
                String message2 = GUtil.isTrue(failure.getMessage()) && !failure.getStackTrace().contains(failure.getMessage()) ? failure.getMessage() + SystemProperties.getInstance().getLineSeparator() + SystemProperties.getInstance().getLineSeparator() + failure.getStackTrace() : failure.getStackTrace();
                this.codePanelRenderer.render(message2, htmlWriter);
            }
            htmlWriter.endElement();
        }
    }

    @Override
    protected void registerTabs() {
        this.addFailuresTab();
        this.addTab("Tests", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

            @Override
            public void doExecute(SimpleHtmlWriter writer2) throws IOException {
                ClassPageRenderer.this.renderTests(writer2);
            }
        });
        final long classId = ((ClassTestResults)this.getModel()).getId();
        if (this.resultsProvider.hasOutput(classId, TestOutputEvent.Destination.StdOut)) {
            this.addTab("Standard output", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

                @Override
                protected void doExecute(SimpleHtmlWriter htmlWriter) throws IOException {
                    htmlWriter.startElement("span").attribute("class", "code").startElement("pre").characters("");
                    ClassPageRenderer.this.resultsProvider.writeAllOutput(classId, TestOutputEvent.Destination.StdOut, htmlWriter);
                    htmlWriter.endElement().endElement();
                }
            });
        }
        if (this.resultsProvider.hasOutput(classId, TestOutputEvent.Destination.StdErr)) {
            this.addTab("Standard error", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

                @Override
                protected void doExecute(SimpleHtmlWriter element) throws Exception {
                    element.startElement("span").attribute("class", "code").startElement("pre").characters("");
                    ClassPageRenderer.this.resultsProvider.writeAllOutput(classId, TestOutputEvent.Destination.StdErr, element);
                    element.endElement().endElement();
                }
            });
        }
    }
}

