/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.versionmapping;

import java.util.Set;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.artifacts.result.ComponentResult;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.publish.internal.versionmapping.VariantVersionMappingStrategyInternal;

public class DefaultVariantVersionMappingStrategy
implements VariantVersionMappingStrategyInternal {
    private final ConfigurationContainer configurations;
    private final ProjectDependencyPublicationResolver projectResolver;
    private final ProjectRegistry<ProjectInternal> projectRegistry;
    private boolean usePublishedVersions;
    private Configuration targetConfiguration;

    public DefaultVariantVersionMappingStrategy(ConfigurationContainer configurations, ProjectDependencyPublicationResolver projectResolver, ProjectRegistry<ProjectInternal> projectRegistry) {
        this.configurations = configurations;
        this.projectResolver = projectResolver;
        this.projectRegistry = projectRegistry;
    }

    @Override
    public void fromResolutionResult() {
        this.usePublishedVersions = true;
    }

    @Override
    public void fromResolutionOf(Configuration configuration2) {
        this.usePublishedVersions = true;
        this.targetConfiguration = configuration2;
    }

    @Override
    public void fromResolutionOf(String configurationName) {
        this.fromResolutionOf(this.configurations.getByName(configurationName));
    }

    @Override
    public ModuleVersionIdentifier maybeResolveVersion(String group, String module, String projectPath) {
        if (this.usePublishedVersions && this.targetConfiguration != null) {
            ResolutionResult resolutionResult = this.targetConfiguration.getIncoming().getResolutionResult();
            Set<ResolvedComponentResult> resolvedComponentResults = resolutionResult.getAllComponents();
            for (ResolvedComponentResult selected : resolvedComponentResults) {
                ModuleVersionIdentifier moduleVersionIdentifier = selected.getModuleVersion();
                if (moduleVersionIdentifier == null || !group.equals(moduleVersionIdentifier.getGroup()) || !module.equals(moduleVersionIdentifier.getName())) continue;
                return moduleVersionIdentifier;
            }
            Set<? extends DependencyResult> allDependencies = resolutionResult.getAllDependencies();
            for (DependencyResult dependencyResult : allDependencies) {
                ProjectComponentSelector pcs;
                if (!(dependencyResult instanceof ResolvedDependencyResult)) continue;
                ComponentSelector rcs = dependencyResult.getRequested();
                ComponentResult selected = null;
                if (rcs instanceof ModuleComponentSelector) {
                    ModuleComponentSelector requested = (ModuleComponentSelector)rcs;
                    if (requested.getGroup().equals(group) && requested.getModule().equals(module)) {
                        selected = ((ResolvedDependencyResult)dependencyResult).getSelected();
                    }
                } else if (rcs instanceof ProjectComponentSelector && (pcs = (ProjectComponentSelector)rcs).getProjectPath().equals(projectPath)) {
                    selected = ((ResolvedDependencyResult)dependencyResult).getSelected();
                }
                if (selected == null) continue;
                if (selected.getId() instanceof ProjectComponentIdentifier) {
                    ProjectComponentIdentifier projectId = (ProjectComponentIdentifier)selected.getId();
                    return this.projectResolver.resolve(ModuleVersionIdentifier.class, this.projectRegistry.getProject(projectId.getProjectPath()));
                }
                return selected.getModuleVersion();
            }
        }
        return null;
    }

    public void setTargetConfiguration(Configuration target) {
        this.targetConfiguration = target;
    }
}

