/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.Properties;
import org.gradle.cache.internal.DefaultCleanupProgressMonitor;
import org.gradle.cache.internal.DirectoryCleanupAction;
import org.gradle.cache.internal.UsedGradleVersions;
import org.gradle.cache.internal.VersionSpecificCacheCleanupAction;
import org.gradle.cache.internal.WrapperDistributionCleanupAction;
import org.gradle.cache.scopes.GlobalScopedCache;
import org.gradle.initialization.GradleUserHomeDirProvider;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.util.internal.GUtil;

public class GradleUserHomeCleanupService
implements Stoppable {
    private static final long MAX_UNUSED_DAYS_FOR_RELEASES = 30L;
    private static final long MAX_UNUSED_DAYS_FOR_SNAPSHOTS = 7L;
    private static final String CACHE_CLEANUP_PROPERTY = "org.gradle.cache.cleanup";
    private final Deleter deleter;
    private final GradleUserHomeDirProvider userHomeDirProvider;
    private final GlobalScopedCache globalScopedCache;
    private final UsedGradleVersions usedGradleVersions;
    private final ProgressLoggerFactory progressLoggerFactory;

    public GradleUserHomeCleanupService(Deleter deleter, GradleUserHomeDirProvider userHomeDirProvider, GlobalScopedCache globalScopedCache, UsedGradleVersions usedGradleVersions, ProgressLoggerFactory progressLoggerFactory) {
        this.deleter = deleter;
        this.userHomeDirProvider = userHomeDirProvider;
        this.globalScopedCache = globalScopedCache;
        this.usedGradleVersions = usedGradleVersions;
        this.progressLoggerFactory = progressLoggerFactory;
    }

    @Override
    public void stop() {
        Properties properties;
        String cleanup;
        File gradleUserHomeDirectory = this.userHomeDirProvider.getGradleUserHomeDirectory();
        File gradleProperties2 = new File(gradleUserHomeDirectory, "gradle.properties");
        if (gradleProperties2.isFile() && (cleanup = (properties = GUtil.loadProperties(gradleProperties2)).getProperty(CACHE_CLEANUP_PROPERTY)) != null && cleanup.equals("false")) {
            return;
        }
        File cacheBaseDir = this.globalScopedCache.getRootDir();
        boolean wasCleanedUp = this.execute(new VersionSpecificCacheCleanupAction(cacheBaseDir, 30L, 7L, this.deleter));
        if (wasCleanedUp) {
            this.execute(new WrapperDistributionCleanupAction(gradleUserHomeDirectory, this.usedGradleVersions));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute(DirectoryCleanupAction action) {
        ProgressLogger progressLogger = this.startNewOperation(action.getClass(), action.getDisplayName());
        try {
            boolean bl = action.execute(new DefaultCleanupProgressMonitor(progressLogger));
            return bl;
        }
        finally {
            progressLogger.completed();
        }
    }

    private ProgressLogger startNewOperation(Class<?> loggerClass, String description) {
        return this.progressLoggerFactory.newOperation(loggerClass).start(description, description);
    }
}

