/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.service;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.internal.impldep.com.google.common.io.Closer;
import org.gradle.internal.impldep.com.google.common.io.Files;

public class StoreTarget
implements BuildCacheEntryWriter {
    private final File file;
    private boolean stored;

    public StoreTarget(File file) {
        this.file = file;
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        Closer closer = Closer.create();
        closer.register((Closeable)output);
        try {
            this.stored = true;
            Files.asByteSource((File)this.file).copyTo(output);
        }
        catch (Exception e) {
            throw closer.rethrow((Throwable)e);
        }
        finally {
            closer.close();
        }
    }

    public boolean isStored() {
        return this.stored;
    }

    @Override
    public long getSize() {
        return this.file.length();
    }
}

