/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.composite.CompositeBuildContext;
import org.gradle.composite.internal.CompositeBuildDependencySubstitutions;
import org.gradle.internal.Actions;
import org.gradle.internal.Pair;

public class DefaultBuildableCompositeBuildContext
implements CompositeBuildContext {
    private final Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> availableModules = new HashSet<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>>();
    private final List<Action<DependencySubstitution>> substitutionRules = new ArrayList<Action<DependencySubstitution>>();

    @Override
    public void addAvailableModules(Set<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> availableModules) {
        this.availableModules.addAll(availableModules);
    }

    @Override
    public void registerSubstitution(Action<DependencySubstitution> substitutions) {
        this.substitutionRules.add(substitutions);
    }

    @Override
    public Action<DependencySubstitution> getRuleAction() {
        ArrayList<Action<DependencySubstitution>> allActions = new ArrayList<Action<DependencySubstitution>>();
        if (!this.availableModules.isEmpty()) {
            allActions.add(new CompositeBuildDependencySubstitutions(this.availableModules));
        }
        allActions.addAll(this.substitutionRules);
        return Actions.composite(allActions);
    }

    @Override
    public boolean rulesMayAddProjectDependency() {
        return !this.availableModules.isEmpty() || !this.substitutionRules.isEmpty();
    }
}

