/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.configuration.ProjectsPreparer;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.initialization.SettingsPreparer;
import org.gradle.initialization.TaskExecutionPreparer;
import org.gradle.initialization.TaskSchedulingPreparer;
import org.gradle.internal.Describables;
import org.gradle.internal.build.BuildModelController;
import org.gradle.internal.model.StateTransitionController;
import org.gradle.internal.model.StateTransitionControllerFactory;

public class VintageBuildModelController
implements BuildModelController {
    private final ProjectsPreparer projectsPreparer;
    private final GradleInternal gradle;
    private final TaskSchedulingPreparer taskGraphPreparer;
    private final SettingsPreparer settingsPreparer;
    private final TaskExecutionPreparer taskExecutionPreparer;
    private final StateTransitionController<Stage> state;

    public VintageBuildModelController(GradleInternal gradle, ProjectsPreparer projectsPreparer, TaskSchedulingPreparer taskSchedulingPreparer, SettingsPreparer settingsPreparer, TaskExecutionPreparer taskExecutionPreparer, StateTransitionControllerFactory controllerFactory) {
        this.gradle = gradle;
        this.projectsPreparer = projectsPreparer;
        this.taskGraphPreparer = taskSchedulingPreparer;
        this.settingsPreparer = settingsPreparer;
        this.taskExecutionPreparer = taskExecutionPreparer;
        this.state = controllerFactory.newController(Describables.of("vintage state of", gradle.getOwner().getDisplayName()), Stage.Created);
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        this.prepareSettings();
        return this.gradle.getSettings();
    }

    @Override
    public GradleInternal getConfiguredModel() {
        this.prepareSettings();
        this.prepareProjects();
        return this.gradle;
    }

    @Override
    public void prepareToScheduleTasks() {
        this.prepareSettings();
        this.prepareProjects();
    }

    @Override
    public void initializeWorkGraph(ExecutionPlan plan) {
        this.state.inState(Stage.Configured, () -> this.taskGraphPreparer.prepareForTaskScheduling(this.gradle, plan));
    }

    @Override
    public void scheduleRequestedTasks(ExecutionPlan plan) {
        this.state.inState(Stage.Configured, () -> this.taskExecutionPreparer.prepareForTaskExecution(this.gradle, plan));
    }

    private void prepareSettings() {
        this.state.transitionIfNotPreviously(Stage.Created, Stage.SettingsLoaded, () -> this.settingsPreparer.prepareSettings(this.gradle));
    }

    private void prepareProjects() {
        this.state.transitionIfNotPreviously(Stage.SettingsLoaded, Stage.Configured, () -> this.projectsPreparer.prepareProjects(this.gradle));
    }

    private static enum Stage implements StateTransitionController.State
    {
        Created,
        SettingsLoaded,
        Configured;

    }
}

