/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import java.io.File;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.buildsrc.BuildSrcBuildListenerFactory;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;

public class BuildSrcUpdateFactory {
    private static final Logger LOGGER = Logging.getLogger(BuildSrcUpdateFactory.class);
    private final BuildTreeLifecycleController buildController;
    private final BuildSrcBuildListenerFactory listenerFactory;
    private final CachedClasspathTransformer cachedClasspathTransformer;

    public BuildSrcUpdateFactory(BuildTreeLifecycleController buildController, BuildSrcBuildListenerFactory listenerFactory, CachedClasspathTransformer cachedClasspathTransformer) {
        this.buildController = buildController;
        this.listenerFactory = listenerFactory;
        this.cachedClasspathTransformer = cachedClasspathTransformer;
    }

    @Nonnull
    public ClassPath create() {
        Collection<File> classpath = this.build();
        LOGGER.debug("Gradle source classpath is: {}", classpath);
        return this.cachedClasspathTransformer.transform(DefaultClassPath.of(classpath), CachedClasspathTransformer.StandardTransform.BuildLogic);
    }

    private Collection<File> build() {
        BuildSrcBuildListenerFactory.Listener listener2 = this.listenerFactory.create();
        this.buildController.beforeBuild(gradle -> gradle.addListener(listener2));
        this.buildController.scheduleAndRunTasks();
        return listener2.getRuntimeClasspath();
    }
}

