/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.composite.internal.BuildTreeWorkGraphController;
import org.gradle.internal.Describables;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.buildtree.BuildTreeFinishExecutor;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.BuildTreeModelAction;
import org.gradle.internal.buildtree.BuildTreeModelCreator;
import org.gradle.internal.buildtree.BuildTreeWorkExecutor;
import org.gradle.internal.buildtree.BuildTreeWorkGraph;
import org.gradle.internal.buildtree.BuildTreeWorkPreparer;
import org.gradle.internal.model.StateTransitionController;
import org.gradle.internal.model.StateTransitionControllerFactory;

public class DefaultBuildTreeLifecycleController
implements BuildTreeLifecycleController {
    private final BuildLifecycleController buildLifecycleController;
    private final BuildTreeWorkGraphController taskGraph;
    private final BuildTreeWorkPreparer workPreparer;
    private final BuildTreeWorkExecutor workExecutor;
    private final BuildTreeModelCreator modelCreator;
    private final BuildTreeFinishExecutor finishExecutor;
    private final StateTransitionController<State> state;

    public DefaultBuildTreeLifecycleController(BuildLifecycleController buildLifecycleController, BuildTreeWorkGraphController taskGraph, BuildTreeWorkPreparer workPreparer, BuildTreeWorkExecutor workExecutor, BuildTreeModelCreator modelCreator, BuildTreeFinishExecutor finishExecutor, StateTransitionControllerFactory controllerFactory) {
        this.buildLifecycleController = buildLifecycleController;
        this.taskGraph = taskGraph;
        this.workPreparer = workPreparer;
        this.modelCreator = modelCreator;
        this.workExecutor = workExecutor;
        this.finishExecutor = finishExecutor;
        this.state = controllerFactory.newController(Describables.of("build tree state"), State.NotStarted);
    }

    @Override
    public void beforeBuild(Consumer<? super GradleInternal> action) {
        this.state.inState(State.NotStarted, () -> action.accept(this.buildLifecycleController.getGradle()));
    }

    @Override
    public void scheduleAndRunTasks() {
        this.runBuild(this::doScheduleAndRunTasks);
    }

    @Override
    public <T> T fromBuildModel(boolean runTasks, BuildTreeModelAction<? extends T> action) {
        return this.runBuild(() -> {
            ExecutionResult<Void> result2;
            this.modelCreator.beforeTasks(action);
            if (runTasks && !(result2 = this.doScheduleAndRunTasks()).getFailures().isEmpty()) {
                return result2.asFailure();
            }
            Object model = this.modelCreator.fromBuildModel(action);
            return ExecutionResult.succeeded(model);
        });
    }

    private ExecutionResult<Void> doScheduleAndRunTasks() {
        return this.taskGraph.withNewWorkGraph(graph -> {
            this.workPreparer.scheduleRequestedTasks((BuildTreeWorkGraph)graph);
            return this.workExecutor.execute((BuildTreeWorkGraph)graph);
        });
    }

    @Override
    public <T> T withEmptyBuild(Function<? super SettingsInternal, T> action) {
        return this.runBuild(() -> {
            Object result2 = this.buildLifecycleController.withSettings(action);
            return ExecutionResult.succeeded(result2);
        });
    }

    private <T> T runBuild(Supplier<ExecutionResult<? extends T>> action) {
        return (T)this.state.transition(State.NotStarted, State.Complete, () -> {
            ExecutionResult result2;
            try {
                result2 = (ExecutionResult)action.get();
            }
            catch (Throwable t) {
                result2 = ExecutionResult.failed(t);
            }
            RuntimeException finalReportableFailure = this.finishExecutor.finishBuildTree(result2.getFailures());
            if (finalReportableFailure != null) {
                throw finalReportableFailure;
            }
            return result2.getValue();
        });
    }

    private static enum State implements StateTransitionController.State
    {
        NotStarted,
        Complete;

    }
}

