/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.deployment;

import java.util.Collection;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.deployment.internal.DeploymentRegistry;
import org.gradle.internal.deployment.JavaApplicationHandle;
import org.gradle.internal.jvm.Jvm;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.JavaExecHandleFactory;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Produces no cacheable output")
public class RunApplication
extends DefaultTask {
    private String mainClassName;
    private Collection<String> arguments;
    private FileCollection classpath;
    private DeploymentRegistry.ChangeBehavior changeBehavior = DeploymentRegistry.ChangeBehavior.RESTART;

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Input
    public Collection<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(Collection<String> arguments) {
        this.arguments = arguments;
    }

    @Input
    public String getMainClassName() {
        return this.mainClassName;
    }

    public void setMainClassName(String mainClassName) {
        this.mainClassName = mainClassName;
    }

    @TaskAction
    public void startApplication() {
        DeploymentRegistry registry = this.getDeploymentRegistry();
        JavaApplicationHandle handle = registry.get(this.getPath(), JavaApplicationHandle.class);
        if (handle == null) {
            JavaExecHandleBuilder builder = this.getExecActionFactory().newJavaExec();
            builder.setExecutable(Jvm.current().getJavaExecutable());
            builder.setClasspath(this.classpath);
            builder.getMainClass().set(this.mainClassName);
            builder.setArgs(this.arguments);
            registry.start(this.getPath(), this.changeBehavior, JavaApplicationHandle.class, builder);
        }
    }

    @Inject
    protected DeploymentRegistry getDeploymentRegistry() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected JavaExecHandleFactory getExecActionFactory() {
        throw new UnsupportedOperationException();
    }

    @Internal
    public DeploymentRegistry.ChangeBehavior getChangeBehavior() {
        return this.changeBehavior;
    }

    public void setChangeBehavior(DeploymentRegistry.ChangeBehavior changeBehavior) {
        this.changeBehavior = changeBehavior;
    }
}

