/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.exceptions;

import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.exceptions.ContextAwareException;
import org.gradle.internal.exceptions.ExceptionContextVisitor;
import org.gradle.internal.exceptions.FailureResolutionAware;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

public class LocationAwareException
extends ContextAwareException
implements FailureResolutionAware {
    private final String sourceDisplayName;
    private final Integer lineNumber;

    public LocationAwareException(Throwable cause, ScriptSource source, Integer lineNumber) {
        this(cause, source != null ? source.getDisplayName() : null, lineNumber);
    }

    public LocationAwareException(Throwable cause, String sourceDisplayName, Integer lineNumber) {
        super(cause);
        this.sourceDisplayName = sourceDisplayName;
        this.lineNumber = lineNumber;
    }

    public String getSourceDisplayName() {
        return this.sourceDisplayName;
    }

    public String getLocation() {
        if (this.sourceDisplayName == null) {
            return null;
        }
        String sourceMsg = StringUtils.capitalize((String)this.sourceDisplayName);
        if (this.lineNumber == null) {
            return sourceMsg;
        }
        return String.format("%s line: %d", sourceMsg, this.lineNumber);
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String getMessage() {
        String location = this.getLocation();
        String message2 = this.getCause().getMessage();
        if (location == null && message2 == null) {
            return null;
        }
        if (location == null) {
            return message2;
        }
        if (message2 == null) {
            return location;
        }
        return String.format("%s%n%s", location, message2);
    }

    @Override
    public void appendResolutions(FailureResolutionAware.Context context) {
        if (this.getCause() instanceof FailureResolutionAware) {
            FailureResolutionAware resolutionAware = (FailureResolutionAware)((Object)this.getCause());
            resolutionAware.appendResolutions(context);
        }
    }

    @Override
    public void accept(ExceptionContextVisitor contextVisitor) {
        super.accept(contextVisitor);
        String location = this.getLocation();
        if (location != null) {
            contextVisitor.visitLocation(location);
        }
    }
}

