/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.filewatch;

import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.filewatch.FileWatcher;
import org.gradle.internal.filewatch.FileWatcherFactory;
import org.gradle.internal.filewatch.FileWatcherListener;
import org.gradle.internal.filewatch.jdk7.Jdk7FileWatcherFactory;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileWatcherFactory
implements FileWatcherFactory,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileWatcherFactory.class);
    private static final int STOP_TIMEOUT_SECONDS = 10;
    private final ManagedExecutor executor;
    private final FileSystem fileSystem;
    private FileWatcherFactory fileWatcherFactory;

    public DefaultFileWatcherFactory(ExecutorFactory executorFactory, FileSystem fileSystem) {
        this.executor = executorFactory.create("File watcher");
        this.fileSystem = fileSystem;
    }

    protected FileWatcherFactory createFileWatcherFactory() {
        return new Jdk7FileWatcherFactory(this.executor, this.fileSystem);
    }

    @Override
    public void stop() {
        try {
            this.executor.stop(10, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.debug("Problem shutting down executor. The problem might be caused by JDK-8011537.", (Throwable)e);
        }
    }

    @Override
    public FileWatcher watch(Action<? super Throwable> onError, FileWatcherListener listener2) {
        if (this.fileWatcherFactory == null) {
            this.fileWatcherFactory = this.createFileWatcherFactory();
        }
        return this.fileWatcherFactory.watch(onError, listener2);
    }
}

