/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.CachingFileSystemLocationSnapshotHasher;
import org.gradle.api.internal.changedetection.state.LineEndingNormalizingFileSystemLocationSnapshotHasher;
import org.gradle.api.internal.changedetection.state.ResourceEntryFilter;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.changedetection.state.ResourceSnapshotterCacheService;
import org.gradle.internal.execution.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.execution.fingerprint.FileCollectionSnapshotter;
import org.gradle.internal.execution.fingerprint.impl.FingerprinterRegistration;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.LineEndingSensitivity;
import org.gradle.internal.fingerprint.classpath.impl.DefaultClasspathFingerprinter;
import org.gradle.internal.fingerprint.classpath.impl.DefaultCompileClasspathFingerprinter;
import org.gradle.internal.fingerprint.hashing.FileSystemLocationSnapshotHasher;
import org.gradle.internal.fingerprint.impl.AbsolutePathFileCollectionFingerprinter;
import org.gradle.internal.fingerprint.impl.AbstractFileCollectionFingerprinter;
import org.gradle.internal.fingerprint.impl.IgnoredPathFileCollectionFingerprinter;
import org.gradle.internal.fingerprint.impl.NameOnlyFileCollectionFingerprinter;
import org.gradle.internal.fingerprint.impl.RelativePathFileCollectionFingerprinter;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class FileCollectionFingerprinterRegistrations {
    private final Set<FingerprinterRegistration> registrants;

    public FileCollectionFingerprinterRegistrations(StringInterner stringInterner, FileCollectionSnapshotter fileCollectionSnapshotter, ResourceSnapshotterCacheService resourceSnapshotterCacheService, ResourceFilter resourceFilter, ResourceEntryFilter metaInfFilter, Map<String, ResourceEntryFilter> propertiesFileFilters) {
        List<? extends FileCollectionFingerprinter> insensitiveFingerprinters = FileCollectionFingerprinterRegistrations.insensitiveFingerprinters(resourceSnapshotterCacheService, fileCollectionSnapshotter, stringInterner);
        this.registrants = (Set)FileCollectionFingerprinterRegistrations.withAllLineEndingSensitivities(lineEndingSensitivity -> {
            FileSystemLocationSnapshotHasher normalizedContentHasher = FileCollectionFingerprinterRegistrations.normalizedContentHasher(lineEndingSensitivity, resourceSnapshotterCacheService);
            List<? extends FileCollectionFingerprinter> directoryInsensitiveFingerprinters = FileCollectionFingerprinterRegistrations.directoryInsensitiveFingerprinters(lineEndingSensitivity, normalizedContentHasher, fileCollectionSnapshotter, resourceSnapshotterCacheService, resourceFilter, metaInfFilter, propertiesFileFilters, stringInterner);
            return FileCollectionFingerprinterRegistrations.withAllDirectorySensitivities(directorySensitivity -> FileCollectionFingerprinterRegistrations.registrationsFor(lineEndingSensitivity, directorySensitivity, Stream.of(FileCollectionFingerprinterRegistrations.fullySensitiveFingerprinters(directorySensitivity, stringInterner, fileCollectionSnapshotter, normalizedContentHasher), directoryInsensitiveFingerprinters, insensitiveFingerprinters)));
        }).collect(ImmutableSet.toImmutableSet());
    }

    private static List<? extends FileCollectionFingerprinter> fullySensitiveFingerprinters(DirectorySensitivity directorySensitivity, StringInterner stringInterner, FileCollectionSnapshotter fileCollectionSnapshotter, FileSystemLocationSnapshotHasher normalizedContentHasher) {
        return Lists.newArrayList((Object[])new AbstractFileCollectionFingerprinter[]{new AbsolutePathFileCollectionFingerprinter(directorySensitivity, fileCollectionSnapshotter, normalizedContentHasher), new RelativePathFileCollectionFingerprinter(stringInterner, directorySensitivity, fileCollectionSnapshotter, normalizedContentHasher), new NameOnlyFileCollectionFingerprinter(directorySensitivity, fileCollectionSnapshotter, normalizedContentHasher)});
    }

    private static List<? extends FileCollectionFingerprinter> directoryInsensitiveFingerprinters(LineEndingSensitivity lineEndingSensitivity, FileSystemLocationSnapshotHasher normalizedContentHasher, FileCollectionSnapshotter fileCollectionSnapshotter, ResourceSnapshotterCacheService resourceSnapshotterCacheService, ResourceFilter resourceFilter, ResourceEntryFilter metaInfFilter, Map<String, ResourceEntryFilter> propertiesFileFilters, StringInterner stringInterner) {
        return Lists.newArrayList((Object[])new AbstractFileCollectionFingerprinter[]{new IgnoredPathFileCollectionFingerprinter(fileCollectionSnapshotter, normalizedContentHasher), new DefaultClasspathFingerprinter(resourceSnapshotterCacheService, fileCollectionSnapshotter, resourceFilter, metaInfFilter, propertiesFileFilters, stringInterner, lineEndingSensitivity)});
    }

    private static List<? extends FileCollectionFingerprinter> insensitiveFingerprinters(ResourceSnapshotterCacheService resourceSnapshotterCacheService, FileCollectionSnapshotter fileCollectionSnapshotter, StringInterner stringInterner) {
        return Lists.newArrayList((Object[])new DefaultCompileClasspathFingerprinter[]{new DefaultCompileClasspathFingerprinter(resourceSnapshotterCacheService, fileCollectionSnapshotter, stringInterner)});
    }

    private static Stream<FingerprinterRegistration> registrationsFor(LineEndingSensitivity lineEndingSensitivity, DirectorySensitivity directorySensitivity, Stream<List<? extends FileCollectionFingerprinter>> fingerprinters) {
        return fingerprinters.flatMap(Collection::stream).map(fingerprinter -> FingerprinterRegistration.registration(directorySensitivity, lineEndingSensitivity, fingerprinter));
    }

    private static <T> Stream<T> withAllLineEndingSensitivities(Function<LineEndingSensitivity, Stream<T>> f) {
        return Arrays.stream(LineEndingSensitivity.values()).flatMap(f);
    }

    private static <T> Stream<T> withAllDirectorySensitivities(Function<DirectorySensitivity, Stream<T>> f) {
        return Stream.of(DirectorySensitivity.DEFAULT, DirectorySensitivity.IGNORE_DIRECTORIES).flatMap(f);
    }

    public Set<FingerprinterRegistration> getRegistrants() {
        return this.registrants;
    }

    private static FileSystemLocationSnapshotHasher normalizedContentHasher(LineEndingSensitivity lineEndingSensitivity, ResourceSnapshotterCacheService resourceSnapshotterCacheService) {
        FileSystemLocationSnapshotHasher resourceHasher = LineEndingNormalizingFileSystemLocationSnapshotHasher.wrap(FileSystemLocationSnapshotHasher.DEFAULT, lineEndingSensitivity);
        return FileCollectionFingerprinterRegistrations.cacheIfNormalized(resourceHasher, lineEndingSensitivity, resourceSnapshotterCacheService);
    }

    private static FileSystemLocationSnapshotHasher cacheIfNormalized(FileSystemLocationSnapshotHasher resourceHasher, LineEndingSensitivity lineEndingSensitivity, ResourceSnapshotterCacheService resourceSnapshotterCacheService) {
        switch (lineEndingSensitivity) {
            case DEFAULT: {
                return resourceHasher;
            }
            case NORMALIZE_LINE_ENDINGS: {
                return new CachingFileSystemLocationSnapshotHasher(resourceHasher, resourceSnapshotterCacheService);
            }
        }
        throw new IllegalArgumentException();
    }
}

