/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import javax.annotation.Nullable;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.time.Clock;

@ServiceScope(value=Scope.Global.class)
public class BuildOperationProgressEventEmitter {
    private final Clock clock;
    private final CurrentBuildOperationRef current;
    private final BuildOperationListener listener;

    public BuildOperationProgressEventEmitter(Clock clock, CurrentBuildOperationRef current, BuildOperationListener listener2) {
        this.clock = clock;
        this.current = current;
        this.listener = listener2;
    }

    public void emit(OperationIdentifier operationIdentifier, long timestamp, @Nullable Object details) {
        if (operationIdentifier == null) {
            throw new IllegalArgumentException("operationIdentifier is null");
        }
        this.doEmit(operationIdentifier, timestamp, details);
    }

    public void emitNowIfCurrent(Object details) {
        this.emitIfCurrent(this.clock.getCurrentTime(), details);
    }

    public void emitIfCurrent(long time, Object details) {
        OperationIdentifier currentOperationIdentifier = this.current.getId();
        if (currentOperationIdentifier != null) {
            this.doEmit(currentOperationIdentifier, time, details);
        }
    }

    public void emitNowForCurrent(Object details) {
        this.emitForCurrent(this.clock.getCurrentTime(), details);
    }

    private void emitForCurrent(long time, Object details) {
        OperationIdentifier currentOperationIdentifier = this.current.getId();
        if (currentOperationIdentifier == null) {
            throw new IllegalStateException("No current build operation");
        }
        this.doEmit(currentOperationIdentifier, time, details);
    }

    private void doEmit(OperationIdentifier operationIdentifier, long timestamp, @Nullable Object details) {
        this.listener.progress(operationIdentifier, new OperationProgressEvent(timestamp, details));
    }
}

