/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.xml.XmlValidation;

public class SimpleMarkupWriter
extends Writer {
    private static final String LINE_SEPARATOR = SystemProperties.getInstance().getLineSeparator();
    private final Writer output;
    private final Deque<String> elements = new ArrayDeque<String>();
    private Context context = Context.Outside;
    private int squareBrackets;
    private final String indent;

    protected SimpleMarkupWriter(Writer writer2, String indent) throws IOException {
        this.indent = indent;
        this.output = writer2;
    }

    @Override
    public void write(char[] chars, int offset, int length) throws IOException {
        this.characters(chars, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    @Override
    public void close() throws IOException {
    }

    public SimpleMarkupWriter characters(char[] characters) throws IOException {
        this.characters(characters, 0, characters.length);
        return this;
    }

    public SimpleMarkupWriter characters(char[] characters, int start, int count) throws IOException {
        if (this.context == Context.CData) {
            this.writeCDATA(characters, start, count);
        } else {
            this.maybeStartText();
            this.writeXmlEncoded(characters, start, count);
        }
        return this;
    }

    public SimpleMarkupWriter characters(CharSequence characters) throws IOException {
        if (this.context == Context.CData) {
            this.writeCDATA(characters);
        } else {
            this.maybeStartText();
            this.writeXmlEncoded(characters);
        }
        return this;
    }

    private void maybeStartText() throws IOException {
        if (this.context == Context.Outside) {
            throw new IllegalStateException("Cannot write text, as there are no started elements.");
        }
        if (this.context == Context.StartTag) {
            this.writeRaw(">");
        }
        this.context = Context.Text;
    }

    private void maybeFinishStartTag() throws IOException {
        if (this.context == Context.StartTag) {
            this.writeRaw(">");
            this.context = Context.ElementContent;
        }
    }

    public SimpleMarkupWriter startElement(String name) throws IOException {
        if (!XmlValidation.isValidXmlName(name)) {
            throw new IllegalArgumentException(String.format("Invalid element name: '%s'", name));
        }
        if (this.context == Context.CData) {
            throw new IllegalStateException("Cannot start element, as current CDATA node has not been closed.");
        }
        this.maybeFinishStartTag();
        if (this.indent != null) {
            this.writeRaw(LINE_SEPARATOR);
            for (int i = 0; i < this.elements.size(); ++i) {
                this.writeRaw(this.indent);
            }
        }
        this.context = Context.StartTag;
        this.elements.add(name);
        this.writeRaw("<");
        this.writeRaw(name);
        return this;
    }

    public SimpleMarkupWriter endElement() throws IOException {
        if (this.context == Context.Outside) {
            throw new IllegalStateException("Cannot end element, as there are no started elements.");
        }
        if (this.context == Context.CData) {
            throw new IllegalStateException("Cannot end element, as current CDATA node has not been closed.");
        }
        if (this.context == Context.StartTag) {
            this.writeRaw("/>");
            this.elements.removeLast();
        } else {
            if (this.context != Context.Text && this.indent != null) {
                this.writeRaw(LINE_SEPARATOR);
                for (int i = 1; i < this.elements.size(); ++i) {
                    this.writeRaw(this.indent);
                }
            }
            this.writeRaw("</");
            this.writeRaw(this.elements.removeLast());
            this.writeRaw(">");
        }
        if (this.elements.isEmpty()) {
            if (this.indent != null) {
                this.writeRaw(LINE_SEPARATOR);
            }
            this.output.flush();
            this.context = Context.Outside;
        } else {
            this.context = Context.ElementContent;
        }
        return this;
    }

    private void writeCDATA(char[] cdata, int offset, int count) throws IOException {
        int codePoint;
        int end = offset + count;
        for (int i = offset; i < end; i += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(cdata, i);
            this.writeCDATA(codePoint);
        }
    }

    private void writeCDATA(CharSequence cdata) throws IOException {
        int codePoint;
        int len = cdata.length();
        for (int i = 0; i < len; i += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(cdata, i);
            this.writeCDATA(codePoint);
        }
    }

    private void writeCDATA(int ch) throws IOException {
        if (this.needsCDATAEscaping(ch)) {
            this.writeRaw("]]><![CDATA[>");
        } else if (!XmlValidation.isLegalCharacter(ch)) {
            this.writeRaw('?');
        } else if (ch <= 65535 && XmlValidation.isRestrictedCharacter((char)ch) || Character.charCount(ch) == 2) {
            this.writeRaw("]]>");
            this.writeCharacterReference(ch);
            this.writeRaw("<![CDATA[");
        } else {
            this.writeRaw((char)ch);
        }
    }

    private void writeCharacterReference(int ch) throws IOException {
        this.writeRaw("&#x");
        this.writeRaw(Integer.toHexString(ch));
        this.writeRaw(";");
    }

    private boolean needsCDATAEscaping(int ch) {
        switch (ch) {
            case 93: {
                ++this.squareBrackets;
                return false;
            }
            case 62: {
                if (this.squareBrackets >= 2) {
                    this.squareBrackets = 0;
                    return true;
                }
                return false;
            }
        }
        this.squareBrackets = 0;
        return false;
    }

    public SimpleMarkupWriter startCDATA() throws IOException {
        if (this.context == Context.CData) {
            throw new IllegalStateException("Cannot start CDATA node, as current CDATA node has not been closed.");
        }
        this.maybeFinishStartTag();
        this.writeRaw("<![CDATA[");
        this.context = Context.CData;
        this.squareBrackets = 0;
        return this;
    }

    public SimpleMarkupWriter endCDATA() throws IOException {
        if (this.context != Context.CData) {
            throw new IllegalStateException("Cannot end CDATA node, as not currently in a CDATA node.");
        }
        this.writeRaw("]]>");
        this.context = Context.Text;
        return this;
    }

    public SimpleMarkupWriter comment(String comment) throws IOException {
        if (comment.contains("--")) {
            throw new IllegalArgumentException("'--' is invalid inside an XML comment: " + comment);
        }
        this.maybeFinishStartTag();
        if (this.indent != null) {
            this.writeRaw(LINE_SEPARATOR);
            for (int i = 0; i < this.elements.size(); ++i) {
                this.writeRaw(this.indent);
            }
        }
        this.writeRaw("<!--");
        if (!StringUtils.isBlank((String)comment.substring(0, 1))) {
            this.writeRaw(" ");
        }
        this.writeSafeCharacters(comment);
        if (!StringUtils.isBlank((String)comment.substring(comment.length() - 1))) {
            this.writeRaw(" ");
        }
        this.writeRaw("-->");
        return this;
    }

    public SimpleMarkupWriter attribute(String name, String value) throws IOException {
        if (!XmlValidation.isValidXmlName(name)) {
            throw new IllegalArgumentException(String.format("Invalid attribute name: '%s'", name));
        }
        if (this.context != Context.StartTag) {
            throw new IllegalStateException("Cannot write attribute [" + name + ":" + value + "]. You should write start element first.");
        }
        this.writeRaw(" ");
        this.writeRaw(name);
        this.writeRaw("=\"");
        this.writeXmlAttributeEncoded(value);
        this.writeRaw("\"");
        return this;
    }

    private void writeRaw(char c) throws IOException {
        this.output.write(c);
    }

    protected void writeRaw(String message2) throws IOException {
        this.output.write(message2);
    }

    private void writeXmlEncoded(char[] message2, int offset, int count) throws IOException {
        int codePoint;
        int end = offset + count;
        for (int i = offset; i < end; i += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(message2, i);
            this.writeXmlEncoded(codePoint);
        }
    }

    private void writeXmlAttributeEncoded(CharSequence message2) throws IOException {
        int codePoint;
        assert (message2 != null);
        int len = message2.length();
        for (int i = 0; i < len; i += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(message2, i);
            this.writeXmlAttributeEncoded(codePoint);
        }
    }

    private void writeXmlAttributeEncoded(int ch) throws IOException {
        if (ch == 9) {
            this.writeRaw("&#9;");
        } else if (ch == 10) {
            this.writeRaw("&#10;");
        } else if (ch == 13) {
            this.writeRaw("&#13;");
        } else {
            this.writeXmlEncoded(ch);
        }
    }

    private void writeXmlEncoded(CharSequence message2) throws IOException {
        int codePoint;
        assert (message2 != null);
        int len = message2.length();
        for (int i = 0; i < len; i += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(message2, i);
            this.writeXmlEncoded(codePoint);
        }
    }

    private void writeSafeCharacters(CharSequence message2) throws IOException {
        int codePoint;
        assert (message2 != null);
        int len = message2.length();
        for (int i = 0; i < len; i += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(message2, i);
            this.writeSafeCharacter(codePoint);
        }
    }

    private void writeXmlEncoded(int ch) throws IOException {
        if (ch == 60) {
            this.writeRaw("&lt;");
        } else if (ch == 62) {
            this.writeRaw("&gt;");
        } else if (ch == 38) {
            this.writeRaw("&amp;");
        } else if (ch == 34) {
            this.writeRaw("&quot;");
        } else {
            this.writeSafeCharacter(ch);
        }
    }

    private void writeSafeCharacter(int ch) throws IOException {
        if (!XmlValidation.isLegalCharacter(ch)) {
            this.writeRaw('?');
        } else if (ch <= 65535 && XmlValidation.isRestrictedCharacter((char)ch) || Character.charCount(ch) == 2) {
            this.writeCharacterReference(ch);
        } else {
            this.writeRaw((char)ch);
        }
    }

    private static enum Context {
        Outside,
        Text,
        CData,
        StartTag,
        ElementContent;

    }
}

