/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import javax.inject.Inject;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.attributes.AttributeCompatibilityRule;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectPublicationRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.nativeplatform.internal.DefaultNativeComponent;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.plugins.NativeBasePlugin;
import org.gradle.language.swift.ProductionSwiftComponent;
import org.gradle.language.swift.SwiftSharedLibrary;
import org.gradle.language.swift.SwiftStaticLibrary;
import org.gradle.language.swift.internal.DefaultSwiftBinary;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.nativeplatform.toolchain.internal.xcode.MacOSSdkPathLocator;
import org.gradle.nativeplatform.toolchain.plugins.SwiftCompilerPlugin;
import org.gradle.swiftpm.internal.NativeProjectPublication;
import org.gradle.swiftpm.internal.SwiftPmTarget;

public class SwiftBasePlugin
implements Plugin<Project> {
    private final ProjectPublicationRegistry publicationRegistry;
    private final MacOSSdkPathLocator locator;

    @Inject
    public SwiftBasePlugin(ProjectPublicationRegistry publicationRegistry, MacOSSdkPathLocator locator) {
        this.publicationRegistry = publicationRegistry;
        this.locator = locator;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(NativeBasePlugin.class);
        project.getPluginManager().apply(SwiftCompilerPlugin.class);
        TaskContainer tasks = project.getTasks();
        DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        project.getDependencies().getAttributesSchema().attribute(Usage.USAGE_ATTRIBUTE).getCompatibilityRules().add(SwiftCppUsageCompatibilityRule.class);
        project.getComponents().withType(DefaultSwiftBinary.class, binary -> {
            Names names = binary.getNames();
            NamedDomainObjectProvider compile = tasks.register(names.getCompileTaskName("swift"), SwiftCompile.class, task -> {
                task.getModules().from(binary.getCompileModules());
                task.getSource().from(binary.getSwiftSource());
                task.getDebuggable().set(binary.isDebuggable());
                task.getOptimized().set(binary.isOptimized());
                if (binary.isTestable()) {
                    task.getCompilerArgs().add("-enable-testing");
                }
                if (binary.getTargetMachine().getOperatingSystemFamily().isMacOs()) {
                    task.getCompilerArgs().add("-sdk");
                    task.getCompilerArgs().add(this.locator.find().getAbsolutePath());
                }
                task.getModuleName().set(binary.getModule());
                task.getObjectFileDir().set(buildDirectory.dir("obj/" + names.getDirName()));
                task.getModuleFile().set(buildDirectory.file(binary.getModule().map(moduleName -> "modules/" + names.getDirName() + moduleName + ".swiftmodule")));
                task.getSourceCompatibility().set(binary.getTargetPlatform().getSourceCompatibility());
                task.getTargetPlatform().set(binary.getNativePlatform());
                task.getToolChain().set(binary.getToolChain());
                if (binary instanceof SwiftSharedLibrary || binary instanceof SwiftStaticLibrary) {
                    task.getCompilerArgs().add("-parse-as-library");
                }
            });
            binary.getModuleFile().set(compile.flatMap(task -> task.getModuleFile()));
            binary.getCompileTask().set(compile);
            binary.getObjectsDir().set(compile.flatMap(task -> task.getObjectFileDir()));
        });
        project.getComponents().withType(ProductionSwiftComponent.class, component -> project.afterEvaluate(p -> {
            DefaultNativeComponent componentInternal = (DefaultNativeComponent)((Object)component);
            this.publicationRegistry.registerPublication((ProjectInternal)project, new NativeProjectPublication(componentInternal.getDisplayName(), new SwiftPmTarget((String)component.getModule().get())));
        }));
    }

    static class SwiftCppUsageCompatibilityRule
    implements AttributeCompatibilityRule<Usage> {
        SwiftCppUsageCompatibilityRule() {
        }

        @Override
        public void execute(CompatibilityCheckDetails<Usage> details) {
            if ("swift-api".equals(details.getConsumerValue().getName()) && "cplusplus-api".equals(details.getProducerValue().getName())) {
                details.compatible();
            }
        }
    }
}

