/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model;

import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;

@Incubating
public class WriteOnlyModelViewException
extends GradleException {
    public WriteOnlyModelViewException(String property, ModelPath path, ModelType<?> type, ModelRuleDescriptor ruleDescriptor) {
        super(WriteOnlyModelViewException.createMessage(property, path, type, ruleDescriptor));
    }

    private static String createMessage(String property, ModelPath path, ModelType<?> type, ModelRuleDescriptor ruleDescriptor) {
        StringBuilder result2 = new StringBuilder();
        result2.append("Attempt to read");
        if (property != null) {
            result2.append(" property '");
            result2.append(property);
            result2.append("'");
        }
        result2.append(" from a write only view of model element '");
        result2.append(path);
        result2.append("'");
        if (!type.equals(ModelType.UNTYPED)) {
            result2.append(" of type '");
            result2.append(type.getDisplayName());
            result2.append("'");
        }
        result2.append(" given to rule ");
        ruleDescriptor.describeTo(result2);
        return result2.toString();
    }
}

