/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.component.internal;

import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.sources.BaseLanguageSourceSet;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.typeregistration.BaseInstanceFactory;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.binary.BaseBinarySpec;
import org.gradle.platform.base.component.internal.DefaultComponentSpec;
import org.gradle.platform.base.internal.ComponentSpecIdentifier;
import org.gradle.platform.base.internal.ComponentSpecInternal;
import org.gradle.platform.base.internal.DefaultComponentSpecIdentifier;

public class ComponentSpecFactory
extends BaseInstanceFactory<ComponentSpec> {
    private final ProjectIdentifier projectIdentifier;

    public ComponentSpecFactory(ProjectIdentifier projectIdentifier, final Instantiator instantiator, final NamedEntityInstantiator<Task> taskInstantiator, final ObjectFactory objectFactory, final CollectionCallbackActionDecorator collectionCallbackActionDecorator, final DomainObjectCollectionFactory domainObjectCollectionFactory) {
        super(ComponentSpec.class);
        this.projectIdentifier = projectIdentifier;
        this.registerFactory(DefaultComponentSpec.class, new BaseInstanceFactory.ImplementationFactory<ComponentSpec, DefaultComponentSpec>(){

            @Override
            public <T extends DefaultComponentSpec> T create(ModelType<? extends ComponentSpec> publicType, ModelType<T> implementationType, String name, MutableModelNode componentNode) {
                ComponentSpecIdentifier id = ComponentSpecFactory.this.getId(ComponentSpecFactory.this.findOwner(componentNode), name);
                return DefaultComponentSpec.create(publicType.getConcreteClass(), implementationType.getConcreteClass(), id, componentNode);
            }
        });
        this.registerFactory(BaseBinarySpec.class, new BaseInstanceFactory.ImplementationFactory<BinarySpec, BaseBinarySpec>(){

            @Override
            public <T extends BaseBinarySpec> T create(ModelType<? extends BinarySpec> publicType, ModelType<T> implementationType, String name, MutableModelNode binaryNode) {
                MutableModelNode componentNode = ComponentSpecFactory.this.findOwner(binaryNode);
                ComponentSpecIdentifier id = ComponentSpecFactory.this.getId(componentNode, name);
                return BaseBinarySpec.create(publicType.getConcreteClass(), implementationType.getConcreteClass(), id, binaryNode, componentNode, instantiator, taskInstantiator, collectionCallbackActionDecorator, domainObjectCollectionFactory);
            }
        });
        this.registerFactory(BaseLanguageSourceSet.class, new BaseInstanceFactory.ImplementationFactory<LanguageSourceSet, BaseLanguageSourceSet>(){

            @Override
            public <T extends BaseLanguageSourceSet> T create(ModelType<? extends LanguageSourceSet> publicType, ModelType<T> implementationType, String sourceSetName, MutableModelNode node) {
                ComponentSpecIdentifier id = ComponentSpecFactory.this.getId(ComponentSpecFactory.this.findOwner(node), sourceSetName);
                return (T)((BaseLanguageSourceSet)Cast.uncheckedCast(BaseLanguageSourceSet.create(publicType.getConcreteClass(), implementationType.getConcreteClass(), id, objectFactory)));
            }
        });
    }

    @Nullable
    private ComponentSpecIdentifier getId(@Nullable MutableModelNode ownerNode, String name) {
        if (ownerNode != null) {
            ComponentSpecInternal componentSpec = ownerNode.asImmutable(ModelType.of(ComponentSpecInternal.class), null).getInstance();
            return componentSpec.getIdentifier().child(name);
        }
        return new DefaultComponentSpecIdentifier(this.projectIdentifier.getPath(), name);
    }

    @Nullable
    private MutableModelNode findOwner(MutableModelNode modelNode) {
        MutableModelNode grandparentNode = modelNode.getParent().getParent();
        if (grandparentNode != null && grandparentNode.canBeViewedAs(ModelType.of(ComponentSpecInternal.class))) {
            return grandparentNode;
        }
        return null;
    }
}

