/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.toolchain;

import org.gradle.internal.logging.text.DiagnosticsVisitor;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.platform.base.internal.toolchain.ToolSearchResult;

public class ToolChainAvailability
implements ToolSearchResult {
    private ToolSearchResult reason;

    @Override
    public boolean isAvailable() {
        return this.reason == null;
    }

    public String getUnavailableMessage() {
        TreeFormatter formatter = new TreeFormatter();
        this.explain(formatter);
        return formatter.toString();
    }

    @Override
    public void explain(DiagnosticsVisitor visitor) {
        this.reason.explain(visitor);
    }

    public ToolChainAvailability unavailable(String unavailableMessage) {
        if (this.reason == null) {
            this.reason = new FixedMessageToolSearchResult(unavailableMessage);
        }
        return this;
    }

    public ToolChainAvailability unsupported(String unsupportedMessage) {
        if (this.reason == null) {
            this.reason = new FixedMessageToolSearchResult(unsupportedMessage);
        }
        return this;
    }

    public ToolChainAvailability mustBeAvailable(ToolSearchResult tool) {
        if (!tool.isAvailable() && this.reason == null) {
            this.reason = tool;
        }
        return this;
    }

    private static class FixedMessageToolSearchResult
    implements ToolSearchResult {
        private final String message;

        private FixedMessageToolSearchResult(String message2) {
            this.message = message2;
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public void explain(DiagnosticsVisitor visitor) {
            visitor.node(this.message);
        }
    }
}

