/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks.internal;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.properties.AbstractPropertyNode;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.api.internal.tasks.properties.TypeMetadataStore;
import org.gradle.api.internal.tasks.properties.TypeScheme;
import org.gradle.api.internal.tasks.properties.annotations.OutputPropertyRoleAnnotationHandler;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Nested;
import org.gradle.cache.internal.DefaultCrossBuildInMemoryCacheFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.event.DefaultListenerManager;
import org.gradle.internal.impldep.com.google.common.base.Equivalence;
import org.gradle.internal.impldep.com.google.common.reflect.TypeToken;
import org.gradle.internal.instantiation.generator.DefaultInstantiatorFactory;
import org.gradle.internal.reflect.PropertyMetadata;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.service.DefaultServiceLocator;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.PluginServiceRegistry;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.state.DefaultManagedFactoryRegistry;

@NonNullApi
public class PropertyValidationAccess {
    private static final PropertyValidationAccess INSTANCE = new PropertyValidationAccess();
    private final List<TypeScheme> typeSchemes;

    private PropertyValidationAccess() {
        ServiceRegistryBuilder builder = ServiceRegistryBuilder.builder().displayName("Global services");
        builder.provider(new Object(){

            void configure(ServiceRegistration registration) {
                registration.add(DefaultListenerManager.class, new DefaultListenerManager(Scope.Global.class));
                registration.add(DefaultCrossBuildInMemoryCacheFactory.class);
                registration.add(DefaultManagedFactoryRegistry.class, new DefaultManagedFactoryRegistry());
                registration.add(OutputPropertyRoleAnnotationHandler.class);
                registration.add(DefaultInstantiatorFactory.class);
                List<PluginServiceRegistry> pluginServiceFactories = new DefaultServiceLocator(false, this.getClass().getClassLoader()).getAll(PluginServiceRegistry.class);
                for (PluginServiceRegistry pluginServiceFactory : pluginServiceFactories) {
                    pluginServiceFactory.registerGlobalServices(registration);
                }
            }
        });
        ServiceRegistry services = builder.build();
        this.typeSchemes = services.getAll(TypeScheme.class);
    }

    public static void collectValidationProblems(Class<?> topLevelBean, TypeValidationContext validationContext) {
        INSTANCE.collectTypeValidationProblems(topLevelBean, validationContext);
    }

    private void collectTypeValidationProblems(Class<?> topLevelBean, TypeValidationContext validationContext) {
        if (topLevelBean.equals(TaskInternal.class)) {
            return;
        }
        TypeMetadataStore metadataStore = null;
        for (TypeScheme typeScheme : this.typeSchemes) {
            if (!typeScheme.appliesTo(topLevelBean)) continue;
            metadataStore = typeScheme.getMetadataStore();
            break;
        }
        if (metadataStore == null) {
            return;
        }
        ArrayDeque queue = new ArrayDeque();
        BeanTypeNodeFactory nodeFactory = new BeanTypeNodeFactory(metadataStore);
        queue.add(nodeFactory.createRootNode(TypeToken.of(topLevelBean)));
        while (!queue.isEmpty()) {
            BeanTypeNode node = (BeanTypeNode)queue.remove();
            node.visit(topLevelBean, validationContext, queue, nodeFactory);
        }
    }

    private static <T> TypeToken<?> extractNestedType(TypeToken<T> beanType, Class<? super T> parameterizedSuperClass, int typeParameterIndex) {
        ParameterizedType type = (ParameterizedType)beanType.getSupertype(parameterizedSuperClass).getType();
        return TypeToken.of((Type)type.getActualTypeArguments()[typeParameterIndex]);
    }

    private static class MapBeanTypeNode
    extends BeanTypeNode<Map<?, ?>> {
        public MapBeanTypeNode(@Nullable BeanTypeNode<?> parentNode, @Nullable String parentPropertyName, TypeToken<Map<?, ?>> mapType, TypeMetadata typeMetadata) {
            super(parentNode, parentPropertyName, mapType, typeMetadata);
        }

        @Override
        public void visit(Class<?> topLevelBean, TypeValidationContext validationContext, Queue<BeanTypeNode<?>> queue, BeanTypeNodeFactory nodeFactory) {
            TypeToken<?> nestedType = this.extractNestedType(Map.class, 1);
            nodeFactory.createAndAddToQueue(this, this.getQualifiedPropertyName("<key>"), nestedType, queue);
        }
    }

    private static class IterableBeanTypeNode
    extends BeanTypeNode<Iterable<?>> {
        public IterableBeanTypeNode(@Nullable BeanTypeNode<?> parentNode, @Nullable String parentPropertyName, TypeToken<Iterable<?>> iterableType, TypeMetadata typeMetadata) {
            super(parentNode, parentPropertyName, iterableType, typeMetadata);
        }

        private String determinePropertyName(TypeToken<?> nestedType) {
            return Named.class.isAssignableFrom(nestedType.getRawType()) ? this.getQualifiedPropertyName("<name>") : this.getPropertyName() + "*";
        }

        @Override
        public void visit(Class<?> topLevelBean, TypeValidationContext validationContext, Queue<BeanTypeNode<?>> queue, BeanTypeNodeFactory nodeFactory) {
            TypeToken<?> nestedType = this.extractNestedType(Iterable.class, 0);
            nodeFactory.createAndAddToQueue(this, this.determinePropertyName(nestedType), nestedType, queue);
        }
    }

    private static class NestedBeanTypeNode
    extends BeanTypeNode<Object> {
        public NestedBeanTypeNode(@Nullable BeanTypeNode<?> parentNode, @Nullable String parentPropertyName, TypeToken<?> beanType, TypeMetadata typeMetadata) {
            super(parentNode, parentPropertyName, beanType, typeMetadata);
        }

        @Override
        public void visit(Class<?> topLevelBean, TypeValidationContext validationContext, Queue<BeanTypeNode<?>> queue, BeanTypeNodeFactory nodeFactory) {
            TypeMetadata typeMetadata = this.getTypeMetadata();
            typeMetadata.visitValidationFailures(this.getPropertyName(), validationContext);
            for (PropertyMetadata propertyMetadata : typeMetadata.getPropertiesMetadata()) {
                String qualifiedPropertyName = this.getQualifiedPropertyName(propertyMetadata.getPropertyName());
                if (!propertyMetadata.getPropertyType().equals(Nested.class)) continue;
                TypeToken<?> beanType = NestedBeanTypeNode.unpackProvider(propertyMetadata.getGetterMethod());
                nodeFactory.createAndAddToQueue(this, qualifiedPropertyName, beanType, queue);
            }
        }

        private static TypeToken<?> unpackProvider(Method method) {
            Class<?> rawType = method.getReturnType();
            TypeToken genericReturnType = TypeToken.of((Type)method.getGenericReturnType());
            if (Provider.class.isAssignableFrom(rawType)) {
                return PropertyValidationAccess.extractNestedType((TypeToken)Cast.uncheckedNonnullCast(genericReturnType), Provider.class, 0);
            }
            return genericReturnType;
        }
    }

    private static abstract class BeanTypeNode<T>
    extends AbstractPropertyNode<TypeToken<?>> {
        private final TypeToken<? extends T> beanType;

        protected BeanTypeNode(@Nullable BeanTypeNode<?> parentNode, @Nullable String propertyName, TypeToken<? extends T> beanType, TypeMetadata typeMetadata) {
            super(parentNode, propertyName, typeMetadata);
            this.beanType = beanType;
        }

        public abstract void visit(Class<?> var1, TypeValidationContext var2, Queue<BeanTypeNode<?>> var3, BeanTypeNodeFactory var4);

        public boolean nodeCreatesCycle(TypeToken<?> childType) {
            return this.findNodeCreatingCycle(childType, Equivalence.equals()) != null;
        }

        protected TypeToken<?> extractNestedType(Class<? super T> parameterizedSuperClass, int typeParameterIndex) {
            return PropertyValidationAccess.extractNestedType(this.beanType, parameterizedSuperClass, typeParameterIndex);
        }

        @Override
        protected TypeToken<?> getNodeValue() {
            return this.beanType;
        }
    }

    private static class BeanTypeNodeFactory {
        private final TypeMetadataStore metadataStore;

        public BeanTypeNodeFactory(TypeMetadataStore metadataStore) {
            this.metadataStore = metadataStore;
        }

        public BeanTypeNode<?> createRootNode(TypeToken<?> beanType) {
            return new NestedBeanTypeNode(null, null, beanType, this.metadataStore.getTypeMetadata(beanType.getRawType()));
        }

        public void createAndAddToQueue(BeanTypeNode<?> parentNode, String propertyName, TypeToken<?> beanType, Queue<BeanTypeNode<?>> queue) {
            if (!parentNode.nodeCreatesCycle(beanType)) {
                queue.add(this.createChild(parentNode, propertyName, beanType));
            }
        }

        private BeanTypeNode<?> createChild(BeanTypeNode<?> parentNode, String propertyName, TypeToken<?> beanType) {
            Class rawType = beanType.getRawType();
            TypeMetadata typeMetadata = this.metadataStore.getTypeMetadata(rawType);
            if (!typeMetadata.hasAnnotatedProperties()) {
                if (Map.class.isAssignableFrom(rawType)) {
                    return new MapBeanTypeNode(parentNode, propertyName, (TypeToken<Map<?, ?>>)((TypeToken)Cast.uncheckedNonnullCast(beanType)), typeMetadata);
                }
                if (Iterable.class.isAssignableFrom(rawType)) {
                    return new IterableBeanTypeNode(parentNode, propertyName, (TypeToken<Iterable<?>>)((TypeToken)Cast.uncheckedNonnullCast(beanType)), typeMetadata);
                }
            }
            return new NestedBeanTypeNode(parentNode, propertyName, beanType, typeMetadata);
        }
    }
}

