/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.protocol;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.jetbrains.qodana.sarif.model.SarifReport;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.protocol.DownloadedReportDescriptorBuilder$FailMessagesProvider$WhenMappings;
import org.jetbrains.qodana.report.FileReportDescriptor;
import org.jetbrains.qodana.report.ReportDescriptor;
import org.jetbrains.qodana.report.ReportDescriptorBuilder;
import org.jetbrains.qodana.report.ReportReader;
import org.jetbrains.qodana.report.ReportValidator;
import org.jetbrains.qodana.report.SarifKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\n\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/qodana/protocol/DownloadedReportDescriptorBuilder;", "Lorg/jetbrains/qodana/report/ReportDescriptorBuilder;", "reportUrl", "", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "createReportDescriptor", "Lorg/jetbrains/qodana/report/ReportDescriptor;", "downloadReport", "Lcom/intellij/openapi/vfs/VirtualFile;", "downloadReportOrNotify", "FailMessagesProvider", "intellij.qodana"})
public final class DownloadedReportDescriptorBuilder
implements ReportDescriptorBuilder {
    private final String reportUrl;
    private final Project project;

    @Override
    @Nullable
    public ReportDescriptor createReportDescriptor() {
        Object object = this.downloadReportOrNotify();
        if (object == null || (object = object.toNioPath()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"downloadReportOrNotify()\u2026oNioPath() ?: return null");
        Object reportPath = object;
        SarifReport sarifReport = new ReportReader((Path)reportPath, this.project, new FailMessagesProvider((Path)reportPath, this.reportUrl)).getReport();
        if (sarifReport == null) {
            return null;
        }
        SarifReport report = sarifReport;
        String guid = SarifKt.getGuid(report);
        String string = SarifKt.getId(report);
        if (string == null) {
            string = guid;
        }
        String name = string;
        return new FileReportDescriptor((Path)reportPath, guid, name, this.project);
    }

    private final VirtualFile downloadReportOrNotify() {
        VirtualFile reportFile = this.downloadReport();
        if (reportFile == null) {
            String string = QodanaBundle.message("notification.title.cant.download.report", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"QodanaBundle.message(\"no\u2026le.cant.download.report\")");
            String title = string;
            String string2 = QodanaBundle.message("notification.content.cant.download.report", this.reportUrl);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"QodanaBundle.message(\"no\u2026nload.report\", reportUrl)");
            String message = string2;
            new Notification("Qodana", title, message, NotificationType.WARNING).notify(this.project);
        }
        return reportFile;
    }

    private final VirtualFile downloadReport() {
        DownloadableFileService service = DownloadableFileService.getInstance();
        File file = FileUtil.createTempFile((String)"qodana-report.", (String)".json");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"FileUtil.createTempFile(\"qodana-report.\", \".json\")");
        File reportFile = file;
        FileDownloader fileDownloader = service.createDownloader(CollectionsKt.listOf((Object)service.createFileDescription(this.reportUrl, reportFile.getName())), this.reportUrl);
        Intrinsics.checkNotNullExpressionValue((Object)fileDownloader, (String)"service.createDownloader\u2026rtFile.name)), reportUrl)");
        FileDownloader downloader = fileDownloader;
        CompletableFuture completableFuture = downloader.downloadWithBackgroundProgress(reportFile.getParent(), this.project);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"downloader.downloadWithB\u2026portFile.parent, project)");
        CompletableFuture future = completableFuture;
        try {
            List list = (List)future.get(10L, TimeUnit.MINUTES);
            return list != null && (list = (Pair)CollectionsKt.firstOrNull((List)list)) != null ? (VirtualFile)((Pair)list).first : null;
        }
        catch (ExecutionException e) {
            DownloadedReportDescriptorBuilder $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(DownloadedReportDescriptorBuilder.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn("Can't download report from: " + this.reportUrl, (Throwable)e);
        }
        catch (TimeoutException e) {
            DownloadedReportDescriptorBuilder $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(DownloadedReportDescriptorBuilder.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn("Timeout for downloading report from: " + this.reportUrl, (Throwable)e);
        }
        return null;
    }

    public DownloadedReportDescriptorBuilder(@NotNull String reportUrl, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)reportUrl, (String)"reportUrl");
        this.reportUrl = reportUrl;
        this.project = project;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/qodana/protocol/DownloadedReportDescriptorBuilder$FailMessagesProvider;", "Lorg/jetbrains/qodana/report/ReportReader$FailMessagesProvider;", "downloadedFilePath", "Ljava/nio/file/Path;", "reportUrl", "", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "getDownloadedFilePath", "()Ljava/nio/file/Path;", "getReportUrl", "()Ljava/lang/String;", "getFailedParseMessage", "getFailedValidationMessage", "validationError", "Lorg/jetbrains/qodana/report/ReportValidator$ValidationError;", "getFileNotExistsMessage", "intellij.qodana"})
    private static final class FailMessagesProvider
    implements ReportReader.FailMessagesProvider {
        @NotNull
        private final Path downloadedFilePath;
        @NotNull
        private final String reportUrl;

        @Override
        @NotNull
        public String getFileNotExistsMessage() {
            String string = QodanaBundle.message("notification.content.report.file.does.not.exist", this.downloadedFilePath.toAbsolutePath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"QodanaBundle.message(\"no\u2026ilePath.toAbsolutePath())");
            return string;
        }

        @Override
        @NotNull
        public String getFailedParseMessage() {
            String string = QodanaBundle.message("notification.content.cant.parse.report.from.url", this.reportUrl);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"QodanaBundle.message(\"no\u2026ort.from.url\", reportUrl)");
            return string;
        }

        @Override
        @NotNull
        public String getFailedValidationMessage(@NotNull ReportValidator.ValidationError validationError) {
            String string;
            Intrinsics.checkNotNullParameter((Object)((Object)validationError), (String)"validationError");
            switch (DownloadedReportDescriptorBuilder$FailMessagesProvider$WhenMappings.$EnumSwitchMapping$0[validationError.ordinal()]) {
                case 1: {
                    String string2 = QodanaBundle.message("notification.content.failed.validation.report.from.url.no.runs", this.reportUrl);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"QodanaBundle.message(\"no\u2026.url.no.runs\", reportUrl)");
                    break;
                }
                case 2: {
                    String string3 = QodanaBundle.message("notification.content.failed.validation.report.from.url.empty.runs", this.reportUrl);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"QodanaBundle.message(\"no\u2026l.empty.runs\", reportUrl)");
                    break;
                }
                case 3: {
                    String string4 = QodanaBundle.message("notification.content.failed.validation.report.from.url.no.results", this.reportUrl);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"QodanaBundle.message(\"no\u2026l.no.results\", reportUrl)");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        @NotNull
        public final Path getDownloadedFilePath() {
            return this.downloadedFilePath;
        }

        @NotNull
        public final String getReportUrl() {
            return this.reportUrl;
        }

        public FailMessagesProvider(@NotNull Path downloadedFilePath, @NotNull String reportUrl) {
            Intrinsics.checkNotNullParameter((Object)downloadedFilePath, (String)"downloadedFilePath");
            Intrinsics.checkNotNullParameter((Object)reportUrl, (String)"reportUrl");
            this.downloadedFilePath = downloadedFilePath;
            this.reportUrl = reportUrl;
        }
    }
}

