/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.protocol;

import com.intellij.navigation.NavigatorWithinProject;
import com.intellij.openapi.project.Project;
import com.jetbrains.qodana.sarif.model.ArtifactLocation;
import com.jetbrains.qodana.sarif.model.Location;
import com.jetbrains.qodana.sarif.model.Message;
import com.jetbrains.qodana.sarif.model.PhysicalLocation;
import com.jetbrains.qodana.sarif.model.Region;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.RunAutomationDetails;
import com.jetbrains.qodana.sarif.model.SarifReport;
import com.jetbrains.qodana.sarif.model.Tool;
import com.jetbrains.qodana.sarif.model.ToolComponent;
import com.jetbrains.qodana.sarif.model.VersionControlDetails;
import java.net.URI;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.report.ReportDescriptor;
import org.jetbrains.qodana.report.ReportDescriptorBuilder;
import org.jetbrains.qodana.report.ReportValidator;
import org.jetbrains.qodana.report.SarifKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/qodana/protocol/SingleMarkerReportDescriptorBuilder;", "Lorg/jetbrains/qodana/report/ReportDescriptorBuilder;", "message", "", "pathText", "markerLength", "origin", "revisionId", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "constructSingleMarkerReport", "Lcom/jetbrains/qodana/sarif/model/SarifReport;", "createReportDescriptor", "Lorg/jetbrains/qodana/report/ReportDescriptor;", "intellij.qodana"})
public final class SingleMarkerReportDescriptorBuilder
implements ReportDescriptorBuilder {
    private final String message;
    private final String pathText;
    private final String markerLength;
    private final String origin;
    private final String revisionId;
    private final Project project;

    @Override
    @NotNull
    public ReportDescriptor createReportDescriptor() {
        SarifReport report = this.constructSingleMarkerReport();
        SarifReport sarifReport = new ReportValidator(this.project, null).processReport(report);
        if (sarifReport == null) {
            throw (Throwable)new IllegalArgumentException("The problem " + this.pathText + " formed invalid report");
        }
        SarifReport validatedReport = sarifReport;
        String guid = SarifKt.getGuid(validatedReport);
        return new ReportDescriptor(validatedReport, guid, report){
            @NotNull
            private final String reportGuid;
            @NotNull
            private final String reportName;
            private final boolean isReportAvailable;
            final /* synthetic */ SarifReport $validatedReport;
            final /* synthetic */ String $guid;
            final /* synthetic */ SarifReport $report;

            @NotNull
            public String getReportGuid() {
                return this.reportGuid;
            }

            @NotNull
            public String getReportName() {
                return this.reportName;
            }

            public boolean isReportAvailable() {
                return this.isReportAvailable;
            }

            @NotNull
            public SarifReport getSarifReport() {
                return this.$validatedReport;
            }
            {
                this.$validatedReport = $captured_local_variable$0;
                this.$guid = $captured_local_variable$1;
                this.$report = $captured_local_variable$2;
                this.reportGuid = $captured_local_variable$1;
                String string = SarifKt.getId($captured_local_variable$2);
                if (string == null) {
                    string = $captured_local_variable$1;
                }
                this.reportName = string;
                this.isReportAvailable = true;
            }

            @Nullable
            public SarifReport getReport() {
                return ReportDescriptor.DefaultImpls.getReport(this);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final SarifReport constructSingleMarkerReport() {
        void line;
        void path;
        Triple triple = NavigatorWithinProject.Companion.parseNavigationPath(this.pathText);
        String string = (String)triple.component1();
        String string2 = (String)triple.component2();
        String column = (String)triple.component3();
        if (path == null || line == null || column == null) {
            throw (Throwable)new IllegalArgumentException("The URL should have a 'path' parameter in the '$path:$line:$column' format");
        }
        RunAutomationDetails automationDetails = new RunAutomationDetails().withGuid(UUID.randomUUID().toString()).withId(this.pathText + " - " + this.message);
        VersionControlDetails vcsDetails = this.revisionId != null ? new VersionControlDetails(URI.create(this.origin)).withRevisionId(this.revisionId) : null;
        String string3 = column;
        Region region = new Region().withStartColumn(Integer.parseInt(string3));
        string3 = line;
        Region region2 = region.withStartLine(Integer.parseInt(string3));
        string3 = this.markerLength;
        Result result = new Result(new Message().withText(this.message)).withLocations(CollectionsKt.listOf((Object)new Location().withPhysicalLocation(new PhysicalLocation().withArtifactLocation(new ArtifactLocation().withUri((String)path).withUriBaseId("SRCROOT")).withRegion(region2.withCharLength(Integer.parseInt(string3))))));
        Run run = new Run(new Tool(new ToolComponent("single-marker-tool"))).withAutomationDetails(automationDetails).withVersionControlProvenance(SetsKt.setOf((Object)vcsDetails)).withResults(CollectionsKt.listOf((Object)result));
        return new SarifReport(SarifReport.Version._2_1_0, CollectionsKt.listOf((Object)run));
    }

    public SingleMarkerReportDescriptorBuilder(@NotNull String message, @NotNull String pathText, @NotNull String markerLength, @NotNull String origin, @Nullable String revisionId, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)pathText, (String)"pathText");
        Intrinsics.checkNotNullParameter((Object)markerLength, (String)"markerLength");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        this.message = message;
        this.pathText = pathText;
        this.markerLength = markerLength;
        this.origin = origin;
        this.revisionId = revisionId;
        this.project = project;
    }
}

