/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.report;

import com.intellij.openapi.project.Project;
import com.jetbrains.qodana.sarif.model.SarifReport;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.report.FileReportDescriptor;
import org.jetbrains.qodana.report.FromFileReportDescriptorBuilder$FailMessagesProvider$WhenMappings;
import org.jetbrains.qodana.report.ReportDescriptor;
import org.jetbrains.qodana.report.ReportDescriptorBuilder;
import org.jetbrains.qodana.report.ReportReader;
import org.jetbrains.qodana.report.ReportValidator;
import org.jetbrains.qodana.report.SarifKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/qodana/report/FromFileReportDescriptorBuilder;", "Lorg/jetbrains/qodana/report/ReportDescriptorBuilder;", "path", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/nio/file/Path;Lcom/intellij/openapi/project/Project;)V", "reportPath", "createReportDescriptor", "Lorg/jetbrains/qodana/report/ReportDescriptor;", "FailMessagesProvider", "intellij.qodana"})
public final class FromFileReportDescriptorBuilder
implements ReportDescriptorBuilder {
    private final Path reportPath;
    private final Project project;

    @Override
    @Nullable
    public ReportDescriptor createReportDescriptor() {
        SarifReport sarifReport = new ReportReader(this.reportPath, this.project, new FailMessagesProvider()).getReport();
        if (sarifReport == null) {
            return null;
        }
        SarifReport report = sarifReport;
        String guid = SarifKt.getGuid(report);
        String string = SarifKt.getId(report);
        if (string == null) {
            string = guid;
        }
        String name = string;
        return new FileReportDescriptor(this.reportPath, guid, name, this.project);
    }

    public FromFileReportDescriptorBuilder(@NotNull Path path, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.project = project;
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.toAbsolutePath()");
        this.reportPath = path2;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/qodana/report/FromFileReportDescriptorBuilder$FailMessagesProvider;", "Lorg/jetbrains/qodana/report/ReportReader$FailMessagesProvider;", "(Lorg/jetbrains/qodana/report/FromFileReportDescriptorBuilder;)V", "getFailedParseMessage", "", "getFailedValidationMessage", "validationError", "Lorg/jetbrains/qodana/report/ReportValidator$ValidationError;", "getFileNotExistsMessage", "intellij.qodana"})
    private final class FailMessagesProvider
    implements ReportReader.FailMessagesProvider {
        @Override
        @NotNull
        public String getFileNotExistsMessage() {
            String string = QodanaBundle.message("notification.content.report.file.does.not.exist", FromFileReportDescriptorBuilder.this.reportPath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"QodanaBundle.message(\"no\u2026s.not.exist\", reportPath)");
            return string;
        }

        @Override
        @NotNull
        public String getFailedParseMessage() {
            String string = QodanaBundle.message("notification.content.cant.parse.report.from.file", FromFileReportDescriptorBuilder.this.reportPath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"QodanaBundle.message(\"no\u2026t.from.file\", reportPath)");
            return string;
        }

        @Override
        @NotNull
        public String getFailedValidationMessage(@NotNull ReportValidator.ValidationError validationError) {
            String string;
            Intrinsics.checkNotNullParameter((Object)((Object)validationError), (String)"validationError");
            switch (FromFileReportDescriptorBuilder$FailMessagesProvider$WhenMappings.$EnumSwitchMapping$0[validationError.ordinal()]) {
                case 1: {
                    String string2 = QodanaBundle.message("notification.content.failed.validation.report.from.file.no.runs", FromFileReportDescriptorBuilder.this.reportPath);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"QodanaBundle.message(\"no\u2026ile.no.runs\", reportPath)");
                    break;
                }
                case 2: {
                    String string3 = QodanaBundle.message("notification.content.failed.validation.report.from.file.empty.runs", FromFileReportDescriptorBuilder.this.reportPath);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"QodanaBundle.message(\"no\u2026.empty.runs\", reportPath)");
                    break;
                }
                case 3: {
                    String string4 = QodanaBundle.message("notification.content.failed.validation.report.from.file.no.results", FromFileReportDescriptorBuilder.this.reportPath);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"QodanaBundle.message(\"no\u2026.no.results\", reportPath)");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }
    }
}

