/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.mockJDI.members;

import com.intellij.debugger.mockJDI.MockLocalVariable;
import com.intellij.debugger.mockJDI.MockMirror;
import com.intellij.debugger.mockJDI.MockVirtualMachine;
import com.intellij.debugger.mockJDI.types.MockType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class MockPsiLambda
extends MockMirror
implements Method {
    private final PsiLambdaExpression myPsiLambdaExpression;
    private final PsiMethod myDeclaringMethod;

    public MockPsiLambda(MockVirtualMachine vm, PsiLambdaExpression psiLambdaExpression) {
        super(vm);
        this.myPsiLambdaExpression = psiLambdaExpression;
        this.myDeclaringMethod = Objects.requireNonNull((PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiLambdaExpression, PsiMethod.class));
    }

    @Override
    public String returnTypeName() {
        return LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)this.myPsiLambdaExpression).getCanonicalText();
    }

    @Override
    public Type returnType() {
        return MockType.createType(this.myVirtualMachine, LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)this.myPsiLambdaExpression));
    }

    @Override
    public List<String> argumentTypeNames() {
        return StreamEx.of((Object[])this.myPsiLambdaExpression.getParameterList().getParameters()).map(PsiParameter::getType).map(PsiType::getCanonicalText).toList();
    }

    @Override
    public List<Type> argumentTypes() {
        return StreamEx.of((Object[])this.myPsiLambdaExpression.getParameterList().getParameters()).map(PsiParameter::getType).map(t -> MockType.createType(this.myVirtualMachine, t)).toList();
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    @Override
    public boolean isBridge() {
        return false;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public boolean isStaticInitializer() {
        return false;
    }

    @Override
    public boolean isObsolete() {
        return false;
    }

    @Override
    public List<Location> allLineLocations() throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public List<Location> allLineLocations(String s, String s1) throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public List<Location> locationsOfLine(int i) throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public List<Location> locationsOfLine(String s, String s1, int i) throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public Location locationOfCodeIndex(long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<LocalVariable> variables() throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public List<LocalVariable> variablesByName(String s) throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public List<LocalVariable> arguments() {
        return StreamEx.of((Object[])this.myPsiLambdaExpression.getParameterList().getParameters()).map(p -> new MockLocalVariable(this.myVirtualMachine, (PsiVariable)p)).toList();
    }

    @Override
    public byte[] bytecodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Location location() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String name() {
        return "lambda$" + this.myDeclaringMethod.getName() + "$mock";
    }

    @Override
    public String signature() {
        return null;
    }

    @Override
    public String genericSignature() {
        return null;
    }

    @Override
    public ReferenceType declaringType() {
        return this.myVirtualMachine.createReferenceType(this.myDeclaringMethod.getContainingClass());
    }

    @Override
    public boolean isStatic() {
        return this.myDeclaringMethod.hasModifierProperty("static");
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean isSynthetic() {
        return true;
    }

    @Override
    public int modifiers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPrivate() {
        return true;
    }

    @Override
    public boolean isPackagePrivate() {
        return false;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public MockVirtualMachine virtualMachine() {
        return this.myVirtualMachine;
    }

    @Override
    public int compareTo(@NotNull Method o) {
        if (o == null) {
            MockPsiLambda.$$$reportNull$$$0(0);
        }
        return this.name().compareTo(o.name());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/debugger/mockJDI/members/MockPsiLambda", "compareTo"));
    }
}

