/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.mockJDI.types;

import com.intellij.debugger.mockJDI.MockVirtualMachine;
import com.intellij.debugger.mockJDI.members.MockPsiMethod;
import com.intellij.debugger.mockJDI.types.MockType;
import com.intellij.debugger.mockJDI.values.MockClassLoaderReference;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class MockPsiReferenceType
extends MockType
implements ReferenceType {
    final PsiClass myClass;

    public MockPsiReferenceType(MockVirtualMachine virtualMachine, PsiClass psiClass) {
        super(virtualMachine);
        this.myClass = psiClass;
    }

    @Override
    public String name() {
        return ClassUtil.getJVMClassName((PsiClass)this.myClass);
    }

    @Override
    public String signature() {
        return "L" + this.name().replace('.', '/') + ";";
    }

    @Override
    public String genericSignature() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassLoaderReference classLoader() {
        return new MockClassLoaderReference(this.myVirtualMachine, Object.class.getClassLoader());
    }

    @Override
    public String sourceName() {
        return this.myClass.getContainingFile().getName();
    }

    @Override
    public List<String> sourceNames(String s) {
        return Collections.singletonList(this.sourceName());
    }

    @Override
    public List<String> sourcePaths(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String sourceDebugExtension() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isStatic() {
        return this.myClass.hasModifierProperty("static");
    }

    @Override
    public boolean isAbstract() {
        return this.myClass.hasModifierProperty("abstract");
    }

    @Override
    public boolean isFinal() {
        return this.myClass.hasModifierProperty("final");
    }

    @Override
    public boolean isPrepared() {
        return true;
    }

    @Override
    public boolean isVerified() {
        return true;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public boolean failedToInitialize() {
        return false;
    }

    @Override
    public List<Field> fields() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Field> visibleFields() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Field> allFields() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Field fieldByName(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Method> methods() {
        return StreamEx.of((Object[])this.myClass.getMethods()).map(m -> new MockPsiMethod(this.myVirtualMachine, (PsiMethod)m)).toList();
    }

    @Override
    public List<Method> visibleMethods() {
        return ((StreamEx)StreamEx.of((Object[])this.myClass.getMethods()).filter(m -> m.hasModifierProperty("public"))).map(m -> new MockPsiMethod(this.myVirtualMachine, (PsiMethod)m)).toList();
    }

    @Override
    public List<Method> allMethods() {
        return StreamEx.of((Object[])this.myClass.getAllMethods()).map(m -> new MockPsiMethod(this.myVirtualMachine, (PsiMethod)m)).toList();
    }

    @Override
    public List<Method> methodsByName(String name) {
        return StreamEx.of((Object[])this.myClass.findMethodsByName(name, true)).map(m -> new MockPsiMethod(this.myVirtualMachine, (PsiMethod)m)).toList();
    }

    @Override
    public List<Method> methodsByName(String name, String sig) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ReferenceType> nestedTypes() {
        return Collections.emptyList();
    }

    @Override
    public Value getValue(Field field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Field, Value> getValues(List<? extends Field> list) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassObjectReference classObject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Location> allLineLocations() throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public List<Location> allLineLocations(String s, String s1) throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public List<Location> locationsOfLine(int i) throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public List<Location> locationsOfLine(String s, String s1, int i) throws AbsentInformationException {
        throw new AbsentInformationException();
    }

    @Override
    public List<String> availableStrata() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String defaultStratum() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ObjectReference> instances(long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int majorVersion() {
        return PsiUtil.getLanguageLevel((PsiElement)this.myClass).toJavaVersion().feature + 44;
    }

    @Override
    public int minorVersion() {
        return 0;
    }

    @Override
    public int constantPoolCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] constantPool() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int modifiers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPrivate() {
        return this.myClass.hasModifierProperty("private");
    }

    @Override
    public boolean isPackagePrivate() {
        return this.myClass.hasModifierProperty("packageLocal");
    }

    @Override
    public boolean isProtected() {
        return this.myClass.hasModifierProperty("protected");
    }

    @Override
    public boolean isPublic() {
        return this.myClass.hasModifierProperty("public");
    }

    @Override
    public int compareTo(@NotNull ReferenceType o) {
        if (o == null) {
            MockPsiReferenceType.$$$reportNull$$$0(0);
        }
        return this.name().compareTo(o.name());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/debugger/mockJDI/types/MockPsiReferenceType", "compareTo"));
    }
}

