/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri.json;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.colibri.WebSocketPacketExtension;
import org.jitsi.xmpp.extensions.jingle.CandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceCandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceRtcpmuxPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ParameterPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RemoteCandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtcpFbPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class JSONDeserializer {
    public static void deserializeAbstractPacketExtensionAttributes(JSONObject jsonObject, AbstractPacketExtension abstractPacketExtension) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            Object value2;
            String name;
            Object key = entry.getKey();
            if (key == null || (name = key.toString()) == null || (value2 = entry.getValue()) instanceof JSONObject || value2 instanceof JSONArray) continue;
            abstractPacketExtension.setAttribute(name, value2);
        }
    }

    public static <T extends CandidatePacketExtension> T deserializeCandidate(JSONObject candidate, Class<T> candidateIQClass, IceUdpTransportPacketExtension transportIQ) {
        CandidatePacketExtension candidateIQ;
        if (candidate == null) {
            candidateIQ = null;
        } else {
            try {
                candidateIQ = (CandidatePacketExtension)candidateIQClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException iae) {
                throw new UndeclaredThrowableException(iae);
            }
            JSONDeserializer.deserializeAbstractPacketExtensionAttributes(candidate, candidateIQ);
            transportIQ.addChildExtension(candidateIQ);
        }
        return (T)candidateIQ;
    }

    public static void deserializeCandidates(JSONArray candidates, IceUdpTransportPacketExtension transportIQ) {
        if (candidates != null && !candidates.isEmpty()) {
            for (Object candidate : candidates) {
                JSONDeserializer.deserializeCandidate((JSONObject)candidate, IceCandidatePacketExtension.class, transportIQ);
            }
        }
    }

    public static void deserializeWebsocket(String webSocketUrl, IceUdpTransportPacketExtension transportIQ) {
        if (webSocketUrl == null) {
            Object webSocketIQ = null;
        } else {
            WebSocketPacketExtension webSocketIQ = new WebSocketPacketExtension();
            if (webSocketUrl.equals("active")) {
                webSocketIQ.setActive(true);
            } else {
                webSocketIQ.setUrl(webSocketUrl);
            }
            transportIQ.addChildExtension(webSocketIQ);
        }
    }

    public static void deserializeWebsockets(JSONArray webSockets, IceUdpTransportPacketExtension transportIQ) {
        if (webSockets != null && !webSockets.isEmpty()) {
            for (Object webSocket : webSockets) {
                JSONDeserializer.deserializeWebsocket((String)webSocket, transportIQ);
            }
        }
    }

    public static ColibriConferenceIQ.Channel deserializeChannel(JSONObject channel, ColibriConferenceIQ.Content contentIQ) {
        ColibriConferenceIQ.Channel channelIQ;
        if (channel == null) {
            channelIQ = null;
        } else {
            Object direction = channel.get("direction");
            Object lastN = channel.get("last-n");
            Object receivingSimulcastStream = channel.get("receive-simulcast-layer");
            Object payloadTypes = channel.get("payload-types");
            Object rtpLevelRelayType = channel.get("rtp-level-relay-type");
            Object sources = channel.get("sources");
            Object sourceGroups = channel.get("ssrc-groups");
            Object ssrcs = channel.get("ssrcs");
            Object headerExtensions = channel.get("rtp-hdrexts");
            channelIQ = new ColibriConferenceIQ.Channel();
            JSONDeserializer.deserializeChannelCommon(channel, channelIQ);
            if (direction != null) {
                channelIQ.setDirection(direction.toString());
            }
            if (lastN != null) {
                channelIQ.setLastN(JSONDeserializer.objectToInteger(lastN));
            }
            if (receivingSimulcastStream != null) {
                channelIQ.setReceivingSimulcastLayer(JSONDeserializer.objectToInteger(receivingSimulcastStream));
            }
            if (payloadTypes != null) {
                JSONDeserializer.deserializePayloadTypes((JSONArray)payloadTypes, channelIQ);
            }
            if (rtpLevelRelayType != null) {
                channelIQ.setRTPLevelRelayType(rtpLevelRelayType.toString());
            }
            if (sources != null) {
                JSONDeserializer.deserializeSources((JSONArray)sources, channelIQ);
            }
            if (sourceGroups != null) {
                JSONDeserializer.deserializeSourceGroups((JSONArray)sourceGroups, channelIQ);
            }
            if (ssrcs != null) {
                JSONDeserializer.deserializeSSRCs((JSONArray)ssrcs, channelIQ);
            }
            if (headerExtensions != null) {
                JSONDeserializer.deserializeHeaderExtensions((JSONArray)headerExtensions, channelIQ);
            }
            contentIQ.addChannel(channelIQ);
        }
        return channelIQ;
    }

    private static Integer objectToInteger(Object o) {
        Integer i = o instanceof Integer ? (Integer)o : (o instanceof Number ? Integer.valueOf(((Number)o).intValue()) : Integer.valueOf(o.toString()));
        return i;
    }

    private static Boolean objectToBoolean(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return Boolean.valueOf(o.toString());
    }

    public static ColibriConferenceIQ.ChannelBundle deserializeChannelBundle(JSONObject channelBundle, ColibriConferenceIQ conferenceIQ) {
        ColibriConferenceIQ.ChannelBundle channelBundleIQ;
        if (channelBundle == null) {
            channelBundleIQ = null;
        } else {
            Object id = channelBundle.get("id");
            Object transport = channelBundle.get("transport");
            channelBundleIQ = new ColibriConferenceIQ.ChannelBundle(id == null ? null : id.toString());
            if (transport != null) {
                JSONDeserializer.deserializeTransport((JSONObject)transport, channelBundleIQ);
            }
            conferenceIQ.addChannelBundle(channelBundleIQ);
        }
        return channelBundleIQ;
    }

    public static ColibriConferenceIQ.Endpoint deserializeEndpoint(JSONObject endpoint, ColibriConferenceIQ conferenceIQ) {
        ColibriConferenceIQ.Endpoint endpointIQ;
        if (endpoint == null) {
            endpointIQ = null;
        } else {
            Object id = endpoint.get("id");
            Object statsId = endpoint.get("stats-id");
            endpointIQ = new ColibriConferenceIQ.Endpoint(Objects.toString(id, null), Objects.toString(statsId, null), null);
            conferenceIQ.addEndpoint(endpointIQ);
        }
        return endpointIQ;
    }

    public static void deserializeChannelBundles(JSONArray channelBundles, ColibriConferenceIQ conferenceIQ) {
        if (channelBundles != null && !channelBundles.isEmpty()) {
            for (Object channelBundle : channelBundles) {
                JSONDeserializer.deserializeChannelBundle((JSONObject)channelBundle, conferenceIQ);
            }
        }
    }

    public static void deserializeEndpoints(JSONArray endpoints, ColibriConferenceIQ conferenceIQ) {
        if (endpoints != null && !endpoints.isEmpty()) {
            for (Object endpoint : endpoints) {
                JSONDeserializer.deserializeEndpoint((JSONObject)endpoint, conferenceIQ);
            }
        }
    }

    public static void deserializeChannelCommon(JSONObject channel, ColibriConferenceIQ.ChannelCommon channelIQ) {
        int i;
        Object id = channel.get("id");
        Object channelBundleId = channel.get("channel-bundle-id");
        Object endpoint = channel.get("endpoint");
        Object expire2 = channel.get("expire");
        Object initiator = channel.get("initiator");
        Object transport = channel.get("transport");
        if (id != null) {
            channelIQ.setID(id.toString());
        }
        if (channelBundleId != null) {
            channelIQ.setChannelBundleId(channelBundleId.toString());
        }
        if (endpoint != null) {
            channelIQ.setEndpoint(endpoint.toString());
        }
        if (expire2 != null && (i = JSONDeserializer.objectToInteger(expire2).intValue()) != -1) {
            channelIQ.setExpire(i);
        }
        if (initiator != null) {
            channelIQ.setInitiator(JSONDeserializer.objectToBoolean(initiator));
        }
        if (transport != null) {
            JSONDeserializer.deserializeTransport((JSONObject)transport, channelIQ);
        }
    }

    public static void deserializeChannels(JSONArray channels, ColibriConferenceIQ.Content contentIQ) {
        if (channels != null && !channels.isEmpty()) {
            for (Object channel : channels) {
                JSONDeserializer.deserializeChannel((JSONObject)channel, contentIQ);
            }
        }
    }

    public static ColibriConferenceIQ deserializeConference(JSONObject conference) {
        ColibriConferenceIQ conferenceIQ;
        if (conference == null) {
            conferenceIQ = null;
        } else {
            Object id = conference.get("id");
            Object contents = conference.get("contents");
            Object channelBundles = conference.get("channel-bundles");
            Object endpoints = conference.get("endpoints");
            Object strategy = conference.get("rtcp-termination-strategy");
            Object shutdownExt = conference.get("graceful-shutdown");
            conferenceIQ = new ColibriConferenceIQ();
            if (id != null) {
                conferenceIQ.setID(id.toString());
            }
            if (contents != null) {
                JSONDeserializer.deserializeContents((JSONArray)contents, conferenceIQ);
            }
            if (channelBundles != null) {
                JSONDeserializer.deserializeChannelBundles((JSONArray)channelBundles, conferenceIQ);
            }
            if (endpoints != null) {
                JSONDeserializer.deserializeEndpoints((JSONArray)endpoints, conferenceIQ);
            }
            if (strategy != null) {
                JSONDeserializer.deserializeRTCPTerminationStrategy((JSONObject)strategy, conferenceIQ);
            }
            if (shutdownExt != null) {
                conferenceIQ.setGracefulShutdown(true);
            }
        }
        return conferenceIQ;
    }

    private static void deserializeRTCPTerminationStrategy(JSONObject strategy, ColibriConferenceIQ conferenceIQ) {
        if (strategy != null & conferenceIQ != null) {
            Object attrName = strategy.get("name");
            String name = Objects.toString(attrName, null);
            if (StringUtils.isBlank(name)) {
                return;
            }
            ColibriConferenceIQ.RTCPTerminationStrategy strategyIQ = new ColibriConferenceIQ.RTCPTerminationStrategy();
            strategyIQ.setName(name);
            conferenceIQ.setRTCPTerminationStrategy(strategyIQ);
        }
    }

    public static ColibriConferenceIQ.Content deserializeContent(JSONObject content, ColibriConferenceIQ conferenceIQ) {
        ColibriConferenceIQ.Content contentIQ;
        if (content == null) {
            contentIQ = null;
        } else {
            Object name = content.get("name");
            Object channels = content.get("channels");
            Object sctpConnections = content.get("sctpconnections");
            contentIQ = conferenceIQ.getOrCreateContent(Objects.toString(name, null));
            if (channels != null) {
                JSONDeserializer.deserializeChannels((JSONArray)channels, contentIQ);
            }
            if (sctpConnections != null) {
                JSONDeserializer.deserializeSctpConnections((JSONArray)sctpConnections, contentIQ);
            }
            conferenceIQ.addContent(contentIQ);
        }
        return contentIQ;
    }

    public static void deserializeContents(JSONArray contents, ColibriConferenceIQ conferenceIQ) {
        if (contents != null && !contents.isEmpty()) {
            for (Object content : contents) {
                JSONDeserializer.deserializeContent((JSONObject)content, conferenceIQ);
            }
        }
    }

    public static DtlsFingerprintPacketExtension deserializeFingerprint(JSONObject fingerprint, IceUdpTransportPacketExtension transportIQ) {
        DtlsFingerprintPacketExtension fingerprintIQ;
        if (fingerprint == null) {
            fingerprintIQ = null;
        } else {
            Object theFingerprint = fingerprint.get("fingerprint");
            fingerprintIQ = new DtlsFingerprintPacketExtension();
            if (theFingerprint != null) {
                fingerprintIQ.setFingerprint(theFingerprint.toString());
            }
            JSONDeserializer.deserializeAbstractPacketExtensionAttributes(fingerprint, fingerprintIQ);
            fingerprintIQ.removeAttribute("fingerprint");
            transportIQ.addChildExtension(fingerprintIQ);
        }
        return fingerprintIQ;
    }

    public static void deserializeFingerprints(JSONArray fingerprints, IceUdpTransportPacketExtension transportIQ) {
        if (fingerprints != null && !fingerprints.isEmpty()) {
            for (Object fingerprint : fingerprints) {
                JSONDeserializer.deserializeFingerprint((JSONObject)fingerprint, transportIQ);
            }
        }
    }

    public static void deserializeParameters(JSONObject parameters2, PayloadTypePacketExtension payloadTypeIQ) {
        if (parameters2 != null) {
            for (Map.Entry entry : parameters2.entrySet()) {
                Object name = entry.getKey();
                Object value2 = entry.getValue();
                if (name instanceof String && name.equals("null")) {
                    name = null;
                }
                if (name == null && value2 == null) continue;
                payloadTypeIQ.addParameter(new ParameterPacketExtension(Objects.toString(name, null), Objects.toString(value2, null)));
            }
        }
    }

    public static void deserializeRtcpFbs(JSONArray rtcpFbs, PayloadTypePacketExtension payloadTypeIQ) {
        if (rtcpFbs != null) {
            for (Object iter : rtcpFbs) {
                JSONObject rtcpFb = (JSONObject)iter;
                String type2 = (String)rtcpFb.get("type");
                String subtype = (String)rtcpFb.get("subtype");
                if (type2 == null) continue;
                RtcpFbPacketExtension ext = new RtcpFbPacketExtension();
                ext.setFeedbackType(type2);
                if (subtype != null) {
                    ext.setFeedbackSubtype(subtype);
                }
                payloadTypeIQ.addRtcpFeedbackType(ext);
            }
        }
    }

    public static RTPHdrExtPacketExtension deserializeHeaderExtension(JSONObject headerExtension) {
        RTPHdrExtPacketExtension headerExtensionIQ;
        if (headerExtension == null) {
            headerExtensionIQ = null;
        } else {
            URI uri;
            Long id = (Long)headerExtension.get("id");
            String uriString = (String)headerExtension.get("uri");
            try {
                uri = new URI(uriString);
            }
            catch (URISyntaxException e) {
                uri = null;
            }
            if (uri != null) {
                headerExtensionIQ = new RTPHdrExtPacketExtension();
                headerExtensionIQ.setID(String.valueOf(id));
                headerExtensionIQ.setURI(uri);
            } else {
                headerExtensionIQ = null;
            }
        }
        return headerExtensionIQ;
    }

    public static Collection<RTPHdrExtPacketExtension> deserializeHeaderExtensions(JSONArray headerExtensions) {
        ArrayList<RTPHdrExtPacketExtension> headerExtensionIQs = new ArrayList<RTPHdrExtPacketExtension>();
        for (Object headerExtension : headerExtensions) {
            RTPHdrExtPacketExtension headerExtensionIQ = JSONDeserializer.deserializeHeaderExtension((JSONObject)headerExtension);
            if (headerExtensionIQ == null) continue;
            headerExtensionIQs.add(headerExtensionIQ);
        }
        return headerExtensionIQs;
    }

    public static void deserializeHeaderExtensions(JSONArray headerExtensions, ColibriConferenceIQ.Channel channelIQ) {
        if (headerExtensions != null && !headerExtensions.isEmpty()) {
            JSONDeserializer.deserializeHeaderExtensions(headerExtensions).forEach(channelIQ::addRtpHeaderExtension);
        }
    }

    public static PayloadTypePacketExtension deserializePayloadType(JSONObject payloadType) {
        PayloadTypePacketExtension payloadTypeIQ;
        if (payloadType == null) {
            payloadTypeIQ = null;
        } else {
            Object rtcpFbs;
            Object parameters2 = payloadType.get("parameters");
            payloadTypeIQ = new PayloadTypePacketExtension();
            JSONDeserializer.deserializeAbstractPacketExtensionAttributes(payloadType, payloadTypeIQ);
            if (parameters2 != null) {
                JSONDeserializer.deserializeParameters((JSONObject)parameters2, payloadTypeIQ);
            }
            if ((rtcpFbs = payloadType.get("rtcp-fbs")) != null && rtcpFbs instanceof JSONArray) {
                JSONDeserializer.deserializeRtcpFbs((JSONArray)rtcpFbs, payloadTypeIQ);
            }
        }
        return payloadTypeIQ;
    }

    public static Collection<PayloadTypePacketExtension> deserializePayloadTypes(JSONArray payloadTypes) {
        ArrayList<PayloadTypePacketExtension> payloadTypeIQs = new ArrayList<PayloadTypePacketExtension>();
        for (Object payloadType : payloadTypes) {
            payloadTypeIQs.add(JSONDeserializer.deserializePayloadType((JSONObject)payloadType));
        }
        return payloadTypeIQs;
    }

    public static void deserializePayloadTypes(JSONArray payloadTypes, ColibriConferenceIQ.Channel channelIQ) {
        if (payloadTypes != null && !payloadTypes.isEmpty()) {
            JSONDeserializer.deserializePayloadTypes(payloadTypes).forEach(channelIQ::addPayloadType);
        }
    }

    public static ColibriConferenceIQ.SctpConnection deserializeSctpConnection(JSONObject sctpConnection, ColibriConferenceIQ.Content contentIQ) {
        ColibriConferenceIQ.SctpConnection sctpConnectionIQ;
        if (sctpConnection == null) {
            sctpConnectionIQ = null;
        } else {
            Object port2 = sctpConnection.get("port");
            sctpConnectionIQ = new ColibriConferenceIQ.SctpConnection();
            JSONDeserializer.deserializeChannelCommon(sctpConnection, sctpConnectionIQ);
            if (port2 != null) {
                sctpConnectionIQ.setPort(JSONDeserializer.objectToInteger(port2));
            }
            contentIQ.addSctpConnection(sctpConnectionIQ);
        }
        return sctpConnectionIQ;
    }

    public static void deserializeSctpConnections(JSONArray sctpConnections, ColibriConferenceIQ.Content contentIQ) {
        if (sctpConnections != null && !sctpConnections.isEmpty()) {
            for (Object sctpConnection : sctpConnections) {
                JSONDeserializer.deserializeSctpConnection((JSONObject)sctpConnection, contentIQ);
            }
        }
    }

    public static SourcePacketExtension deserializeSource(Object source) {
        SourcePacketExtension sourceIQ;
        if (source == null) {
            sourceIQ = null;
        } else if (source instanceof Number || source instanceof String) {
            long ssrc;
            try {
                ssrc = JSONDeserializer.deserializeSSRC(source);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            sourceIQ = new SourcePacketExtension();
            sourceIQ.setSSRC(ssrc);
        } else if (source instanceof JSONObject) {
            long ssrc;
            JSONObject sourceJSONObject = (JSONObject)source;
            Object ssrcAttr = sourceJSONObject.get("ssrc");
            try {
                ssrc = JSONDeserializer.deserializeSSRC(ssrcAttr);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            sourceIQ = new SourcePacketExtension();
            sourceIQ.setSSRC(ssrc);
            Object name = sourceJSONObject.get("name");
            Object videoType = sourceJSONObject.get("videoType");
            Object rid = sourceJSONObject.get("rid");
            Object parameters2 = sourceJSONObject.get("parameters");
            if (name instanceof String) {
                sourceIQ.setName((String)name);
            }
            if (videoType instanceof String) {
                sourceIQ.setVideoType((String)videoType);
            }
            if (rid instanceof String) {
                sourceIQ.setRid((String)rid);
            }
            if (parameters2 instanceof JSONObject) {
                for (Map.Entry entry : ((JSONObject)parameters2).entrySet()) {
                    Object paramName = entry.getKey();
                    Object paramValue = entry.getValue();
                    if (paramName == null && paramValue == null) continue;
                    sourceIQ.addParameter(new ParameterPacketExtension(Objects.toString(paramName, null), Objects.toString(paramValue, null)));
                }
            }
        } else {
            sourceIQ = null;
        }
        return sourceIQ;
    }

    public static SourcePacketExtension deserializeSource(Object source, ColibriConferenceIQ.Channel channelIQ) {
        SourcePacketExtension sourcePacketExtension = JSONDeserializer.deserializeSource(source);
        if (sourcePacketExtension != null) {
            channelIQ.addSource(sourcePacketExtension);
        }
        return sourcePacketExtension;
    }

    public static SourceGroupPacketExtension deserializeSourceGroup(Object sourceGroup) {
        SourceGroupPacketExtension sourceGroupIQ;
        if (sourceGroup == null || !(sourceGroup instanceof JSONObject)) {
            sourceGroupIQ = null;
        } else {
            JSONObject sourceGroupJSONObject = (JSONObject)sourceGroup;
            Object semantics = sourceGroupJSONObject.get("semantics");
            if (semantics != null && semantics instanceof String && ((String)semantics).length() != 0) {
                Object sourcesObject = sourceGroupJSONObject.get("sources");
                if (sourcesObject != null && sourcesObject instanceof JSONArray && ((JSONArray)sourcesObject).size() != 0) {
                    JSONArray sourcesJSONArray = (JSONArray)sourcesObject;
                    ArrayList<SourcePacketExtension> sourcePacketExtensions = new ArrayList<SourcePacketExtension>();
                    for (Object source : sourcesJSONArray) {
                        SourcePacketExtension sourcePacketExtension = JSONDeserializer.deserializeSource(source);
                        if (sourcePacketExtension == null) continue;
                        sourcePacketExtensions.add(sourcePacketExtension);
                    }
                    sourceGroupIQ = new SourceGroupPacketExtension();
                    sourceGroupIQ.setSemantics(Objects.toString(semantics));
                    sourceGroupIQ.addSources(sourcePacketExtensions);
                } else {
                    sourceGroupIQ = null;
                }
            } else {
                sourceGroupIQ = null;
            }
        }
        return sourceGroupIQ;
    }

    public static SourceGroupPacketExtension deserializeSourceGroup(Object sourceGroup, ColibriConferenceIQ.Channel channelIQ) {
        SourceGroupPacketExtension sourceGroupPacketExtension = JSONDeserializer.deserializeSourceGroup(sourceGroup);
        if (sourceGroupPacketExtension != null) {
            channelIQ.addSourceGroup(sourceGroupPacketExtension);
        }
        return sourceGroupPacketExtension;
    }

    public static void deserializeSourceGroups(JSONArray sourceGroups, ColibriConferenceIQ.Channel channelIQ) {
        if (sourceGroups != null && !sourceGroups.isEmpty()) {
            for (Object sourceGroup : sourceGroups) {
                JSONDeserializer.deserializeSourceGroup(sourceGroup, channelIQ);
            }
        }
    }

    public static void deserializeSources(JSONArray sources, ColibriConferenceIQ.Channel channelIQ) {
        if (sources != null && !sources.isEmpty()) {
            for (Object source : sources) {
                JSONDeserializer.deserializeSource(source, channelIQ);
            }
        }
    }

    public static int deserializeSSRC(Object o) throws NumberFormatException {
        int i = 0;
        if (o != null) {
            String s2;
            i = o instanceof Number ? ((Number)o).intValue() : ((s2 = o.toString()).startsWith("-") ? Integer.parseInt(s2) : (int)Long.parseLong(s2));
        }
        return i;
    }

    public static void deserializeSSRCs(JSONArray ssrcs, ColibriConferenceIQ.Channel channelIQ) {
        if (ssrcs != null && !ssrcs.isEmpty()) {
            for (Object ssrc : ssrcs) {
                int ssrcIQ;
                try {
                    ssrcIQ = JSONDeserializer.deserializeSSRC(ssrc);
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
                channelIQ.addSSRC(ssrcIQ);
            }
        }
    }

    public static IceUdpTransportPacketExtension deserializeTransport(JSONObject transport) {
        IceUdpTransportPacketExtension transportIQ;
        if (transport == null) {
            transportIQ = null;
        } else {
            Object xmlns = transport.get("xmlns");
            Object fingerprints = transport.get("fingerprints");
            Object candidateList = transport.get("candidates");
            Object webSocketList = transport.get("web-sockets");
            Object remoteCandidate = transport.get("remote-candidate");
            Object rtcpMux = transport.get("rtcp-mux");
            transportIQ = "urn:xmpp:jingle:transports:ice-udp:1".equals(xmlns) ? new IceUdpTransportPacketExtension() : null;
            if (transportIQ != null) {
                JSONDeserializer.deserializeAbstractPacketExtensionAttributes(transport, transportIQ);
                transportIQ.removeAttribute("xmlns");
                transportIQ.removeAttribute("rtcp-mux");
                if (fingerprints != null) {
                    JSONDeserializer.deserializeFingerprints((JSONArray)fingerprints, transportIQ);
                }
                if (candidateList != null) {
                    JSONDeserializer.deserializeCandidates((JSONArray)candidateList, transportIQ);
                }
                if (webSocketList != null) {
                    JSONDeserializer.deserializeWebsockets((JSONArray)webSocketList, transportIQ);
                }
                if (remoteCandidate != null) {
                    JSONDeserializer.deserializeCandidate((JSONObject)remoteCandidate, RemoteCandidatePacketExtension.class, transportIQ);
                }
                if (rtcpMux != null && JSONDeserializer.objectToBoolean(rtcpMux).booleanValue()) {
                    transportIQ.addChildExtension(new IceRtcpmuxPacketExtension());
                }
            }
        }
        return transportIQ;
    }

    public static IceUdpTransportPacketExtension deserializeTransport(JSONObject transport, ColibriConferenceIQ.ChannelBundle channelBundleIQ) {
        IceUdpTransportPacketExtension transportIQ = JSONDeserializer.deserializeTransport(transport);
        if (transportIQ != null) {
            channelBundleIQ.setTransport(transportIQ);
        }
        return transportIQ;
    }

    public static IceUdpTransportPacketExtension deserializeTransport(JSONObject transport, ColibriConferenceIQ.ChannelCommon channelIQ) {
        IceUdpTransportPacketExtension transportIQ = JSONDeserializer.deserializeTransport(transport);
        if (transportIQ != null) {
            channelIQ.setTransport(transportIQ);
        }
        return transportIQ;
    }

    private JSONDeserializer() {
    }
}

