"use strict";

var _events = require("events");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
var __extends = void 0 && (void 0).__extends || function () {
  var extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };

  return function (d, b) {
    extendStatics(d, b);

    function __() {
      this.constructor = d;
    }

    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
}();

module.exports = {};
Object.defineProperty(module.exports, '__esModule', {
  value: true
});

var Util =
/** @class */
function () {
  function Util() {}

  Util.clone = function ($target, config) {
    var recurse = true; // set true so childList we'll always check the first level

    return function copy($target) {
      var elestruct = {
        /** @type {Node} */
        node: $target,
        charData: null,
        attr: null,
        kids: null
      }; // Store current character data of target text or comment node if the config requests
      // those properties to be observed.

      if (config.charData && ($target.nodeType === 3 || $target.nodeType === 8)) {
        elestruct.charData = $target.nodeValue;
      } else {
        // Add attr only if subtree is specified or top level and avoid if
        // attributes is a document object (#13).
        if (config.attr && recurse && $target.nodeType === 1) {
          /**
           * clone live attribute list to an object structure {name: val}
           * @type {Object.<string, string>}
           */
          elestruct.attr = Util.reduce($target.attributes, function (memo, attr) {
            if (!config.afilter || config.afilter[attr.name]) {
              memo[attr.name] = attr.value;
            }

            return memo;
          }, {});
        } // whether we should iterate the children of $target node


        if (recurse && (config.kids || config.charData || config.attr && config.descendents)) {
          /** @type {Array.<!Object>} : Array of custom clone */
          elestruct.kids = Util.map($target.childNodes, copy);
        }

        recurse = config.descendents;
      }

      return elestruct;
    }($target);
  };
  /**
   * indexOf an element in a collection of custom nodes
   *
   * @param {NodeList} set
   * @param {!Object} $node : A custom cloned nodeg333
   * @param {number} idx : index to start the loop
   * @return {number}
   */


  Util.indexOfCustomNode = function (set, $node, idx) {
    var JSCompiler_renameProperty = function (a) {
      return a;
    };

    return this.indexOf(set, $node, idx, JSCompiler_renameProperty('node'));
  };
  /**
   * Attempt to uniquely id an element for hashing. We could optimize this for legacy browsers but it hopefully wont be called enough to be a concern
   *
   * @param {Node} $ele
   * @return {(string|number)}
   */


  Util.getElementId = function ($ele) {
    try {
      return $ele.id || ($ele[this.expando] = $ele[this.expando] || this.counter++);
    } catch (e) {
      // ie <8 will throw if you set an unknown property on a text node
      try {
        return $ele.nodeValue; // naive
      } catch (shitie) {
        // when text node is removed: https://gist.github.com/megawac/8355978 :(
        return this.counter++;
      }
    }
  };
  /**
   * **map** Apply a mapping function to each item of a set
   * @param {Array|NodeList} set
   * @param {Function} iterator
   */


  Util.map = function (set, iterator) {
    var results = [];

    for (var index = 0; index < set.length; index++) {
      results[index] = iterator(set[index], index, set);
    }

    return results;
  };
  /**
   * **Reduce** builds up a single result from a list of values
   * @param {Array|NodeList|NamedNodeMap} set
   * @param {Function} iterator
   * @param {*} [memo] Initial value of the memo.
   */


  Util.reduce = function (set, iterator, memo) {
    for (var index = 0; index < set.length; index++) {
      memo = iterator(memo, set[index], index, set);
    }

    return memo;
  };
  /**
   * **indexOf** find index of item in collection.
   * @param {Array|NodeList} set
   * @param {Object} item
   * @param {number} idx
   * @param {string} [prop] Property on set item to compare to item
   */


  Util.indexOf = function (set, item, idx, prop) {
    for (;
    /*idx = ~~idx*/
    idx < set.length; idx++) {
      // start idx is always given as this is internal
      if ((prop ? set[idx][prop] : set[idx]) === item) return idx;
    }

    return -1;
  };
  /**
   * @param {Object} obj
   * @param {(string|number)} prop
   * @return {boolean}
   */


  Util.has = function (obj, prop) {
    return obj[prop] !== undefined; // will be nicely inlined by gcc
  };

  Util.counter = 1;
  Util.expando = 'mo_id';
  return Util;
}();

module.exports.Util = Util;

var MutationObserver =
/** @class */
function () {
  function MutationObserver(listener) {
    var _this = this;

    this._watched = [];
    this._listener = null;
    this._period = 30;
    this._timeout = null;
    this._disposed = false;
    this._notifyListener = null;
    this._watched = [];
    this._listener = listener;
    this._period = 30;

    this._notifyListener = function () {
      _this.scheduleMutationCheck(_this);
    };
  }

  MutationObserver.prototype.observe = function ($target, config) {
    var settings = {
      attr: !!(config.attributes || config.attributeFilter || config.attributeOldValue),
      // some browsers enforce that subtree must be set with childList, attributes or characterData.
      // We don't care as spec doesn't specify this rule.
      kids: !!config.childList,
      descendents: !!config.subtree,
      charData: !!(config.characterData || config.characterDataOldValue),
      afilter: null
    };
    MutationNotifier.getInstance().on('changed', this._notifyListener);
    var watched = this._watched; // remove already observed target element from pool

    for (var i = 0; i < watched.length; i++) {
      if (watched[i].tar === $target) watched.splice(i, 1);
    }

    if (config.attributeFilter) {
      /**
       * converts to a {key: true} dict for faster lookup
       * @type {Object.<String,Boolean>}
       */
      settings.afilter = Util.reduce(config.attributeFilter, function (a, b) {
        a[b] = true;
        return a;
      }, {});
    }

    watched.push({
      tar: $target,
      fn: this.createMutationSearcher($target, settings)
    });
  };

  MutationObserver.prototype.takeRecords = function () {
    var mutations = [];
    var watched = this._watched;

    for (var i = 0; i < watched.length; i++) {
      watched[i].fn(mutations);
    }

    return mutations;
  };

  MutationObserver.prototype.disconnect = function () {
    this._watched = []; // clear the stuff being observed

    MutationNotifier.getInstance().removeListener('changed', this._notifyListener);
    this._disposed = true;
    clearTimeout(this._timeout); // ready for garbage collection

    this._timeout = null;
  };

  MutationObserver.prototype.createMutationSearcher = function ($target, config) {
    var _this = this;
    /** type {Elestuct} */


    var $oldstate = Util.clone($target, config); // create the cloned datastructure

    /**
     * consumes array of mutations we can push to
     *
     * @param {Array.<MutationRecord>} mutations
     */

    return function (mutations) {
      var olen = mutations.length;
      var dirty;

      if (config.charData && $target.nodeType === 3 && $target.nodeValue !== $oldstate.charData) {
        mutations.push(new MutationRecord({
          type: 'characterData',
          target: $target,
          oldValue: $oldstate.charData
        }));
      } // Alright we check base level changes in attributes... easy


      if (config.attr && $oldstate.attr) {
        _this.findAttributeMutations(mutations, $target, $oldstate.attr, config.afilter);
      } // check childlist or subtree for mutations


      if (config.kids || config.descendents) {
        dirty = _this.searchSubtree(mutations, $target, $oldstate, config);
      } // reclone data structure if theres changes


      if (dirty || mutations.length !== olen) {
        /** type {Elestuct} */
        $oldstate = Util.clone($target, config);
      }
    };
  };

  MutationObserver.prototype.scheduleMutationCheck = function (observer) {
    var _this = this; // Only schedule if there isn't already a timer.


    if (!observer._timeout) {
      observer._timeout = setTimeout(function () {
        return _this.mutationChecker(observer);
      }, this._period);
    }
  };

  MutationObserver.prototype.mutationChecker = function (observer) {
    // allow scheduling a new timer.
    observer._timeout = null;
    var mutations = observer.takeRecords();

    if (mutations.length) {
      // fire away
      // calling the listener with context is not spec but currently consistent with FF and WebKit
      observer._listener(mutations, observer);
    }
  };

  MutationObserver.prototype.searchSubtree = function (mutations, $target, $oldstate, config) {
    var _this = this; // Track if the tree is dirty and has to be recomputed (#14).


    var dirty;
    /*
     * Helper to identify node rearrangment and stuff...
     * There is no gaurentee that the same node will be identified for both added and removed nodes
     * if the positions have been shuffled.
     * conflicts array will be emptied by end of operation
     */

    var _resolveConflicts = function (conflicts, node, $kids, $oldkids, numAddedNodes) {
      // the distance between the first conflicting node and the last
      var distance = conflicts.length - 1; // prevents same conflict being resolved twice consider when two nodes switch places.
      // only one should be given a mutation event (note -~ is used as a math.ceil shorthand)

      var counter = -~((distance - numAddedNodes) / 2);
      var $cur;
      var oldstruct;
      var conflict;

      while (conflict = conflicts.pop()) {
        $cur = $kids[conflict.i];
        oldstruct = $oldkids[conflict.j]; // attempt to determine if there was node rearrangement... won't gaurentee all matches
        // also handles case where added/removed nodes cause nodes to be identified as conflicts

        if (config.kids && counter && Math.abs(conflict.i - conflict.j) >= distance) {
          mutations.push(new MutationRecord({
            type: 'childList',
            target: node,
            addedNodes: [$cur],
            removedNodes: [$cur],
            // haha don't rely on this please
            nextSibling: $cur.nextSibling,
            previousSibling: $cur.previousSibling
          }));
          counter--; // found conflict
        } // Alright we found the resorted nodes now check for other types of mutations


        if (config.attr && oldstruct.attr) _this.findAttributeMutations(mutations, $cur, oldstruct.attr, config.afilter);

        if (config.charData && $cur.nodeType === 3 && $cur.nodeValue !== oldstruct.charData) {
          mutations.push(new MutationRecord({
            type: 'characterData',
            target: $cur,
            oldValue: oldstruct.charData
          }));
        } // now look @ subtree


        if (config.descendents) _findMutations($cur, oldstruct);
      }
    };
    /**
     * Main worker. Finds and adds mutations if there are any
     * @param {Node} node
     * @param {!Object} old : A cloned data structure using internal clone
     */


    var _findMutations = function (node, old) {
      var $kids = node.childNodes;
      var $oldkids = old.kids;
      var klen = $kids.length; // $oldkids will be undefined for text and comment nodes

      var olen = $oldkids ? $oldkids.length : 0; // if (!olen && !klen) return; // both empty; clearly no changes
      // we delay the intialization of these for marginal performance in the expected case (actually quite signficant on large subtrees when these would be otherwise unused)
      // map of checked element of ids to prevent registering the same conflict twice

      var map; // array of potential conflicts (ie nodes that may have been re arranged)

      var conflicts;
      var id; // element id from getElementId helper

      var idx; // index of a moved or inserted element

      var oldstruct; // current and old nodes

      var $cur;
      var $old; // track the number of added nodes so we can resolve conflicts more accurately

      var numAddedNodes = 0; // iterate over both old and current child nodes at the same time

      var i = 0;
      var j = 0; // while there is still anything left in $kids or $oldkids (same as i < $kids.length || j < $oldkids.length;)

      while (i < klen || j < olen) {
        // current and old nodes at the indexs
        $cur = $kids[i];
        oldstruct = $oldkids[j];
        $old = oldstruct && oldstruct.node;

        if ($cur === $old) {
          // expected case - optimized for this case
          // check attributes as specified by config
          if (config.attr && oldstruct.attr) {
            /* oldstruct.attr instead of textnode check */
            _this.findAttributeMutations(mutations, $cur, oldstruct.attr, config.afilter);
          } // check character data if node is a comment or textNode and it's being observed


          if (config.charData && oldstruct.charData !== undefined && $cur.nodeValue !== oldstruct.charData) {
            mutations.push(new MutationRecord({
              type: 'characterData',
              target: $cur
            }));
          } // resolve conflicts; it will be undefined if there are no conflicts - otherwise an array


          if (conflicts) _resolveConflicts(conflicts, node, $kids, $oldkids, numAddedNodes); // recurse on next level of children. Avoids the recursive call when there are no children left to iterate

          if (config.descendents && ($cur.childNodes.length || oldstruct.kids && oldstruct.kids.length)) _findMutations($cur, oldstruct);
          i++;
          j++;
        } else {
          // (uncommon case) lookahead until they are the same again or the end of children
          dirty = true;

          if (!map) {
            // delayed initalization (big perf benefit)
            map = {};
            conflicts = [];
          }

          if ($cur) {
            // check id is in the location map otherwise do a indexOf search
            if (!map[id = Util.getElementId($cur)]) {
              // to prevent double checking
              // mark id as found
              map[id] = true; // custom indexOf using comparitor checking oldkids[i].node === $cur

              if ((idx = Util.indexOfCustomNode($oldkids, $cur, j)) === -1) {
                if (config.kids) {
                  mutations.push(new MutationRecord({
                    type: 'childList',
                    target: node,
                    addedNodes: [$cur],
                    nextSibling: $cur.nextSibling,
                    previousSibling: $cur.previousSibling
                  }));
                  numAddedNodes++;
                }
              } else {
                conflicts.push({
                  i: i,
                  j: idx
                });
              }
            }

            i++;
          }

          if ($old && // special case: the changes may have been resolved: i and j appear congurent so we can continue using the expected case
          $old !== $kids[i]) {
            if (!map[id = Util.getElementId($old)]) {
              map[id] = true;

              if ((idx = Util.indexOf($kids, $old, i)) === -1) {
                if (config.kids) {
                  mutations.push(new MutationRecord({
                    type: 'childList',
                    target: old.node,
                    removedNodes: [$old],
                    nextSibling: $oldkids[j + 1],
                    previousSibling: $oldkids[j - 1]
                  }));
                  numAddedNodes--;
                }
              } else {
                conflicts.push({
                  i: idx,
                  j: j
                });
              }
            }

            j++;
          }
        } // end uncommon case

      } // end loop
      // resolve any remaining conflicts


      if (conflicts) _resolveConflicts(conflicts, node, $kids, $oldkids, numAddedNodes);
    };

    _findMutations($target, $oldstate);

    return dirty;
  };

  MutationObserver.prototype.findAttributeMutations = function (mutations, $target, $oldstate, filter) {
    var checked = {};
    var attributes = $target.attributes;
    var attr;
    var name;
    var i = attributes.length;

    while (i--) {
      attr = attributes[i];
      name = attr.name;

      if (!filter || Util.has(filter, name)) {
        if (attr.value !== $oldstate[name]) {
          // The pushing is redundant but gzips very nicely
          mutations.push(new MutationRecord({
            type: 'attributes',
            target: $target,
            attributeName: name,
            oldValue: $oldstate[name],
            attributeNamespace: attr.namespaceURI // in ie<8 it incorrectly will return undefined

          }));
        }

        checked[name] = true;
      }
    }

    for (name in $oldstate) {
      if (!checked[name]) {
        mutations.push(new MutationRecord({
          target: $target,
          type: 'attributes',
          attributeName: name,
          oldValue: $oldstate[name]
        }));
      }
    }
  };

  return MutationObserver;
}();

module.exports.MutationObserver = MutationObserver;

var MutationRecord =
/** @class */
function () {
  function MutationRecord(data) {
    var settings = {
      type: null,
      target: null,
      addedNodes: [],
      removedNodes: [],
      previousSibling: null,
      nextSibling: null,
      attributeName: null,
      attributeNamespace: null,
      oldValue: null
    };

    for (var prop in data) {
      if (Util.has(settings, prop) && data[prop] !== undefined) settings[prop] = data[prop];
    }

    return settings;
  }

  return MutationRecord;
}();

module.exports.MutationRecord = MutationRecord;

var MutationNotifier =
/** @class */
function (_super) {
  __extends(MutationNotifier, _super);

  function MutationNotifier() {
    var _this = _super.call(this) || this;

    _this.setMaxListeners(100);

    return _this;
  }

  MutationNotifier.getInstance = function () {
    if (!MutationNotifier._instance) {
      MutationNotifier._instance = new MutationNotifier();
    }

    return MutationNotifier._instance;
  };

  MutationNotifier.prototype.destruct = function () {
    this.removeAllListeners('changed');
  };

  MutationNotifier.prototype.notifyChanged = function (node) {
    this.emit('changed', node);
  };

  MutationNotifier._instance = null;
  return MutationNotifier;
}(_events.EventEmitter);

module.exports.MutationNotifier = MutationNotifier;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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