"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityPlugin = void 0;

var _operators = require("rxjs/operators");

var _routes = require("./routes");

var _opensearch_security_configuration_plugin = _interopRequireDefault(require("./backend/opensearch_security_configuration_plugin"));

var _opensearch_security_plugin = _interopRequireDefault(require("./backend/opensearch_security_plugin"));

var _security_cookie = require("./session/security_cookie");

var _opensearch_security_client = require("./backend/opensearch_security_client");

var _tenant_index = require("./multitenancy/tenant_index");

var _auth_handler_factory = require("./auth/auth_handler_factory");

var _routes2 = require("./multitenancy/routes");

var _auth_type_routes = require("./routes/auth_type_routes");

var _core = require("../../../src/core/server/saved_objects/migrations/core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class SecurityPlugin {
  // FIXME: keep an reference of admin client so that it can be used in start(), better to figureout a
  //        decent way to get adminClient in start. (maybe using getStartServices() from setup?)
  // @ts-ignore: property not initialzied in constructor
  constructor(initializerContext) {
    this.initializerContext = initializerContext;

    _defineProperty(this, "logger", void 0);

    _defineProperty(this, "securityClient", void 0);

    this.logger = initializerContext.logger.get();
  }

  async setup(core) {
    var _config$multitenancy;

    this.logger.debug('opendistro_security: Setup');
    const config$ = this.initializerContext.config.create();
    const config = await config$.pipe((0, _operators.first)()).toPromise();
    const router = core.http.createRouter();
    const esClient = core.opensearch.legacy.createClient('opendistro_security', {
      plugins: [_opensearch_security_configuration_plugin.default, _opensearch_security_plugin.default]
    });
    this.securityClient = new _opensearch_security_client.SecurityClient(esClient);
    const securitySessionStorageFactory = await core.http.createCookieSessionStorageFactory((0, _security_cookie.getSecurityCookieOptions)(config)); // put logger into route handler context, so that we don't need to pass througth parameters

    core.http.registerRouteHandlerContext('security_plugin', (context, request) => {
      return {
        logger: this.logger,
        esClient
      };
    }); // setup auth

    const auth = (0, _auth_handler_factory.getAuthenticationHandler)(config.auth.type, router, config, core, esClient, securitySessionStorageFactory, this.logger);
    core.http.registerAuth(auth.authHandler); // Register server side APIs

    (0, _routes.defineRoutes)(router);
    (0, _auth_type_routes.defineAuthTypeRoutes)(router, config); // set up multi-tenent routes

    if ((_config$multitenancy = config.multitenancy) !== null && _config$multitenancy !== void 0 && _config$multitenancy.enabled) {
      (0, _routes2.setupMultitenantRoutes)(router, securitySessionStorageFactory, this.securityClient);
    }

    return {
      config$,
      securityConfigClient: esClient
    };
  } // TODO: add more logs


  async start(core) {
    var _config$multitenancy2;

    this.logger.debug('opendistro_security: Started');
    const config$ = this.initializerContext.config.create();
    const config = await config$.pipe((0, _operators.first)()).toPromise();

    if ((_config$multitenancy2 = config.multitenancy) !== null && _config$multitenancy2 !== void 0 && _config$multitenancy2.enabled) {
      const globalConfig$ = this.initializerContext.config.legacy.globalConfig$;
      const globalConfig = await globalConfig$.pipe((0, _operators.first)()).toPromise();
      const opensearchDashboardsIndex = globalConfig.opensearchDashboards.index;
      const typeRegistry = core.savedObjects.getTypeRegistry();
      const esClient = core.opensearch.client.asInternalUser;
      const migrationClient = (0, _core.createMigrationOpenSearchClient)(esClient, this.logger);
      (0, _tenant_index.setupIndexTemplate)(esClient, opensearchDashboardsIndex, typeRegistry, this.logger);
      const serializer = core.savedObjects.createSerializer();
      const opensearchDashboardsVersion = this.initializerContext.env.packageInfo.version;
      (0, _tenant_index.migrateTenantIndices)(opensearchDashboardsVersion, migrationClient, this.securityClient, typeRegistry, serializer, this.logger);
    }

    return {
      es: core.opensearch.legacy
    };
  }

  stop() {}

}

exports.SecurityPlugin = SecurityPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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